/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureModelFactory;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.InstallHandlerEntryModel;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultFeatureParser
extends DefaultHandler {
    private SAXParser parser;
    private FeatureModelFactory factory;
    private MultiStatus status;
    private boolean URL_ALREADY_SEEN = false;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_INCLUDES = 1;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_HANDLER = 3;
    private static final int STATE_DESCRIPTION = 4;
    private static final int STATE_COPYRIGHT = 5;
    private static final int STATE_LICENSE = 6;
    private static final int STATE_URL = 7;
    private static final int STATE_UPDATE = 8;
    private static final int STATE_DISCOVERY = 9;
    private static final int STATE_REQUIRES = 10;
    private static final int STATE_IMPORT = 11;
    private static final int STATE_PLUGIN = 12;
    private static final int STATE_DATA = 13;
    private static final String PLUGIN_ID = AppPlugin.getPlugin().getBundle().getSymbolicName();
    private static final String FEATURE = "feature";
    private static final String INCLUDES = "includes";
    private static final String HANDLER = "install-handler";
    private static final String DESCRIPTION = "description";
    private static final String COPYRIGHT = "copyright";
    private static final String LICENSE = "license";
    private static final String URL = "url";
    private static final String UPDATE = "update";
    private static final String DISCOVERY = "discovery";
    private static final String REQUIRES = "requires";
    private static final String IMPORT = "import";
    private static final String PLUGIN = "plugin";
    private static final String DATA = "data";
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    private int currentState;
    private String location;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public DefaultFeatureParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            AppPlugin.log(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            AppPlugin.log(sAXException);
        }
    }

    public void init(FeatureModelFactory featureModelFactory) {
        this.init(featureModelFactory, null);
    }

    public void init(FeatureModelFactory featureModelFactory, String string) {
        this.factory = featureModelFactory;
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        this.status = null;
        this.URL_ALREADY_SEEN = false;
        this.location = string;
    }

    public FeatureModel parse(InputStream inputStream) throws SAXException, IOException {
        this.stateStack.push(new Integer(0));
        this.currentState = (Integer)this.stateStack.peek();
        this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Messages.DefaultFeatureParser_NoFeatureTag);
        }
        if (this.objectStack.peek() instanceof FeatureModel) {
            return (FeatureModel)((Object)this.objectStack.pop());
        }
        String string = "";
        Iterator iterator = this.objectStack.iterator();
        while (iterator.hasNext()) {
            string = "\r\n" + iterator.next().toString() + string;
        }
        throw new SAXException(NLS.bind((String)Messages.DefaultFeatureParser_WrongParsingStack, (Object[])new String[]{string}));
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("Start Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        }
        switch (this.currentState) {
            case -1: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string2, this.getState(this.currentState)}));
                break;
            }
            case 0: {
                this.handleInitialState(string2, attributes);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleFeatureState(string2, attributes);
                break;
            }
            case 7: {
                if (this.URL_ALREADY_SEEN) {
                    this.internalError(Messages.DefaultFeatureParser_TooManyURLtag);
                }
                this.handleURLState(string2, attributes);
                break;
            }
            case 8: 
            case 9: {
                this.handleUpdateDiscoveryState(string2, attributes);
                break;
            }
            case 10: {
                this.handleRequiresState(string2, attributes);
                break;
            }
            case 11: {
                this.handleImportState(string2, attributes);
                break;
            }
            case 12: 
            case 13: {
                this.handleFeatureState(string2, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownStartState, (Object[])new String[]{Integer.toString(this.currentState)}));
            }
        }
        int n = (Integer)this.stateStack.peek();
        if (n != -1) {
            this.currentState = n;
        }
    }

    public void endElement(String string, String string2, String string3) {
        URLEntryModel uRLEntryModel = null;
        FeatureModel featureModel = null;
        String string4 = null;
        int n = 0;
        int n2 = (Integer)this.stateStack.peek();
        block0 : switch (n2) {
            case -1: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Messages.DefaultFeatureParser_ParsingStackBackToInitialState);
                break;
            }
            case 2: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                string4 = (String)this.objectStack.pop();
                FeatureModel featureModel2 = (FeatureModel)((Object)this.objectStack.peek());
                featureModel2.getDescriptionModel().setAnnotation(string4);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof IncludedFeatureReferenceModel)) break;
                IncludedFeatureReferenceModel includedFeatureReferenceModel = (IncludedFeatureReferenceModel)this.objectStack.pop();
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addIncludedFeatureReferenceModel(includedFeatureReferenceModel);
                break;
            }
            case 3: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof InstallHandlerEntryModel)) break;
                InstallHandlerEntryModel installHandlerEntryModel = (InstallHandlerEntryModel)((Object)this.objectStack.pop());
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                if (featureModel.getInstallHandlerModel() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_ElementAlreadySet, (Object[])new String[]{this.getState(n2)}));
                    break;
                }
                featureModel.setInstallHandlerModel(installHandlerEntryModel);
                break;
            }
            case 4: {
                this.stateStack.pop();
                string4 = "";
                while (this.objectStack.peek() instanceof String) {
                    string4 = String.valueOf((String)this.objectStack.pop()) + string4;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if ((string4 = this.cleanupText(string4)) != null) {
                    uRLEntryModel.setAnnotation(string4);
                }
                n = (Integer)this.stateStack.peek();
                switch (n) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getDescriptionModel() != null) {
                            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_ElementAlreadySet, (Object[])new String[]{this.getState(n2)}));
                            break;
                        }
                        featureModel.setDescriptionModel(uRLEntryModel);
                        break;
                    }
                    default: {
                        this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_StateIncludeWrongElement, (Object[])new String[]{this.getState(n), this.getState(n2)}));
                        break;
                    }
                }
                break;
            }
            case 5: {
                this.stateStack.pop();
                string4 = "";
                while (this.objectStack.peek() instanceof String) {
                    string4 = String.valueOf((String)this.objectStack.pop()) + string4;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if ((string4 = this.cleanupText(string4)) != null) {
                    uRLEntryModel.setAnnotation(string4);
                }
                n = (Integer)this.stateStack.peek();
                switch (n) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getCopyrightModel() != null) {
                            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_ElementAlreadySet, (Object[])new String[]{this.getState(n2)}));
                            break;
                        }
                        featureModel.setCopyrightModel(uRLEntryModel);
                        break;
                    }
                    default: {
                        this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_StateIncludeWrongElement, (Object[])new String[]{this.getState(n), this.getState(n2)}));
                        break;
                    }
                }
                break;
            }
            case 6: {
                this.stateStack.pop();
                string4 = "";
                while (this.objectStack.peek() instanceof String) {
                    string4 = String.valueOf((String)this.objectStack.pop()) + string4;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if ((string4 = this.cleanupText(string4)) != null) {
                    uRLEntryModel.setAnnotation(string4);
                }
                n = (Integer)this.stateStack.peek();
                switch (n) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getLicenseModel() != null) {
                            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_ElementAlreadySet, (Object[])new String[]{this.getState(n2)}));
                            break;
                        }
                        featureModel.setLicenseModel(uRLEntryModel);
                        break;
                    }
                    default: {
                        this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_StateIncludeWrongElement, (Object[])new String[]{this.getState(n), this.getState(n2)}));
                        break;
                    }
                }
                break;
            }
            case 7: {
                this.stateStack.pop();
                this.URL_ALREADY_SEEN = true;
                break;
            }
            case 8: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                if (featureModel.getUpdateSiteEntryModel() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_ElementAlreadySet, (Object[])new String[]{this.getState(n2)}));
                    break;
                }
                featureModel.setUpdateSiteEntryModel(uRLEntryModel);
                break;
            }
            case 9: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addDiscoverySiteEntryModel(uRLEntryModel);
                break;
            }
            case 10: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                ImportModel[] importModelArray = featureModel.getImportModels();
                if (importModelArray.length == 0) {
                    this.internalError(Messages.DefaultFeatureParser_RequireStateWithoutImportElement);
                    break;
                }
                boolean bl = false;
                int n3 = 0;
                while (n3 < importModelArray.length) {
                    ImportModel importModel = importModelArray[n3];
                    if (importModel.isPatch()) {
                        if (!bl) {
                            bl = true;
                        } else {
                            this.internalError(Messages.DefaultFeatureParser_MultiplePatchImports);
                            break block0;
                        }
                    }
                    ++n3;
                }
                break;
            }
            case 11: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof ImportModel)) break;
                ImportModel importModel = (ImportModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addImportModel(importModel);
                break;
            }
            case 12: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof PluginEntryModel)) break;
                PluginEntryModel pluginEntryModel = (PluginEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addPluginEntryModel(pluginEntryModel);
                break;
            }
            case 13: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof NonPluginEntryModel)) break;
                NonPluginEntryModel nonPluginEntryModel = (NonPluginEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addNonPluginEntryModel(nonPluginEntryModel);
                break;
            }
            default: {
                this.internalErrorUnknownTag(String.valueOf(Messages.DefaultFeatureParser_UnknownEndState) + n2);
            }
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("End Element:" + string + ":" + string2 + ":" + string3);
        }
    }

    private String cleanupText(String string) {
        if ("".equals(string = string.trim())) {
            return null;
        }
        return string;
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3;
        String string = "";
        boolean bl = true;
        if (bl) {
            string = new String(cArray, n, n2);
        }
        if ((n3 = ((Integer)this.stateStack.peek()).intValue()) == 4 || n3 == 5 || n3 == 6) {
            this.objectStack.push(string);
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logStatus(sAXParseException);
        throw sAXParseException;
    }

    private void handleInitialState(String string, Attributes attributes) throws SAXException {
        if (string.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleFeatureState(String string, Attributes attributes) throws SAXException {
        if (string.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (string.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (string.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (string.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (string.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (string.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (string.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleURLState(String string, Attributes attributes) throws SAXException {
        if (string.equals(UPDATE)) {
            this.stateStack.push(new Integer(8));
            this.processURLInfo(attributes);
        } else if (string.equals(DISCOVERY)) {
            this.stateStack.push(new Integer(9));
            this.processURLInfo(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleRequiresState(String string, Attributes attributes) throws SAXException {
        if (string.equals(IMPORT)) {
            this.stateStack.push(new Integer(11));
            this.processImport(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleUpdateDiscoveryState(String string, Attributes attributes) throws SAXException {
        if (string.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (string.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (string.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (string.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (string.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (string.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (string.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else if (string.equals(UPDATE)) {
            this.stateStack.push(new Integer(8));
            this.processURLInfo(attributes);
        } else if (string.equals(DISCOVERY)) {
            this.stateStack.push(new Integer(9));
            this.processURLInfo(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleImportState(String string, Attributes attributes) throws SAXException {
        if (string.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (string.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (string.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (string.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (string.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (string.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (string.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else if (string.equals(IMPORT)) {
            this.stateStack.push(new Integer(11));
            this.processImport(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultFeatureParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void processFeature(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])new String[]{string, string2, this.getState(this.currentState)}));
        } else {
            FeatureModel featureModel = this.factory.createFeatureModel();
            featureModel.setFeatureIdentifier(string);
            featureModel.setFeatureVersion(string2);
            String string3 = attributes.getValue("label");
            featureModel.setLabel(string3);
            String string4 = attributes.getValue("provider-name");
            featureModel.setProvider(string4);
            String string5 = attributes.getValue("image");
            featureModel.setImageURLString(string5);
            String string6 = attributes.getValue("os");
            featureModel.setOS(string6);
            String string7 = attributes.getValue("ws");
            featureModel.setWS(string7);
            String string8 = attributes.getValue("nl");
            featureModel.setNL(string8);
            String string9 = attributes.getValue("arch");
            featureModel.setArch(string9);
            String string10 = attributes.getValue("primary");
            featureModel.setPrimary(string10 != null && string10.trim().equalsIgnoreCase("true"));
            String string11 = attributes.getValue("exclusive");
            featureModel.setExclusive(string11 != null && string11.trim().equalsIgnoreCase("true"));
            String string12 = attributes.getValue("application");
            featureModel.setApplication(string12);
            String string13 = attributes.getValue("colocation-affinity");
            featureModel.setAffinityFeature(string13);
            String string14 = attributes.getValue(PLUGIN);
            featureModel.setPrimaryPluginID(string14);
            this.objectStack.push(featureModel);
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                this.debug("End process DefaultFeature tag: id:" + string + " ver:" + string2 + " label:" + string3 + " provider:" + string4);
                this.debug("End process DefaultFeature tag: image:" + string5);
                this.debug("End process DefaultFeature tag: ws:" + string7 + " os:" + string6 + " nl:" + string8 + " application:" + string12);
            }
        }
    }

    private void processHandler(Attributes attributes) {
        InstallHandlerEntryModel installHandlerEntryModel = this.factory.createInstallHandlerEntryModel();
        String string = attributes.getValue(URL);
        installHandlerEntryModel.setURLString(string);
        String string2 = attributes.getValue("library");
        installHandlerEntryModel.setLibrary(string2);
        String string3 = attributes.getValue("handler");
        installHandlerEntryModel.setHandlerName(string3);
        this.objectStack.push(installHandlerEntryModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("Processed Handler: url:" + string + " library:" + string2 + " class:" + string3);
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntryModel uRLEntryModel = this.factory.createURLEntryModel();
        String string = attributes.getValue(URL);
        uRLEntryModel.setURLString(string);
        this.objectStack.push(uRLEntryModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("Processed Info: url:" + string);
        }
    }

    private void processIncludes(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])new String[]{string, string2, this.getState(this.currentState)}));
        }
        IncludedFeatureReferenceModel includedFeatureReferenceModel = this.factory.createIncludedFeatureReferenceModel();
        includedFeatureReferenceModel.setFeatureIdentifier(string);
        includedFeatureReferenceModel.setFeatureVersion(string2);
        String string3 = attributes.getValue("name");
        includedFeatureReferenceModel.setLabel(string3);
        String string4 = attributes.getValue("optional");
        boolean bl = "true".equalsIgnoreCase(string4);
        includedFeatureReferenceModel.isOptional(bl);
        String string5 = attributes.getValue("search-location");
        if (string5 == null) {
            string5 = attributes.getValue("search_location");
        }
        int n = 2;
        if ("both".equalsIgnoreCase(string5)) {
            n = 0;
        }
        if ("self".equalsIgnoreCase(string5)) {
            n = 4;
        }
        includedFeatureReferenceModel.setSearchLocation(n);
        String string6 = attributes.getValue("os");
        includedFeatureReferenceModel.setOS(string6);
        String string7 = attributes.getValue("ws");
        includedFeatureReferenceModel.setWS(string7);
        String string8 = attributes.getValue("arch");
        includedFeatureReferenceModel.setArch(string8);
        String string9 = attributes.getValue("nl");
        includedFeatureReferenceModel.setNL(string9);
        this.objectStack.push(includedFeatureReferenceModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("End process Includes tag: id:" + string + " ver:" + string2);
            this.debug("name =" + string3 + " optional=" + string4 + " search-location=" + string5);
            this.debug("os=" + string6 + " ws=" + string7 + " arch=" + string8);
        }
    }

    private void processURLInfo(Attributes attributes) {
        URLEntryModel uRLEntryModel = this.factory.createURLEntryModel();
        String string = attributes.getValue(URL);
        String string2 = attributes.getValue("label");
        String string3 = attributes.getValue("type");
        uRLEntryModel.setURLString(string);
        uRLEntryModel.setAnnotation(string2);
        if ("web".equalsIgnoreCase(string3)) {
            uRLEntryModel.setType(1);
        } else {
            uRLEntryModel.setType(0);
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            this.debug("Processed URLInfo: url:" + string + " label:" + string2 + " type:" + string3);
        }
        this.objectStack.push(uRLEntryModel);
    }

    private void processImport(Attributes attributes) {
        String string = attributes.getValue(PLUGIN);
        String string2 = attributes.getValue(FEATURE);
        String string3 = attributes.getValue("id-match");
        if (!(string == null ^ string2 == null)) {
            this.internalError(Messages.DefaultFeatureParser_PluginAndFeatureId);
            return;
        }
        String string4 = null;
        string4 = string == null ? string2 : string;
        if (string4 == null || string4.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_MissingId, (Object[])new String[]{this.getState(this.currentState)}));
        } else {
            ImportModel importModel = this.factory.createImportModel();
            String string5 = attributes.getValue("version");
            String string6 = attributes.getValue("match");
            String string7 = attributes.getValue("patch");
            importModel.setPatch(string7 != null && string7.equalsIgnoreCase("true"));
            if (string5 == null) {
                if (importModel.isPatch()) {
                    this.internalError(Messages.DefaultFeatureParser_MissingPatchVersion);
                }
                string5 = "0.0.0";
                string6 = "greaterOrEqual";
            } else if (string6 == null) {
                string6 = importModel.isPatch() ? "perfect" : "compatible";
            }
            importModel.setIdentifier(string4);
            importModel.setVersion(string5);
            importModel.setFeatureImport(string2 != null);
            importModel.setMatchingRuleName(string6);
            importModel.setMatchingIdRuleName(string3);
            if (importModel.isPatch()) {
                if (string6 != null && !string6.equalsIgnoreCase("perfect")) {
                    this.internalError(Messages.DefaultFeatureParser_wrongMatchForPatch);
                }
                if (!importModel.isFeatureImport()) {
                    importModel.setPatch(false);
                    this.internalError(Messages.DefaultFeatureParser_patchWithPlugin);
                }
            }
            String string8 = attributes.getValue("os");
            importModel.setOS(string8);
            String string9 = attributes.getValue("ws");
            importModel.setWS(string9);
            String string10 = attributes.getValue("arch");
            importModel.setOSArch(string10);
            this.objectStack.push(importModel);
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                this.debug("Processed import: id:" + string4 + " ver:" + string5);
                this.debug("Processed import: match:" + string6);
            }
        }
    }

    private void processRequire(Attributes attributes) {
    }

    private void processPlugin(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])new String[]{string, string2, this.getState(this.currentState)}));
        } else {
            PluginEntryModel pluginEntryModel = this.factory.createPluginEntryModel();
            pluginEntryModel.setPluginIdentifier(string);
            pluginEntryModel.setPluginVersion(string2);
            String string3 = attributes.getValue("fragment");
            pluginEntryModel.isFragment(string3 != null && string3.trim().equalsIgnoreCase("true"));
            String string4 = attributes.getValue("os");
            pluginEntryModel.setOS(string4);
            String string5 = attributes.getValue("ws");
            pluginEntryModel.setWS(string5);
            String string6 = attributes.getValue("nl");
            pluginEntryModel.setNL(string6);
            String string7 = attributes.getValue("arch");
            pluginEntryModel.setArch(string7);
            String string8 = attributes.getValue("unpack");
            pluginEntryModel.setUnpack(!"false".equalsIgnoreCase(string8));
            long l = -1L;
            String string9 = attributes.getValue("download-size");
            if (string9 != null && !string9.trim().equals("")) {
                try {
                    l = Long.valueOf(string9);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            pluginEntryModel.setDownloadSize(l);
            long l2 = -1L;
            String string10 = attributes.getValue("install-size");
            if (string10 != null && !string10.trim().equals("")) {
                try {
                    l2 = Long.valueOf(string10);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            pluginEntryModel.setInstallSize(l2);
            this.objectStack.push(pluginEntryModel);
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                this.debug("Processed Plugin: id:" + string + " ver:" + string2 + " fragment:" + string3);
                this.debug("Processed Plugin: os:" + string4 + " ws:" + string5 + " nl:" + string6);
                this.debug("Processed Plugin: download size:" + l + " install size:" + l2);
            }
        }
    }

    private void processData(Attributes attributes) {
        String string = attributes.getValue("id");
        if (string == null || string.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultFeatureParser_MissingId, (Object[])new String[]{this.getState(this.currentState)}));
        } else {
            NonPluginEntryModel nonPluginEntryModel = this.factory.createNonPluginEntryModel();
            nonPluginEntryModel.setIdentifier(string);
            String string2 = attributes.getValue("os");
            nonPluginEntryModel.setOS(string2);
            String string3 = attributes.getValue("ws");
            nonPluginEntryModel.setWS(string3);
            String string4 = attributes.getValue("nl");
            nonPluginEntryModel.setNL(string4);
            String string5 = attributes.getValue("arch");
            nonPluginEntryModel.setArch(string5);
            long l = -1L;
            String string6 = attributes.getValue("download-size");
            if (string6 != null && !string6.trim().equals("")) {
                try {
                    l = Long.valueOf(string6);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            nonPluginEntryModel.setDownloadSize(l);
            long l2 = -1L;
            String string7 = attributes.getValue("install-size");
            if (string7 != null && !string7.trim().equals("")) {
                try {
                    l2 = Long.valueOf(string7);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            nonPluginEntryModel.setInstallSize(l2);
            this.objectStack.push(nonPluginEntryModel);
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                this.debug("Processed Data: id:" + string);
                this.debug("Processed Data: download size:" + l + " install size:" + l2);
            }
        }
    }

    private void debug(String string) {
        AppPlugin.debug("DefaultFeatureParser: " + string);
    }

    private void logStatus(SAXParseException sAXParseException) {
        String string;
        String string2 = sAXParseException.getSystemId();
        string2 = string2 == null ? "" : string2.substring(1 + string2.lastIndexOf("/"));
        if (string2.equals("")) {
            string = NLS.bind((String)Messages.DefaultFeatureParser_ErrorParsing, (Object[])new String[]{sAXParseException.getMessage()});
        } else {
            Object[] objectArray = new String[]{string2, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException.getMessage()};
            string = NLS.bind((String)Messages.DefaultFeatureParser_ErrorlineColumnMessage, (Object[])objectArray);
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, string, (Throwable)sAXParseException));
    }

    private void error(IStatus iStatus) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 1, Messages.DefaultFeatureParser_ErrorParsingFeature, null);
        }
        this.status.add(iStatus);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            AppPlugin.log(iStatus);
        }
    }

    private void internalErrorUnknownTag(String string) {
        this.stateStack.push(new Integer(-1));
        this.internalError(string);
    }

    private void internalError(String string) {
        if (this.location != null) {
            string = String.valueOf(string) + " " + NLS.bind((String)Messages.DefaultFeatureParser_location, (Object[])new String[]{this.location});
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, string, null));
    }

    private String getState(int n) {
        switch (n) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 2: {
                return "Feature";
            }
            case 3: {
                return "Install Handler";
            }
            case 4: {
                return DESCRIPTION;
            }
            case 1: {
                return INCLUDES;
            }
            case 5: {
                return "Copyright";
            }
            case 6: {
                return "License";
            }
            case 7: {
                return "URL";
            }
            case 8: {
                return "Update URL";
            }
            case 9: {
                return "Discovery URL";
            }
            case 10: {
                return "Require";
            }
            case 11: {
                return "Import";
            }
            case 12: {
                return "Plugin";
            }
            case 13: {
                return "Data";
            }
        }
        return NLS.bind((String)Messages.DefaultFeatureParser_UnknownState, (Object[])new String[]{Integer.toString(n)});
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        super.ignorableWhitespace(cArray, n, n2);
    }
}

