/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSiteParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private SiteModelFactory factory;
    private MultiStatus status;
    private boolean DESCRIPTION_SITE_ALREADY_SEEN = false;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SITE = 1;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_ARCHIVE = 3;
    private static final int STATE_CATEGORY = 4;
    private static final int STATE_CATEGORY_DEF = 5;
    private static final int STATE_DESCRIPTION_SITE = 6;
    private static final int STATE_DESCRIPTION_CATEGORY_DEF = 7;
    private static final String PLUGIN_ID = AppPlugin.getPlugin().getBundle().getSymbolicName();
    private static final String SITE = "site";
    private static final String FEATURE = "feature";
    private static final String ARCHIVE = "archive";
    private static final String CATEGORY_DEF = "category-def";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String MIRROR = "mirror";
    private static final String DEFAULT_INFO_URL = "index.html";
    private static final String FEATURES = "features/";
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    private int currentState;

    public DefaultSiteParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            AppPlugin.log(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            AppPlugin.log(sAXException);
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("Created");
        }
    }

    public void init(SiteModelFactory siteModelFactory) {
        this.factory = siteModelFactory;
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        this.status = null;
        this.DESCRIPTION_SITE_ALREADY_SEEN = false;
    }

    public SiteModel parse(InputStream inputStream) throws SAXException, IOException {
        this.stateStack.push(new Integer(0));
        this.currentState = (Integer)this.stateStack.peek();
        this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Messages.DefaultSiteParser_NoSiteTag);
        }
        if (this.objectStack.peek() instanceof SiteModel) {
            return (SiteModel)((Object)this.objectStack.pop());
        }
        String string = "";
        Iterator iterator = this.objectStack.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + iterator.next().toString() + "\r\n";
        }
        throw new SAXException(NLS.bind((String)Messages.DefaultSiteParser_WrongParsingStack, (Object[])new String[]{string}));
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("State: " + this.currentState);
            DefaultSiteParser.debug("Start Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        }
        switch (this.currentState) {
            case -1: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string2, this.getState(this.currentState)}));
                break;
            }
            case 0: {
                this.handleInitialState(string2, attributes);
                break;
            }
            case 1: {
                this.handleSiteState(string2, attributes);
                break;
            }
            case 2: {
                this.handleFeatureState(string2, attributes);
                break;
            }
            case 3: {
                this.handleSiteState(string2, attributes);
                break;
            }
            case 4: {
                this.handleCategoryState(string2, attributes);
                break;
            }
            case 5: {
                this.handleCategoryDefState(string2, attributes);
                break;
            }
            case 6: {
                this.handleSiteState(string2, attributes);
                break;
            }
            case 7: {
                this.handleSiteState(string2, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownStartState, (Object[])new String[]{this.getState(this.currentState)}));
            }
        }
        int n = (Integer)this.stateStack.peek();
        if (n != -1) {
            this.currentState = n;
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = null;
        URLEntryModel uRLEntryModel = null;
        int n = (Integer)this.stateStack.peek();
        switch (n) {
            case -1: 
            case 3: 
            case 4: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Messages.DefaultSiteParser_ParsingStackBackToInitialState);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                string4 = (String)this.objectStack.pop();
                SiteModel siteModel = (SiteModel)((Object)this.objectStack.peek());
                siteModel.getDescriptionModel().setAnnotation(string4);
                break;
            }
            case 2: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                this.stateStack.pop();
                if (this.objectStack.peek() instanceof String) {
                    string4 = (String)this.objectStack.pop();
                    CategoryModel categoryModel = (CategoryModel)((Object)this.objectStack.peek());
                    categoryModel.getDescriptionModel().setAnnotation(string4);
                }
                this.objectStack.pop();
                break;
            }
            case 6: {
                Object object;
                this.stateStack.pop();
                string4 = "";
                while (this.objectStack.peek() instanceof String) {
                    object = (String)this.objectStack.pop();
                    if (this.trailingSpace((String)object) && !this.leadingSpace(string4)) {
                        string4 = " " + string4;
                    }
                    string4 = String.valueOf(((String)object).trim()) + string4;
                    if (!this.leadingSpace((String)object) || this.leadingSpace(string4)) continue;
                    string4 = " " + string4;
                }
                string4 = string4.trim();
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if (string4 != null) {
                    uRLEntryModel.setAnnotation(string4);
                }
                object = (SiteModel)((Object)this.objectStack.peek());
                if (this.DESCRIPTION_SITE_ALREADY_SEEN) {
                    DefaultSiteParser.debug(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(n)}));
                }
                ((SiteModel)((Object)object)).setDescriptionModel(uRLEntryModel);
                this.DESCRIPTION_SITE_ALREADY_SEEN = true;
                break;
            }
            case 7: {
                Object object;
                this.stateStack.pop();
                string4 = "";
                while (this.objectStack.peek() instanceof String) {
                    object = (String)this.objectStack.pop();
                    if (this.trailingSpace((String)object) && !this.leadingSpace(string4)) {
                        string4 = " " + string4;
                    }
                    string4 = String.valueOf(((String)object).trim()) + string4;
                    if (!this.leadingSpace((String)object) || this.leadingSpace(string4)) continue;
                    string4 = " " + string4;
                }
                string4 = string4.trim();
                uRLEntryModel = (URLEntryModel)((Object)this.objectStack.pop());
                if (string4 != null) {
                    uRLEntryModel.setAnnotation(string4);
                }
                if (((CategoryModel)((Object)(object = (CategoryModel)((Object)this.objectStack.peek())))).getDescriptionModel() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(n), ((CategoryModel)((Object)object)).getLabel()}));
                    break;
                }
                ((CategoryModel)((Object)object)).setDescriptionModel(uRLEntryModel);
                break;
            }
            default: {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_UnknownEndState, (Object[])new String[]{this.getState(n)}));
            }
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End Element:" + string + ":" + string2 + ":" + string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        int n3 = (Integer)this.stateStack.peek();
        if (n3 == 6 || n3 == 7) {
            this.objectStack.push(string);
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logStatus(sAXParseException);
        throw sAXParseException;
    }

    private void handleInitialState(String string, Attributes attributes) throws SAXException {
        if (!string.equals(SITE)) {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
            throw new SAXException(Messages.DefaultSiteParser_InvalidXMLStream);
        }
        this.stateStack.push(new Integer(1));
        this.processSite(attributes);
    }

    private void handleSiteState(String string, Attributes attributes) {
        if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (string.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (string.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleFeatureState(String string, Attributes attributes) {
        if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (string.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (string.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (string.equals(CATEGORY)) {
            this.stateStack.push(new Integer(4));
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleCategoryDefState(String string, Attributes attributes) {
        if (string.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (string.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (string.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(7));
            this.processInfo(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void handleCategoryState(String string, Attributes attributes) {
        if (string.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (string.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (string.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (string.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (string.equals(CATEGORY)) {
            this.stateStack.push(new Integer(4));
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{string, this.getState(this.currentState)}));
        }
    }

    private void processSite(Attributes attributes) throws SAXException {
        SiteModel siteModel = this.factory.createSiteMapModel();
        String string = attributes.getValue("url");
        if (string != null && !"".equals(string.trim())) {
            if (!string.endsWith("/") && !string.endsWith(File.separator)) {
                string = String.valueOf(string) + "/";
            }
            siteModel.setLocationURLString(string);
        }
        URLEntryModel uRLEntryModel = this.factory.createURLEntryModel();
        uRLEntryModel.setURLString(DEFAULT_INFO_URL);
        siteModel.setDescriptionModel(uRLEntryModel);
        String string2 = attributes.getValue("type");
        if (!this.factory.canParseSiteType(string2)) {
            throw new SAXException(new InvalidSiteTypeException(string2));
        }
        siteModel.setType(string2);
        String string3 = attributes.getValue("mirrorsURL");
        if (string3 != null && string3.trim().length() > 0) {
            URLEntryModel[] uRLEntryModelArray = DefaultSiteParser.getMirrors(string3, this.factory);
            if (uRLEntryModelArray != null) {
                siteModel.setMirrorSiteEntryModels(uRLEntryModelArray);
            } else {
                siteModel.setMirrorsURLString(string3);
            }
        }
        this.objectStack.push(siteModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End process Site tag: siteURL:" + string + " type:" + string2);
        }
    }

    private void processFeature(Attributes attributes) {
        Object[] objectArray;
        boolean bl;
        SiteFeatureReferenceModel siteFeatureReferenceModel = this.factory.createFeatureReferenceModel();
        String string = attributes.getValue("url");
        String string2 = attributes.getValue("id");
        String string3 = attributes.getValue("version");
        boolean bl2 = string == null || string.trim().equals("");
        boolean bl3 = string2 == null || string2.trim().equals("");
        boolean bl4 = bl = string3 == null || string3.trim().equals("");
        if (bl2) {
            if (bl3 || bl) {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState)}));
            } else {
                string = FEATURES + string2 + '_' + string3;
            }
        }
        siteFeatureReferenceModel.setURLString(string);
        String string4 = attributes.getValue("type");
        siteFeatureReferenceModel.setType(string4);
        if (bl3 ^ bl) {
            objectArray = new String[]{string2, string3, this.getState(this.currentState)};
            AppPlugin.warn(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])objectArray));
        } else {
            siteFeatureReferenceModel.setFeatureIdentifier(string2);
            siteFeatureReferenceModel.setFeatureVersion(string3);
        }
        objectArray = attributes.getValue("label");
        if (objectArray != null && "".equals(objectArray.trim())) {
            objectArray = null;
        }
        siteFeatureReferenceModel.setLabel((String)objectArray);
        String string5 = attributes.getValue("os");
        siteFeatureReferenceModel.setOS(string5);
        String string6 = attributes.getValue("ws");
        siteFeatureReferenceModel.setWS(string6);
        String string7 = attributes.getValue("nl");
        siteFeatureReferenceModel.setNL(string7);
        String string8 = attributes.getValue("arch");
        siteFeatureReferenceModel.setArch(string8);
        String string9 = attributes.getValue("patch");
        siteFeatureReferenceModel.setPatch(string9);
        SiteModel siteModel = (SiteModel)((Object)this.objectStack.peek());
        siteModel.addFeatureReferenceModel(siteFeatureReferenceModel);
        siteFeatureReferenceModel.setSiteModel(siteModel);
        this.objectStack.push(siteFeatureReferenceModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End Processing DefaultFeature Tag: url:" + string + " type:" + string4);
        }
    }

    private void processArchive(Attributes attributes) {
        ArchiveReferenceModel archiveReferenceModel = this.factory.createArchiveReferenceModel();
        String string = attributes.getValue("path");
        if (string == null || string.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"path", this.getState(this.currentState)}));
        }
        archiveReferenceModel.setPath(string);
        String string2 = attributes.getValue("url");
        if (string2 == null || string2.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{ARCHIVE, this.getState(this.currentState)}));
        } else {
            archiveReferenceModel.setURLString(string2);
            SiteModel siteModel = (SiteModel)((Object)this.objectStack.peek());
            siteModel.addArchiveReferenceModel(archiveReferenceModel);
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing Archive: path:" + string + " url:" + string2);
        }
    }

    private void processCategory(Attributes attributes) {
        String string = attributes.getValue("name");
        SiteFeatureReferenceModel siteFeatureReferenceModel = (SiteFeatureReferenceModel)this.objectStack.peek();
        siteFeatureReferenceModel.addCategoryName(string);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing Category: name:" + string);
        }
    }

    private void processCategoryDef(Attributes attributes) {
        CategoryModel categoryModel = this.factory.createSiteCategoryModel();
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("label");
        categoryModel.setName(string);
        categoryModel.setLabel(string2);
        SiteModel siteModel = (SiteModel)((Object)this.objectStack.peek());
        siteModel.addCategoryModel(categoryModel);
        this.objectStack.push(categoryModel);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing CategoryDef: name:" + string + " label:" + string2);
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntryModel uRLEntryModel = this.factory.createURLEntryModel();
        String string = attributes.getValue("url");
        uRLEntryModel.setURLString(string);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("Processed Info: url:" + string);
        }
        this.objectStack.push(uRLEntryModel);
    }

    private static void debug(String string) {
        AppPlugin.debug("DefaultSiteParser" + string);
    }

    private void logStatus(SAXParseException sAXParseException) {
        String string;
        String string2 = sAXParseException.getSystemId();
        string2 = string2 == null ? "" : string2.substring(1 + string2.lastIndexOf("/"));
        if (string2.equals("")) {
            string = NLS.bind((String)Messages.DefaultSiteParser_ErrorParsing, (Object[])new String[]{sAXParseException.getMessage()});
        } else {
            Object[] objectArray = new String[]{string2, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException.getMessage()};
            string = NLS.bind((String)Messages.DefaultSiteParser_ErrorlineColumnMessage, (Object[])objectArray);
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, string, (Throwable)sAXParseException));
    }

    private void error(IStatus iStatus) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 1, Messages.DefaultSiteParser_ErrorParsingSite, null);
        }
        this.status.add(iStatus);
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            AppPlugin.log(iStatus);
        }
    }

    private void internalErrorUnknownTag(String string) {
        this.stateStack.push(new Integer(-1));
        this.internalError(string);
    }

    private void internalError(String string) {
        this.error((IStatus)new Status(4, PLUGIN_ID, 0, string, null));
    }

    private String getState(int n) {
        switch (n) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Site";
            }
            case 2: {
                return "Feature";
            }
            case 3: {
                return "Archive";
            }
            case 4: {
                return "Category";
            }
            case 5: {
                return "Category Def";
            }
            case 7: {
                return "Description / Category Def";
            }
            case 6: {
                return "Description / Site";
            }
        }
        return Messages.DefaultSiteParser_UnknownState;
    }

    private boolean leadingSpace(String string) {
        if (string.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(string.charAt(0));
    }

    private boolean trailingSpace(String string) {
        if (string.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(string.charAt(string.length() - 1));
    }

    static URLEntryModel[] getMirrors(String string, SiteModelFactory siteModelFactory) {
        Document document;
        block6: {
            String string2 = Locale.getDefault().getCountry().toLowerCase();
            int n = new GregorianCalendar().get(15) / 3600000;
            string = string.indexOf("?") != -1 ? String.valueOf(string) + "&" : String.valueOf(string) + "?";
            string = String.valueOf(string) + "countryCode=" + string2 + "&timeZone=" + n + "&responseType=xml";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string);
            if (document != null) break block6;
            return null;
        }
        try {
            NodeList nodeList = document.getElementsByTagName(MIRROR);
            URLEntryModel[] uRLEntryModelArray = new URLEntryModel[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element = (Element)nodeList.item(n);
                uRLEntryModelArray[n] = siteModelFactory.createURLEntryModel();
                String string3 = element.getAttribute("url");
                String string4 = element.getAttribute("label");
                uRLEntryModelArray[n].setURLString(string3);
                uRLEntryModelArray[n].setAnnotation(string4);
                if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                    DefaultSiteParser.debug("Processed mirror: url:" + string3 + " label:" + string4);
                }
                ++n;
            }
            return uRLEntryModelArray;
        }
        catch (Exception exception) {
            if (string != null && (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("file://") || string.startsWith("ftp://") || string.startsWith("jar://"))) {
                AppPlugin.log(Messages.DefaultSiteParser_mirrors, exception);
            }
            return null;
        }
    }
}

