/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.FeaturePlugin;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.PatchedFeature;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;

public class ConfigurationPolicy
extends ConfigurationPolicyModel {
    public ConfigurationPolicy() {
    }

    public ConfigurationPolicy(ConfigurationPolicy configurationPolicy) {
        this.setPolicy(configurationPolicy.getPolicy());
        this.setConfiguredFeatureReferences(configurationPolicy.getConfiguredFeatures());
        this.setUnconfiguredFeatureReferences(configurationPolicy.getUnconfiguredFeatures());
        this.setConfiguredSiteModel(configurationPolicy.getConfiguredSiteModel());
    }

    private boolean isUnconfigured(IFeatureReference iFeatureReference) {
        if (iFeatureReference == null) {
            return false;
        }
        IFeatureReference[] iFeatureReferenceArray = this.getUnconfiguredFeatures();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            if (iFeatureReference.equals(iFeatureReferenceArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isConfigured(IFeatureReference iFeatureReference) {
        if (iFeatureReference == null) {
            return false;
        }
        IFeatureReference[] iFeatureReferenceArray = this.getConfiguredFeatures();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            if (iFeatureReference.equals(iFeatureReferenceArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IFeatureReference var1_1, boolean var2_2, boolean var3_3) throws CoreException {
        block26: {
            block24: {
                if (this.isConfigured(var1_1)) {
                    return;
                }
                if (var1_1 == null) {
                    AppPlugin.warn("The feature reference to configure is null");
                    return;
                }
                var4_4 = null;
                try {
                    var4_4 = var1_1.getFeature(null);
                }
                catch (CoreException var5_5) {
                    if (UpdateManagerUtils.isOptional(var1_1)) break block24;
                    var6_7 = var1_1.getURL();
                    var7_10 = var6_7 != null ? var6_7.toExternalForm() : "<no feature reference url>";
                    AppPlugin.warn("Error retrieving feature:" + var7_10, var5_5);
                    return;
                }
            }
            if (var4_4 == null) {
                var5_6 = var1_1.getURL();
                var6_8 = var5_6 != null ? var5_6.toExternalForm() : "<no feature reference url>";
                AppPlugin.warn("The feature to unconfigure is null: feature reference is:" + var6_8);
            }
            var5_6 = null;
            if (var2_2 && var4_4.getInstallHandlerEntry() != null) {
                var5_6 = new InstallHandlerProxy(2, var4_4, var4_4.getInstallHandlerEntry(), null);
            }
            var6_9 = false;
            var7_11 = null;
            try {
                try {
                    if (var5_6 != null) {
                        var5_6.configureInitiated();
                    }
                    var8_12 = null;
                    if (var3_3) {
                        var8_12 = new ConfigurationActivity(6);
                        var8_12.setLabel(var4_4.getVersionedIdentifier().toString());
                        var8_12.setDate(new Date());
                    }
                    this.addConfiguredFeatureReference((FeatureReferenceModel)var1_1);
                    if (var8_12 != null) {
                        var9_14 = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                        var8_12.setStatus(0);
                        var9_14.addActivity(var8_12);
                    }
                    if (var5_6 != null) {
                        var5_6.completeConfigure();
                    }
                    var6_9 = true;
                }
                catch (Throwable var8_13) {
                    var7_11 = var8_13;
                }
            }
            catch (Throwable var11_15) {
                var10_16 = null;
                var12_18 = null;
                try {
                    if (var5_6 != null) {
                        var5_6.configureCompleted(var6_9);
                    }
                }
                catch (Throwable var13_20) {
                    var12_18 = var13_20;
                }
                if (var7_11 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var7_11);
                }
                if (var12_18 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var12_18);
                }
                throw var11_15;
            }
            {
                var10_17 = null;
                var12_19 = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 316->331)] { 
lbl66:
            // 1 sources

            if (var5_6 != null) {
                var5_6.configureCompleted(var6_9);
            }
            break block26;
lbl69:
            // 1 sources

            catch (Throwable var13_21) {
                var12_19 = var13_21;
            }
        }
        if (var7_11 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var7_11);
        }
        if (var12_19 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var12_19);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unconfigure(IFeatureReference var1_1, boolean var2_2, boolean var3_3) throws CoreException {
        block28: {
            block26: {
                if (this.isUnconfigured(var1_1)) {
                    AppPlugin.warn("Feature already unconfigured");
                    return true;
                }
                if (var1_1 == null) {
                    AppPlugin.warn("The feature reference to unconfigure is null");
                    return false;
                }
                var4_4 = null;
                try {
                    var4_4 = var1_1.getFeature(null);
                }
                catch (CoreException var5_5) {
                    if (UpdateManagerUtils.isOptional(var1_1)) break block26;
                    var6_8 = var1_1.getURL();
                    var7_11 = var6_8 != null ? var6_8.toExternalForm() : "<no feature reference url>";
                    AppPlugin.warn("Error retrieving feature:" + var7_11, var5_5);
                    return false;
                }
            }
            if (var4_4 == null) {
                var5_6 = var1_1.getURL();
                var6_9 = var5_6 != null ? var5_6.toExternalForm() : "<no feature reference url>";
                AppPlugin.warn("The feature to unconfigure is null: feature reference is:" + var6_9);
                return false;
            }
            var5_7 = null;
            if (var2_2 && var4_4.getInstallHandlerEntry() != null) {
                var5_7 = new InstallHandlerProxy(3, var4_4, var4_4.getInstallHandlerEntry(), null);
            }
            var6_10 = false;
            var7_12 = null;
            try {
                try {
                    var8_13 = null;
                    if (var3_3) {
                        var8_13 = new ConfigurationActivity(5);
                        var8_13.setLabel(var4_4.getVersionedIdentifier().toString());
                        var8_13.setDate(new Date());
                    }
                    var9_15 = null;
                    if (var8_13 != null) {
                        var9_15 = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                    }
                    if (var5_7 != null) {
                        var5_7.unconfigureInitiated();
                    }
                    this.addUnconfiguredFeatureReference((FeatureReferenceModel)var1_1);
                    if (var5_7 != null) {
                        var5_7.completeUnconfigure();
                    }
                    if (var8_13 != null) {
                        var8_13.setStatus(0);
                        var9_15.addActivity((IActivity)var8_13);
                    }
                    var6_10 = true;
                }
                catch (Throwable var8_14) {
                    var7_12 = var8_14;
                }
            }
            catch (Throwable var11_16) {
                var10_17 = null;
                var12_19 = null;
                try {
                    if (var5_7 != null) {
                        var5_7.unconfigureCompleted(var6_10);
                    }
                }
                catch (Throwable var13_21) {
                    var12_19 = var13_21;
                }
                if (var7_12 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var7_12);
                }
                if (var12_19 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var12_19);
                }
                throw var11_16;
            }
            {
                var10_18 = null;
                var12_20 = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 333->348)] { 
lbl70:
            // 1 sources

            if (var5_7 != null) {
                var5_7.unconfigureCompleted(var6_10);
            }
            break block28;
lbl73:
            // 1 sources

            catch (Throwable var13_22) {
                var12_20 = var13_22;
            }
        }
        if (var7_12 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var7_12);
        }
        if (var12_20 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var4_4.getLabel()}), var12_20);
        }
        if (!var6_10) {
            var8_13 = var1_1.getURL();
            var9_15 = var8_13 != null ? var8_13.toExternalForm() : "<no feature reference url>";
            AppPlugin.warn("Unable to unconfigure:" + (String)var9_15);
        }
        return var6_10;
    }

    public String[] getPluginPath(ISite iSite) throws CoreException {
        String[] stringArray;
        if (this.getPolicy() == 2) {
            return new String[0];
        }
        IFeatureReference[] iFeatureReferenceArray = this.getUnconfiguredFeatures();
        IFeatureReference[] iFeatureReferenceArray2 = this.getConfiguredFeatures();
        if (!this.isEnabled()) {
            stringArray = this.getPolicy() == 0 ? new String[]{} : this.getAllKnownPluginStrings(iSite, iFeatureReferenceArray2, iFeatureReferenceArray);
        } else {
            PatchedFeature[] patchedFeatureArray = this.buildPatchedFeatures(iFeatureReferenceArray2);
            stringArray = this.getPolicy() == 0 ? this.getConfiguredPluginStrings(iSite, patchedFeatureArray) : this.subtract(this.getAllKnownPluginStrings(iSite, iFeatureReferenceArray2, iFeatureReferenceArray), this.getConfiguredPluginStrings(iSite, patchedFeatureArray));
        }
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_RECONCILER) {
            AppPlugin.debug("GetPluginPath for: " + (iSite == null ? "<No site>" : iSite.getURL().toString()));
            int n = 0;
            while (n < stringArray.length) {
                AppPlugin.debug("To write:" + stringArray[n]);
                ++n;
            }
        }
        return stringArray;
    }

    private PatchedFeature[] buildPatchedFeatures(IFeatureReference[] iFeatureReferenceArray) {
        Object object;
        IFeatureReference iFeatureReference;
        HashMap<VersionedIdentifier, PatchedFeature> hashMap = new HashMap<VersionedIdentifier, PatchedFeature>();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            iFeatureReference = iFeatureReferenceArray[n];
            try {
                if (!iFeatureReference.isPatch()) {
                    object = iFeatureReference.getVersionedIdentifier();
                    hashMap.put((VersionedIdentifier)object, new PatchedFeature(iFeatureReferenceArray[n]));
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn(null, coreException);
            }
            ++n;
        }
        n = 0;
        while (n < iFeatureReferenceArray.length) {
            iFeatureReference = iFeatureReferenceArray[n];
            try {
                object = iFeatureReference.getFeature(null);
                IImport[] iImportArray = object.getImports();
                int n2 = 0;
                while (n2 < iImportArray.length) {
                    VersionedIdentifier versionedIdentifier;
                    PatchedFeature patchedFeature;
                    IImport iImport = iImportArray[n2];
                    if (iImport.isPatch() && (patchedFeature = (PatchedFeature)hashMap.get(versionedIdentifier = iImport.getVersionedIdentifier())) != null) {
                        patchedFeature.addPatch(iFeatureReference);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn(null, coreException);
            }
            ++n;
        }
        Collection collection = hashMap.values();
        return collection.toArray(new PatchedFeature[collection.size()]);
    }

    public IFeatureReference[] getConfiguredFeatures() {
        FeatureReferenceModel[] featureReferenceModelArray = this.getConfiguredFeaturesModel();
        if (featureReferenceModelArray.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])featureReferenceModelArray;
    }

    public IFeatureReference[] getUnconfiguredFeatures() {
        FeatureReferenceModel[] featureReferenceModelArray = this.getUnconfiguredFeaturesModel();
        if (featureReferenceModelArray.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])featureReferenceModelArray;
    }

    public IConfiguredSite getConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public void removeFeatureReference(IFeatureReference iFeatureReference) {
        if (iFeatureReference instanceof FeatureReferenceModel) {
            this.removeFeatureReference((FeatureReferenceModel)((Object)iFeatureReference));
        }
    }

    private String[] getConfiguredPluginStrings(ISite iSite, PatchedFeature[] patchedFeatureArray) throws CoreException {
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
            AppPlugin.warn("CONFIGURED PLUGINS");
        }
        HashSet<FeaturePlugin> hashSet = new HashSet<FeaturePlugin>();
        int n = 0;
        while (n < patchedFeatureArray.length) {
            FeaturePlugin[] featurePluginArray = patchedFeatureArray[n].getPlugins();
            hashSet.addAll(Arrays.asList(featurePluginArray));
            ++n;
        }
        Set set = this.getPluginStrings(iSite, hashSet.toArray(new FeaturePlugin[hashSet.size()]));
        return set.toArray(new String[set.size()]);
    }

    private String[] getAllKnownPluginStrings(ISite iSite, IFeatureReference[] iFeatureReferenceArray, IFeatureReference[] iFeatureReferenceArray2) throws CoreException {
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
            AppPlugin.warn("ALL PLUGINS");
        }
        IFeatureReference[] iFeatureReferenceArray3 = new IFeatureReference[iFeatureReferenceArray.length + iFeatureReferenceArray2.length];
        System.arraycopy(iFeatureReferenceArray, 0, iFeatureReferenceArray3, 0, iFeatureReferenceArray.length);
        System.arraycopy(iFeatureReferenceArray2, 0, iFeatureReferenceArray3, iFeatureReferenceArray.length, iFeatureReferenceArray2.length);
        HashSet<FeaturePlugin> hashSet = new HashSet<FeaturePlugin>();
        int n = 0;
        while (n < iFeatureReferenceArray3.length) {
            try {
                IFeature iFeature = iFeatureReferenceArray3[n].getFeature(null);
                if (iFeature == null) {
                    AppPlugin.warn("Null Feature", new Exception());
                } else {
                    IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
                    int n2 = 0;
                    while (n2 < iPluginEntryArray.length) {
                        hashSet.add(new FeaturePlugin(iPluginEntryArray[n2], iFeature));
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {
                AppPlugin.warn(null, coreException);
            }
            ++n;
        }
        Set set = this.getPluginStrings(iSite, hashSet.toArray(new FeaturePlugin[hashSet.size()]));
        return set.toArray(new String[set.size()]);
    }

    private Set getPluginStrings(ISite iSite, FeaturePlugin[] featurePluginArray) throws CoreException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < featurePluginArray.length) {
            IPluginEntry iPluginEntry = featurePluginArray[n].getEntry();
            IFeature iFeature = featurePluginArray[n].getFeature();
            ContentReference[] contentReferenceArray = null;
            try {
                contentReferenceArray = iFeature.getFeatureContentProvider().getPluginEntryArchiveReferences(iPluginEntry, null);
            }
            catch (CoreException coreException) {
                AppPlugin.warn(null, coreException);
            }
            if (contentReferenceArray != null) {
                int n2 = 0;
                while (n2 < contentReferenceArray.length) {
                    URL uRL = iSite.getSiteContentProvider().getArchiveReference(contentReferenceArray[n2].getIdentifier());
                    if (uRL != null) {
                        String string = UpdateManagerUtils.getURLAsString(iSite.getURL(), uRL);
                        if (!string.endsWith(".jar")) {
                            string = String.valueOf(string) + (string.endsWith(File.separator) || string.endsWith("/") ? "" : "/");
                        }
                        hashSet.add(string);
                        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                            AppPlugin.warn("Add plugin: " + string + " to the list");
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    private String[] subtract(String[] stringArray, String[] stringArray2) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        hashSet.removeAll(Arrays.asList(stringArray2));
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

