/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.UpdateUtils;

public class DeltaInstallHandler
extends BaseInstallHandler {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String META_MANIFEST = "META-INF/MANIFEST.MF";
    protected IFeature oldFeature;

    public void completeInstall(IFeatureContentConsumer iFeatureContentConsumer) throws CoreException {
        IPlatformEnvironment[] iPlatformEnvironmentArray;
        if (this.pluginEntries == null) {
            return;
        }
        if (!this.feature.isPatch()) {
            iPlatformEnvironmentArray = UpdateUtils.getInstalledFeatures(this.feature);
            if (iPlatformEnvironmentArray.length == 0) {
                return;
            }
            this.oldFeature = iPlatformEnvironmentArray[0];
        } else {
            this.oldFeature = UpdateUtils.getPatchedFeature(this.feature);
            if (this.oldFeature == null) {
                return;
            }
        }
        iPlatformEnvironmentArray = this.oldFeature.getPluginEntries();
        int n = 0;
        while (n < this.pluginEntries.length) {
            IPluginEntry iPluginEntry = this.pluginEntries[n];
            IPluginEntry iPluginEntry2 = this.getPluginEntry((IPluginEntry[])iPlatformEnvironmentArray, iPluginEntry.getVersionedIdentifier().getIdentifier());
            if (iPluginEntry2 != null) {
                try {
                    this.overlayPlugin(iPluginEntry2, iPluginEntry, iFeatureContentConsumer);
                }
                catch (IOException iOException) {
                    throw new CoreException((IStatus)new Status(4, UpdateUtils.getPluginId(), 1, "", (Throwable)iOException));
                }
            }
            ++n;
        }
    }

    protected IPluginEntry getPluginEntry(IPluginEntry[] iPluginEntryArray, String string) {
        int n = 0;
        while (n < iPluginEntryArray.length) {
            if (iPluginEntryArray[n].getVersionedIdentifier().getIdentifier().equals(string)) {
                return iPluginEntryArray[n];
            }
            ++n;
        }
        return null;
    }

    protected boolean referenceExists(ContentReference[] contentReferenceArray, ContentReference contentReference) {
        String string = contentReference.getIdentifier();
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < contentReferenceArray.length) {
            if (string.equals(contentReferenceArray[n].getIdentifier())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void overlayPlugin(IPluginEntry iPluginEntry, IPluginEntry iPluginEntry2, IFeatureContentConsumer iFeatureContentConsumer) throws CoreException, IOException {
        if (iPluginEntry2 instanceof PluginEntry && !((PluginEntry)iPluginEntry2).isUnpack()) {
            return;
        }
        ContentReference[] contentReferenceArray = this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(iPluginEntry, null);
        ContentReference[] contentReferenceArray2 = this.feature.getFeatureContentProvider().getPluginEntryContentReferences(iPluginEntry2, null);
        URL uRL = new URL(iFeatureContentConsumer.getFeature().getSite().getURL(), "plugins/" + iPluginEntry2.getVersionedIdentifier().toString());
        String string = uRL.getFile();
        int n = 0;
        while (true) {
            block13: {
                Object var11_11;
                if (n >= contentReferenceArray.length) {
                    return;
                }
                if (this.isPluginManifest(contentReferenceArray[n]) || this.referenceExists(contentReferenceArray2, contentReferenceArray[n])) break block13;
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = contentReferenceArray[n].getInputStream();
                        File file = new File(string, contentReferenceArray[n].getIdentifier());
                        UpdateManagerUtils.copyToLocal(inputStream, file.getAbsolutePath(), null);
                        UpdateManagerUtils.checkPermissions(contentReferenceArray[n], string);
                    }
                    catch (IOException iOException) {
                        var11_11 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (inputStream == null) throw throwable;
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                    throw throwable;
                    throw throwable;
                }
                {
                    var11_11 = null;
                    if (inputStream == null) break block13;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
            ++n;
        }
    }

    protected boolean isPluginManifest(ContentReference contentReference) {
        String string = contentReference.getIdentifier();
        return PLUGIN_XML.equals(string) || FRAGMENT_XML.equals(string) || META_MANIFEST.equals(string);
    }
}

