/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.FragmentEntry;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteReconciler;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.osgi.framework.Bundle;

public class InstallConfiguration
extends InstallConfigurationModel
implements IInstallConfiguration {
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private ListenersList listeners = new ListenersList();

    public InstallConfiguration() {
    }

    public InstallConfiguration(IInstallConfiguration iInstallConfiguration) throws MalformedURLException, CoreException {
        this(iInstallConfiguration, null, null);
    }

    public InstallConfiguration(IInstallConfiguration iInstallConfiguration, URL uRL, String string) throws CoreException, MalformedURLException {
        IConfiguredSite[] iConfiguredSiteArray;
        Date date = new Date();
        this.setCreationDate(date);
        this.setCurrent(false);
        if (uRL == null) {
            iConfiguredSiteArray = UpdateManagerUtils.getLocalRandomIdentifier("platform.xml", date);
            uRL = UpdateManagerUtils.getURL(((LocalSite)SiteManager.getLocalSite()).getLocationURL(), (String)iConfiguredSiteArray, null);
        }
        this.setLocationURLString(uRL.toExternalForm());
        if (string == null) {
            string = Utilities.format(date);
        }
        this.setLabel(string);
        if (iInstallConfiguration != null && (iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites()) != null) {
            int n = 0;
            while (n < iConfiguredSiteArray.length) {
                ConfiguredSite configuredSite = new ConfiguredSite(iConfiguredSiteArray[n]);
                this.addConfigurationSiteModel(configuredSite);
                ++n;
            }
        }
        this.resolve(uRL, null);
        this.initialized = true;
    }

    public IConfiguredSite[] getConfiguredSites() {
        ConfiguredSiteModel[] configuredSiteModelArray = this.getConfigurationSitesModel();
        if (configuredSiteModelArray.length == 0) {
            return new IConfiguredSite[0];
        }
        return (IConfiguredSite[])configuredSiteModelArray;
    }

    private int getDefaultPolicy() {
        return 1;
    }

    public IConfiguredSite createConfiguredSite(File file) throws CoreException {
        if (!file.getName().equals("eclipse")) {
            file = new File(file, "eclipse");
            file.mkdirs();
        }
        if (this.isDuplicateSite(file)) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_location_exists, (Object[])new String[]{file.getPath()}), null);
        }
        BaseSiteLocalFactory baseSiteLocalFactory = new BaseSiteLocalFactory();
        ISite iSite = InternalSiteManager.createSite(file);
        ConfiguredSite configuredSite = (ConfiguredSite)baseSiteLocalFactory.createConfigurationSiteModel((SiteModel)((Object)iSite), this.getDefaultPolicy());
        if (configuredSite.isNativelyLinked()) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_AlreadyNativelyLinked, null);
        }
        if (configuredSite.isProductSite()) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_AlreadyProductSite, null);
        }
        if (iSite != null) {
            configuredSite.setPlatformURLString(iSite.getURL().toExternalForm());
            IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            ConfigurationPolicy configurationPolicy = configuredSite.getConfigurationPolicy();
            String[] stringArray = new String[]{};
            if (configurationPolicy.getPolicy() == 0) {
                stringArray = configurationPolicy.getPluginPath(iSite);
            }
            IPlatformConfiguration.ISitePolicy iSitePolicy = iPlatformConfiguration.createSitePolicy(configurationPolicy.getPolicy(), stringArray);
            IPlatformConfiguration.ISiteEntry iSiteEntry = iPlatformConfiguration.createSiteEntry(iSite.getURL(), iSitePolicy);
            iPlatformConfiguration.configureSite(iSiteEntry);
            configuredSite.createPrivateSiteMarker();
            ((SiteModel)((Object)iSite)).setConfiguredSiteModel(configuredSite);
        }
        this.configure(configuredSite);
        return configuredSite;
    }

    public IConfiguredSite createLinkedConfiguredSite(File file) throws CoreException {
        return this.createConfiguredSite(file);
    }

    private void configure(ConfiguredSite configuredSite) throws CoreException {
        ISite iSite = configuredSite.getSite();
        ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            Object object;
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_RECONCILER) {
                object = "enable (optimistic)";
                AppPlugin.debug("New Linked Site:New Feature: " + iSiteFeatureReferenceArray[n].getURL() + " as " + (String)object);
            }
            object = configuredSite.getConfigurationPolicy();
            ((ConfigurationPolicy)((Object)object)).configure(iSiteFeatureReferenceArray[n], true, false);
            ++n;
        }
        SiteReconciler.checkConfiguredFeatures(configuredSite);
    }

    public void addConfiguredSite(IConfiguredSite iConfiguredSite) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        ConfigurationActivity configurationActivity = new ConfigurationActivity(3);
        configurationActivity.setLabel(iConfiguredSite.getSite().getURL().toExternalForm());
        configurationActivity.setDate(new Date());
        ConfiguredSiteModel configuredSiteModel = (ConfiguredSiteModel)((Object)iConfiguredSite);
        this.addConfigurationSiteModel(configuredSiteModel);
        configuredSiteModel.setInstallConfigurationModel(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IInstallConfigurationChangedListener iInstallConfigurationChangedListener = (IInstallConfigurationChangedListener)objectArray[n];
            iInstallConfigurationChangedListener.installSiteAdded(iConfiguredSite);
            ++n;
        }
        configurationActivity.setStatus(0);
        this.addActivity(configurationActivity);
    }

    public void addActivity(IActivity iActivity) {
        this.addActivityModel((ConfigurationActivityModel)((Object)iActivity));
    }

    public void removeConfiguredSite(IConfiguredSite iConfiguredSite) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        if (this.removeConfigurationSiteModel((ConfiguredSiteModel)((Object)iConfiguredSite))) {
            Object[] objectArray = this.listeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IInstallConfigurationChangedListener iInstallConfigurationChangedListener = (IInstallConfigurationChangedListener)objectArray[n];
                iInstallConfigurationChangedListener.installSiteRemoved(iConfiguredSite);
                ++n;
            }
            ConfigurationActivity configurationActivity = new ConfigurationActivity(4);
            configurationActivity.setLabel(iConfiguredSite.getSite().getURL().toExternalForm());
            configurationActivity.setDate(new Date());
            configurationActivity.setStatus(0);
            this.addActivity(configurationActivity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallConfigurationChangedListener(IInstallConfigurationChangedListener iInstallConfigurationChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(iInstallConfigurationChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallConfigurationChangedListener(IInstallConfigurationChangedListener iInstallConfigurationChangedListener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.remove(iInstallConfigurationChangedListener);
        }
    }

    public void remove() {
        if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
            File file = new File(this.getURL().getFile());
            UpdateManagerUtils.removeFromFileSystem(file);
        }
    }

    public boolean save() throws CoreException {
        IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        ConfiguredSiteModel[] configuredSiteModelArray = this.getConfigurationSitesModel();
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = iPlatformConfiguration.getConfiguredFeatureEntries();
        int n = 0;
        while (n < iFeatureEntryArray.length) {
            iPlatformConfiguration.unconfigureFeatureEntry(iFeatureEntryArray[n]);
            ++n;
        }
        IPlatformConfiguration iPlatformConfiguration2 = null;
        try {
            iPlatformConfiguration2 = ConfiguratorUtils.getPlatformConfiguration(null);
            IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = iPlatformConfiguration.getConfiguredSites();
            int n2 = 0;
            while (n2 < iSiteEntryArray.length) {
                iPlatformConfiguration2.configureSite(iSiteEntryArray[n2]);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        this.checkSites(configuredSiteModelArray, iPlatformConfiguration);
        int n3 = 0;
        while (n3 < configuredSiteModelArray.length) {
            ConfiguredSite configuredSite = (ConfiguredSite)configuredSiteModelArray[n3];
            ConfigurationPolicy configurationPolicy = configuredSite.getConfigurationPolicy();
            this.savePluginPath(configuredSite, iPlatformConfiguration, iPlatformConfiguration2);
            IFeatureReference[] iFeatureReferenceArray = configurationPolicy.getConfiguredFeatures();
            int n4 = 0;
            while (n4 < iFeatureReferenceArray.length) {
                IFeature iFeature = null;
                try {
                    iFeature = iFeatureReferenceArray[n4].getFeature(null);
                }
                catch (CoreException coreException) {
                    AppPlugin.warn(null, coreException);
                }
                this.saveFeatureEntry(configuredSite, iFeature, iPlatformConfiguration);
                ++n4;
            }
            ++n3;
        }
        if (iPlatformConfiguration2 != null) {
            IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = iPlatformConfiguration2.getConfiguredSites();
            int n5 = 0;
            while (n5 < iSiteEntryArray.length) {
                iPlatformConfiguration.unconfigureSite(iSiteEntryArray[n5]);
                ++n5;
            }
        }
        try {
            iPlatformConfiguration.save();
            this.date = new Date(iPlatformConfiguration.getChangeStamp());
            if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
                AppPlugin.log(this);
            }
            this.resetActivities();
            return this.isRestartNeeded(iPlatformConfiguration);
        }
        catch (IOException iOException) {
            CoreException coreException = Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToSavePlatformConfiguration, (Object[])new String[]{iPlatformConfiguration.getConfigurationLocation().toExternalForm()}), iOException);
            AppPlugin.warn("", coreException);
            return true;
        }
    }

    private void savePluginPath(ConfiguredSite configuredSite, IPlatformConfiguration iPlatformConfiguration, IPlatformConfiguration iPlatformConfiguration2) throws CoreException {
        ConfigurationPolicy configurationPolicy = configuredSite.getConfigurationPolicy();
        String[] stringArray = configurationPolicy.getPluginPath(configuredSite.getSite());
        IPlatformConfiguration.ISitePolicy iSitePolicy = iPlatformConfiguration.createSitePolicy(configurationPolicy.getPolicy(), stringArray);
        URL uRL = null;
        try {
            uRL = new URL(configuredSite.getPlatformURLString());
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{configuredSite.getPlatformURLString()}), malformedURLException);
        }
        catch (ClassCastException classCastException) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_UnableToCast, classCastException);
        }
        IPlatformConfiguration.ISiteEntry iSiteEntry = iPlatformConfiguration.findConfiguredSite(uRL);
        if (iSiteEntry == null) {
            iSiteEntry = iPlatformConfiguration.createSiteEntry(uRL, iSitePolicy);
        } else {
            iSiteEntry.setSitePolicy(iSitePolicy);
            ((SiteEntry)iSiteEntry).refreshPlugins();
            if (iPlatformConfiguration2 != null) {
                iPlatformConfiguration2.unconfigureSite(iSiteEntry);
            }
        }
        ((SiteEntry)iSiteEntry).setEnabled(configuredSite.isEnabled());
        iPlatformConfiguration.configureSite(iSiteEntry, true);
    }

    private void saveFeatureEntry(ConfiguredSite configuredSite, IFeature iFeature, IPlatformConfiguration iPlatformConfiguration) throws CoreException {
        String string;
        String string2;
        URL[] uRLArray;
        IPluginEntry[] iPluginEntryArray;
        if (iFeature == null) {
            return;
        }
        String string3 = iFeature.getVersionedIdentifier().getIdentifier();
        IPluginEntry[] iPluginEntryArray2 = iFeature.getPluginEntries();
        URL uRL = null;
        IPluginEntry iPluginEntry = null;
        int n = 0;
        while (n < iPluginEntryArray2.length) {
            if (string3.equalsIgnoreCase(iPluginEntryArray2[n].getVersionedIdentifier().getIdentifier())) {
                uRL = this.getRuntimeConfigurationURL(iPluginEntryArray2[n], configuredSite);
                iPluginEntry = iPluginEntryArray2[n];
                break;
            }
            ++n;
        }
        String string4 = null;
        if (iPluginEntry != null) {
            string4 = iPluginEntry.getVersionedIdentifier().getVersion().toString();
        }
        if (iFeature.isPrimary()) {
            iPluginEntryArray = new ArrayList();
            if (uRL != null) {
                iPluginEntryArray.add(uRL);
            }
            if (iPluginEntry != null) {
                uRLArray = this.getRuntimeFragmentURLs(iPluginEntry);
                iPluginEntryArray.addAll(Arrays.asList(uRLArray));
            }
            uRLArray = iPluginEntryArray.toArray(new URL[0]);
            string2 = iFeature.getPrimaryPluginID();
            string = iFeature.getVersionedIdentifier().getVersion().toString();
            String string5 = iFeature.getApplication();
            FeatureEntry featureEntry = (FeatureEntry)iPlatformConfiguration.createFeatureEntry(string3, string, string2, string4, true, string5, uRLArray);
            featureEntry.setURL(this.getFeatureRelativeURL(iFeature));
            SiteEntry siteEntry = (SiteEntry)iPlatformConfiguration.findConfiguredSite(configuredSite.getSite().getURL());
            siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)featureEntry);
        } else {
            iPluginEntryArray = iFeature.getVersionedIdentifier().getVersion().toString();
            uRLArray = iFeature.getPrimaryPluginID();
            string2 = (FeatureEntry)iPlatformConfiguration.createFeatureEntry(string3, (String)iPluginEntryArray, (String)uRLArray, string4, false, null, null);
            string2.setURL(this.getFeatureRelativeURL(iFeature));
            string = (SiteEntry)iPlatformConfiguration.findConfiguredSite(configuredSite.getSite().getURL());
            string.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)string2);
        }
        iPluginEntryArray = this.getPlatformPlugins(iFeature, iPlatformConfiguration);
        int n2 = 0;
        while (n2 < iPluginEntryArray.length) {
            string3 = iPluginEntryArray[n2].getVersionedIdentifier().getIdentifier();
            uRL = this.getRuntimeConfigurationURL(iPluginEntryArray[n2], configuredSite);
            if (uRL != null) {
                iPlatformConfiguration.setBootstrapPluginLocation(string3, uRL);
            }
            ++n2;
        }
    }

    private void checkSites(ConfiguredSiteModel[] configuredSiteModelArray, IPlatformConfiguration iPlatformConfiguration) throws CoreException {
        int n = 0;
        while (n < configuredSiteModelArray.length) {
            URL uRL = null;
            try {
                uRL = new URL(configuredSiteModelArray[n].getPlatformURLString());
            }
            catch (MalformedURLException malformedURLException) {
                AppPlugin.warn(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{configuredSiteModelArray[n].getPlatformURLString()}), malformedURLException);
            }
            catch (ClassCastException classCastException) {
                AppPlugin.warn(Messages.InstallConfiguration_UnableToCast, classCastException);
            }
            IPlatformConfiguration.ISiteEntry iSiteEntry = iPlatformConfiguration.findConfiguredSite(uRL);
            if (iSiteEntry == null) {
                AppPlugin.warn(NLS.bind((String)Messages.InstallConfiguration_unableToFindSite, (Object[])new String[]{uRL.toExternalForm(), iPlatformConfiguration.getConfigurationLocation().toExternalForm()}));
            }
            ++n;
        }
    }

    public void revertTo(IInstallConfiguration iInstallConfiguration, IProgressMonitor iProgressMonitor, IProblemHandler iProblemHandler) throws CoreException, InterruptedException {
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        IConfiguredSite[] iConfiguredSiteArray2 = this.getConfiguredSites();
        Hashtable<String, IConfiguredSite> hashtable = new Hashtable<String, IConfiguredSite>(0);
        Hashtable<String, IConfiguredSite> hashtable2 = new Hashtable<String, IConfiguredSite>(0);
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            hashtable.put(iConfiguredSite.getSite().getURL().toExternalForm(), iConfiguredSite);
            hashtable2.put(iConfiguredSite.getSite().getURL().toExternalForm(), iConfiguredSite);
            ++n;
        }
        if (iConfiguredSiteArray2 != null) {
            Object object;
            String string = null;
            int n2 = 0;
            while (n2 < iConfiguredSiteArray2.length) {
                string = iConfiguredSiteArray2[n2].getSite().getURL().toExternalForm();
                object = (IConfiguredSite)hashtable.get(string);
                if (object != null) {
                    ((ConfiguredSite)iConfiguredSiteArray2[n2]).revertTo((IConfiguredSite)object, iProgressMonitor, iProblemHandler);
                } else {
                    ISiteFeatureReference[] iSiteFeatureReferenceArray = iConfiguredSiteArray2[n2].getSite().getFeatureReferences();
                    int n3 = 0;
                    while (n3 < iSiteFeatureReferenceArray.length) {
                        IFeature iFeature = null;
                        try {
                            iFeature = iSiteFeatureReferenceArray[n3].getFeature(null);
                        }
                        catch (CoreException coreException) {
                            AppPlugin.warn(null, coreException);
                        }
                        if (iFeature != null) {
                            iConfiguredSiteArray2[n2].unconfigure(iFeature);
                        }
                        ++n3;
                    }
                }
                hashtable2.put(string, iConfiguredSiteArray2[n2]);
                ++n2;
            }
            Collection collection = hashtable2.values();
            if (collection != null && !collection.isEmpty()) {
                object = new ConfiguredSiteModel[collection.size()];
                collection.toArray((T[])object);
                this.setConfigurationSiteModel((ConfiguredSiteModel[])object);
            }
        }
    }

    public IActivity[] getActivities() {
        if (this.getActivityModel().length == 0) {
            return new IActivity[0];
        }
        return (IActivity[])this.getActivityModel();
    }

    private IPluginEntry[] getPlatformPlugins(IFeature iFeature, IPlatformConfiguration iPlatformConfiguration) {
        Object object;
        HashMap<String, IPluginEntry> hashMap = new HashMap<String, IPluginEntry>();
        String[] stringArray = iPlatformConfiguration.getBootstrapPluginIdentifiers();
        IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
        int n = 0;
        while (n < stringArray.length) {
            object = null;
            int n2 = 0;
            while (n2 < iPluginEntryArray.length) {
                object = iPluginEntryArray[n2].getVersionedIdentifier().getIdentifier();
                if (stringArray[n].equals(object)) {
                    hashMap.put(stringArray[n], iPluginEntryArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        Collection collection = hashMap.values();
        if (collection == null || collection.size() == 0) {
            return new IPluginEntry[0];
        }
        object = new IPluginEntry[collection.size()];
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            object[n3] = (IPluginEntry)iterator.next();
            ++n3;
        }
        return object;
    }

    private URL getRuntimeConfigurationURL(IPluginEntry iPluginEntry, ConfiguredSite configuredSite) throws CoreException {
        URL uRL;
        block6: {
            String string = configuredSite.getPlatformURLString();
            String string2 = this.getPathID(iPluginEntry);
            try {
                String string3;
                ISiteContentProvider iSiteContentProvider = configuredSite.getSite().getSiteContentProvider();
                URL uRL2 = iSiteContentProvider.getArchiveReference(string2);
                if (!string.startsWith("platform")) {
                    if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                        AppPlugin.debug("getRuntimeConfiguration Plugin Entry Full URL:" + uRL2 + " Platform String:" + string + " [NON PLATFORM URL].");
                    }
                    return uRL2;
                }
                URL uRL3 = configuredSite.getSite().getURL();
                String string4 = UpdateManagerUtils.getURLAsString(uRL3, uRL2);
                uRL = new URL(new URL(string), string4);
                if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                    AppPlugin.debug("getRuntimeConfiguration plugin Entry Full URL:" + uRL2 + " Platform String:" + string + " Site URL:" + uRL3 + " Relative:" + string4);
                }
                if (uRL2 == null || !"file".equals(uRL2.getProtocol()) || new File(string3 = uRL2.getFile()).exists()) break block6;
                AppPlugin.warn("The URL:" + uRL + " doesn't point to a valid platform plugin.The URL will not be written in the platform configuration", new Exception());
                return null;
            }
            catch (IOException iOException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{string}), iOException);
            }
        }
        return uRL;
    }

    private URL[] getRuntimeFragmentURLs(IPluginEntry iPluginEntry) throws CoreException {
        VersionedIdentifier versionedIdentifier = iPluginEntry.getVersionedIdentifier();
        Bundle bundle = Platform.getBundle((String)versionedIdentifier.getIdentifier());
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 2) {
            FragmentEntry[] fragmentEntryArray = UpdateManagerUtils.getFragments(bundle);
            int n = 0;
            while (fragmentEntryArray != null && n < fragmentEntryArray.length) {
                String string = fragmentEntryArray[n].getLocation();
                try {
                    URL uRL = new URL(string);
                    uRL = Platform.asLocalURL((URL)Platform.resolve((URL)uRL));
                    arrayList.add(this.asInstallRelativeURL(uRL));
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    private String getPathID(IPluginEntry iPluginEntry) {
        return "plugins/" + iPluginEntry.getVersionedIdentifier().toString() + ".jar";
    }

    private URL asInstallRelativeURL(URL uRL) {
        URL uRL2 = ConfiguratorUtils.getInstallURL();
        if (uRL2.getProtocol().equals(uRL.getProtocol()) && uRL2.getProtocol().equals("file")) {
            int n;
            String string;
            String string2 = new File(uRL2.getFile()).getAbsolutePath().replace(File.separatorChar, '/');
            if (!string2.endsWith("/")) {
                string2 = String.valueOf(string2) + "/";
            }
            if (!(string = new File(uRL.getFile()).getAbsolutePath().replace(File.separatorChar, '/')).endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            if ((n = string2.lastIndexOf("/")) != -1 && string.startsWith(string2 = string2.substring(0, n + 1))) {
                try {
                    return new URL("platform:/base/" + string.substring(string2.length()));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return uRL;
    }

    private boolean isDuplicateSite(File file) {
        URL uRL;
        IConfiguredSite[] iConfiguredSiteArray = this.getConfiguredSites();
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            URL uRL2 = iConfiguredSiteArray[n].getSite().getURL();
            if (UpdateManagerUtils.sameURL(uRL, uRL2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String getFeatureRelativeURL(IFeature iFeature) {
        String string;
        String string2 = iFeature.getURL().toExternalForm();
        if (string2.startsWith(string = iFeature.getSite().getURL().toExternalForm())) {
            return string2.substring(string.length());
        }
        return string2;
    }

    private boolean isRestartNeeded(IPlatformConfiguration iPlatformConfiguration) {
        int n;
        Object[] objectArray;
        HashSet<String> hashSet = null;
        if (iPlatformConfiguration instanceof PlatformConfiguration) {
            hashSet = ((PlatformConfiguration)iPlatformConfiguration).getPluginPaths();
            if (isWindows) {
                objectArray = hashSet.toArray(new String[hashSet.size()]);
                n = 0;
                while (n < objectArray.length) {
                    hashSet.add(((String)objectArray[n]).toLowerCase());
                    ++n;
                }
            }
        } else {
            objectArray = iPlatformConfiguration.getPluginPath();
            hashSet = new HashSet<String>(objectArray.length);
            n = 0;
            while (n < objectArray.length) {
                String string = ((URL)objectArray[n]).getFile();
                hashSet.add(string);
                if (isWindows) {
                    hashSet.add(string.toLowerCase());
                }
                ++n;
            }
        }
        objectArray = AppPlugin.getPlugin().getBundleContext().getBundles();
        n = "update@".length();
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string;
            if (!(objectArray[n2].getBundleId() == 0L || !(string = objectArray[n2].getLocation()).startsWith("update@") || hashSet.contains(string = string.substring(n)) || isWindows && hashSet.contains(string.toLowerCase()))) {
                if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                    AppPlugin.debug("Bundle " + string + " has been removed");
                }
                return true;
            }
            ++n2;
        }
        if (iPlatformConfiguration instanceof PlatformConfiguration) {
            return this.areThereNewVersionOfOldPlugins(((PlatformConfiguration)iPlatformConfiguration).getPlugins(), (Bundle[])objectArray);
        }
        return false;
    }

    private boolean areThereNewVersionOfOldPlugins(PluginEntry[] pluginEntryArray, Bundle[] bundleArray) {
        int n = 0;
        while (n < bundleArray.length) {
            if (bundleArray[n].getBundleId() != 0L && this.getNumberOfPlugins(bundleArray[n].getSymbolicName(), bundleArray) != this.getNumberOfPlugins(bundleArray[n].getSymbolicName(), pluginEntryArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getNumberOfPlugins(String string, PluginEntry[] pluginEntryArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < pluginEntryArray.length) {
            if (string.equals(pluginEntryArray[n2].getPluginIdentifier())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int getNumberOfPlugins(String string, Bundle[] bundleArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < bundleArray.length) {
            if (string.equals(bundleArray[n2].getSymbolicName())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InstallConfiguration)) {
            return false;
        }
        InstallConfiguration installConfiguration = (InstallConfiguration)object;
        return this.getCreationDate().equals(installConfiguration.getCreationDate()) && this.getLabel().equals(installConfiguration.getLabel()) && this.getLocationURLString().equals(installConfiguration.getLocationURLString());
    }
}

