/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class ConfigurationPolicyModel
extends ModelObject {
    private int policy;
    private Map configuredFeatureReferences = new HashMap();
    private Map unconfiguredFeatureReferences;
    private ConfiguredSiteModel configuredSiteModel;
    private boolean enable = true;

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int n) {
        this.assertIsWriteable();
        this.policy = n;
    }

    public FeatureReferenceModel[] getConfiguredFeaturesModel() {
        if (this.configuredFeatureReferences == null || this.configuredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.configuredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.configuredFeatureReferences.keySet()));
    }

    public FeatureReferenceModel[] getUnconfiguredFeaturesModel() {
        ISite iSite;
        ISiteFeatureReference[] iSiteFeatureReferenceArray;
        if (this.unconfiguredFeatureReferences == null && this.configuredSiteModel != null && this.configuredSiteModel.getSiteModel() != null && (iSiteFeatureReferenceArray = (iSite = (ISite)((Object)this.configuredSiteModel.getSiteModel())).getFeatureReferences()).length > this.getConfiguredFeaturesModel().length) {
            int n = 0;
            while (n < iSiteFeatureReferenceArray.length) {
                if (iSiteFeatureReferenceArray[n] instanceof SiteFeatureReference) {
                    Iterator iterator = this.configuredFeatureReferences.keySet().iterator();
                    boolean bl = false;
                    while (!bl && iterator.hasNext()) {
                        FeatureReferenceModel featureReferenceModel = (FeatureReferenceModel)((Object)iterator.next());
                        if (!UpdateManagerUtils.sameURL(featureReferenceModel.getURL(), iSiteFeatureReferenceArray[n].getURL())) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this.addUnconfiguredFeatureReference((SiteFeatureReference)iSiteFeatureReferenceArray[n]);
                    }
                }
                ++n;
            }
        }
        if (this.unconfiguredFeatureReferences == null || this.unconfiguredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.unconfiguredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.unconfiguredFeatureReferences.keySet()));
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    private boolean remove(FeatureReferenceModel featureReferenceModel, Map map) {
        URL uRL = featureReferenceModel.getURL();
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            FeatureReferenceModel featureReferenceModel2 = (FeatureReferenceModel)((Object)iterator.next());
            if (!UpdateManagerUtils.sameURL(featureReferenceModel2.getURL(), uRL)) continue;
            map.remove((Object)featureReferenceModel2);
            bl = true;
        }
        return bl;
    }

    private void add(FeatureReferenceModel featureReferenceModel, Map map) {
        URL uRL = featureReferenceModel.getURL();
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            FeatureReferenceModel featureReferenceModel2 = (FeatureReferenceModel)((Object)iterator.next());
            if (!UpdateManagerUtils.sameURL(featureReferenceModel2.getURL(), uRL)) continue;
            bl = true;
        }
        if (!bl) {
            map.put(featureReferenceModel, null);
        } else {
            AppPlugin.warn("Feature Reference :" + (Object)((Object)featureReferenceModel) + " already part of the list.");
        }
    }

    public void addConfiguredFeatureReference(FeatureReferenceModel featureReferenceModel) {
        boolean bl;
        this.assertIsWriteable();
        if (this.configuredFeatureReferences == null) {
            this.configuredFeatureReferences = new HashMap();
        }
        if (!this.configuredFeatureReferences.containsKey((Object)featureReferenceModel)) {
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                AppPlugin.debug("Configuring " + featureReferenceModel.getURLString());
            }
            this.add(featureReferenceModel, this.configuredFeatureReferences);
        }
        if (this.unconfiguredFeatureReferences != null && !(bl = this.remove(featureReferenceModel, this.unconfiguredFeatureReferences))) {
            AppPlugin.warn("Feature not part of Unconfigured list: " + featureReferenceModel.getURLString());
        }
    }

    public void addUnconfiguredFeatureReference(FeatureReferenceModel featureReferenceModel) {
        boolean bl;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences == null) {
            this.unconfiguredFeatureReferences = new HashMap();
        }
        if (!this.unconfiguredFeatureReferences.containsKey((Object)featureReferenceModel)) {
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_CONFIGURATION) {
                AppPlugin.debug("Unconfiguring " + featureReferenceModel.getURLString());
            }
            this.add(featureReferenceModel, this.unconfiguredFeatureReferences);
        }
        if (this.configuredFeatureReferences != null && !(bl = this.remove(featureReferenceModel, this.configuredFeatureReferences))) {
            AppPlugin.warn("Feature not part of Configured list: " + featureReferenceModel.getURLString());
        }
    }

    public void removeFeatureReference(FeatureReferenceModel featureReferenceModel) {
        boolean bl;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences != null && !(bl = this.remove(featureReferenceModel, this.unconfiguredFeatureReferences))) {
            AppPlugin.warn(String.valueOf(featureReferenceModel.getURLString()) + " not part of unconfigured list.");
        }
        if (this.configuredFeatureReferences != null && !(bl = this.remove(featureReferenceModel, this.configuredFeatureReferences))) {
            AppPlugin.warn(String.valueOf(featureReferenceModel.getURLString()) + " not part of configured list.");
        }
    }

    protected void setUnconfiguredFeatureReferences(IFeatureReference[] iFeatureReferenceArray) {
        this.unconfiguredFeatureReferences = new HashMap();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            this.unconfiguredFeatureReferences.put(iFeatureReferenceArray[n], null);
            ++n;
        }
    }

    protected void setConfiguredFeatureReferences(IFeatureReference[] iFeatureReferenceArray) {
        this.configuredFeatureReferences = new HashMap();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            this.configuredFeatureReferences.put(iFeatureReferenceArray[n], null);
            ++n;
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean bl) {
        this.enable = bl;
    }
}

