/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class EnableCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private IFeature feature;

    public EnableCommand(String string, String string2, String string3, String string4) throws Exception {
        super(string4);
        try {
            IFeature[] iFeatureArray;
            IConfiguredSite[] iConfiguredSiteArray = this.getConfiguration().getConfiguredSites();
            if (string3 != null) {
                iFeatureArray = new File(string3).toURL();
                if (SiteManager.getSite((URL)iFeatureArray, null) == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string3}));
                }
                this.targetSite = SiteManager.getSite((URL)iFeatureArray, null).getCurrentConfiguredSite();
            }
            if (this.targetSite == null) {
                int n = 0;
                while (n < iConfiguredSiteArray.length) {
                    if (iConfiguredSiteArray[n].isProductSite()) {
                        this.targetSite = iConfiguredSiteArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if ((iFeatureArray = UpdateUtils.searchSite(string, this.targetSite, false)) == null || iFeatureArray.length == 0) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures1, (Object[])new String[]{string}));
            }
            if (string2 == null || string2.trim().length() == 0) {
                this.feature = iFeatureArray[0];
            } else {
                int n = 0;
                while (iFeatureArray != null && n < iFeatureArray.length) {
                    if (iFeatureArray[n].getVersionedIdentifier().getVersion().toString().equals(string2) && !this.targetSite.isConfigured(iFeatureArray[n])) {
                        this.feature = iFeatureArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.feature == null) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures2, (Object[])new String[]{string, string2}));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (CoreException coreException) {
            throw coreException;
        }
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iStatus != null) {
            AppPlugin.log(iStatus);
            return false;
        }
        if (this.isVerifyOnly()) {
            iStatus = OperationsManager.getValidator().validatePendingConfig(this.feature);
            if (iStatus != null && iStatus.getCode() == 2) {
                AppPlugin.log(iStatus);
            }
            return iStatus == null || iStatus.getCode() == 2;
        }
        IConfigFeatureOperation iConfigFeatureOperation = OperationsManager.getOperationFactory().createConfigOperation(this.targetSite, this.feature);
        try {
            iConfigFeatureOperation.execute(iProgressMonitor, this);
            return true;
        }
        catch (CoreException coreException) {
            StandaloneUpdateApplication.exceptionLogged();
            AppPlugin.log(coreException);
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            StandaloneUpdateApplication.exceptionLogged();
            AppPlugin.log(invocationTargetException);
            return false;
        }
    }
}

