/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IContextReplacingOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public final class TriggeredOperations
extends AbstractOperation
implements ICompositeOperation,
IAdvancedUndoableOperation,
IContextReplacingOperation {
    private IUndoableOperation triggeringOperation;
    private IOperationHistory history;
    private List children = new ArrayList();

    public TriggeredOperations(IUndoableOperation iUndoableOperation, IOperationHistory iOperationHistory) {
        super(iUndoableOperation.getLabel());
        this.triggeringOperation = iUndoableOperation;
        this.recomputeContexts();
        this.history = iOperationHistory;
    }

    public void add(IUndoableOperation iUndoableOperation) {
        this.children.add(iUndoableOperation);
        this.recomputeContexts();
    }

    public void remove(IUndoableOperation iUndoableOperation) {
        if (iUndoableOperation == this.triggeringOperation) {
            this.triggeringOperation = null;
            ArrayList arrayList = new ArrayList(this.children);
            this.children = new ArrayList(0);
            this.recomputeContexts();
            iUndoableOperation.dispose();
            this.history.replaceOperation(this, arrayList.toArray(new IUndoableOperation[arrayList.size()]));
        } else {
            this.children.remove(iUndoableOperation);
            iUndoableOperation.dispose();
            this.recomputeContexts();
        }
    }

    public void removeContext(IUndoContext iUndoContext) {
        boolean bl = false;
        if (this.triggeringOperation != null && this.triggeringOperation.hasContext(iUndoContext)) {
            if (this.triggeringOperation.getContexts().length == 1) {
                this.remove(this.triggeringOperation);
                return;
            }
            this.triggeringOperation.removeContext(iUndoContext);
            bl = true;
        }
        ArrayList<IUndoableOperation> arrayList = new ArrayList<IUndoableOperation>();
        int n = 0;
        while (n < this.children.size()) {
            IUndoableOperation iUndoableOperation = (IUndoableOperation)this.children.get(n);
            if (iUndoableOperation.hasContext(iUndoContext)) {
                if (iUndoableOperation.getContexts().length == 1) {
                    arrayList.add(iUndoableOperation);
                } else {
                    iUndoableOperation.removeContext(iUndoContext);
                }
                bl = true;
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            this.remove((IUndoableOperation)arrayList.get(n));
            ++n;
        }
        if (bl) {
            this.recomputeContexts();
        }
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (this.triggeringOperation != null) {
            this.history.openOperation(this, 1);
            try {
                IStatus iStatus = this.triggeringOperation.execute(iProgressMonitor, iAdaptable);
                this.history.closeOperation(iStatus.isOK(), false, 1);
                return iStatus;
            }
            catch (ExecutionException executionException) {
                this.history.closeOperation(false, false, 1);
                throw executionException;
            }
            catch (RuntimeException runtimeException) {
                this.history.closeOperation(false, false, 1);
                throw runtimeException;
            }
        }
        return IOperationHistory.OPERATION_INVALID_STATUS;
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (this.triggeringOperation != null) {
            this.history.openOperation(this, 3);
            ArrayList arrayList = new ArrayList(this.children);
            try {
                this.removeAllChildren();
                IStatus iStatus = this.triggeringOperation.redo(iProgressMonitor, iAdaptable);
                if (!iStatus.isOK()) {
                    this.children = arrayList;
                }
                this.history.closeOperation(iStatus.isOK(), false, 3);
                return iStatus;
            }
            catch (ExecutionException executionException) {
                this.children = arrayList;
                this.history.closeOperation(false, false, 3);
                throw executionException;
            }
            catch (RuntimeException runtimeException) {
                this.children = arrayList;
                this.history.closeOperation(false, false, 3);
                throw runtimeException;
            }
        }
        return IOperationHistory.OPERATION_INVALID_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (this.triggeringOperation != null) {
            this.history.openOperation(this, 2);
            ArrayList arrayList = new ArrayList(this.children);
            try {
                this.removeAllChildren();
                IStatus iStatus = this.triggeringOperation.undo(iProgressMonitor, iAdaptable);
                if (!iStatus.isOK()) {
                    this.children = arrayList;
                }
                this.history.closeOperation(iStatus.isOK(), false, 2);
                return iStatus;
            }
            catch (ExecutionException executionException) {
                this.children = arrayList;
                this.history.closeOperation(false, false, 2);
                throw executionException;
            }
            catch (RuntimeException runtimeException) {
                this.children = arrayList;
                this.history.closeOperation(false, false, 2);
                throw runtimeException;
            }
        }
        return IOperationHistory.OPERATION_INVALID_STATUS;
    }

    public boolean canUndo() {
        if (this.triggeringOperation != null) {
            return this.triggeringOperation.canUndo();
        }
        return false;
    }

    public boolean canExecute() {
        if (this.triggeringOperation != null) {
            return this.triggeringOperation.canExecute();
        }
        return false;
    }

    public boolean canRedo() {
        if (this.triggeringOperation != null) {
            return this.triggeringOperation.canRedo();
        }
        return false;
    }

    public void dispose() {
        int n = 0;
        while (n < this.children.size()) {
            ((IUndoableOperation)this.children.get(n)).dispose();
            ++n;
        }
        if (this.triggeringOperation != null) {
            this.triggeringOperation.dispose();
        }
    }

    private void recomputeContexts() {
        ArrayList<IUndoContext> arrayList = new ArrayList<IUndoContext>();
        if (this.triggeringOperation != null) {
            IUndoContext[] iUndoContextArray = this.triggeringOperation.getContexts();
            int n = 0;
            while (n < iUndoContextArray.length) {
                arrayList.add(iUndoContextArray[n]);
                ++n;
            }
        }
        int n = 0;
        while (n < this.children.size()) {
            IUndoContext[] iUndoContextArray = ((IUndoableOperation)this.children.get(n)).getContexts();
            int n2 = 0;
            while (n2 < iUndoContextArray.length) {
                if (!arrayList.contains(iUndoContextArray[n2])) {
                    arrayList.add(iUndoContextArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.contexts = arrayList;
    }

    private void removeAllChildren() {
        IUndoableOperation[] iUndoableOperationArray = this.children.toArray(new IUndoableOperation[this.children.size()]);
        int n = 0;
        while (n < iUndoableOperationArray.length) {
            this.children.remove(iUndoableOperationArray[n]);
            iUndoableOperationArray[n].dispose();
            ++n;
        }
    }

    public IUndoableOperation getTriggeringOperation() {
        return this.triggeringOperation;
    }

    public Object[] getAffectedObjects() {
        if (this.triggeringOperation instanceof IAdvancedUndoableOperation) {
            return ((IAdvancedUndoableOperation)((Object)this.triggeringOperation)).getAffectedObjects();
        }
        return null;
    }

    public void aboutToNotify(OperationHistoryEvent operationHistoryEvent) {
        if (this.triggeringOperation instanceof IAdvancedUndoableOperation) {
            ((IAdvancedUndoableOperation)((Object)this.triggeringOperation)).aboutToNotify(operationHistoryEvent);
        }
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) throws ExecutionException {
        if (this.triggeringOperation instanceof IAdvancedUndoableOperation) {
            try {
                return ((IAdvancedUndoableOperation)((Object)this.triggeringOperation)).computeUndoableStatus(iProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) throws ExecutionException {
        if (this.triggeringOperation instanceof IAdvancedUndoableOperation) {
            try {
                return ((IAdvancedUndoableOperation)((Object)this.triggeringOperation)).computeRedoableStatus(iProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public void replaceContext(IUndoContext iUndoContext, IUndoContext iUndoContext2) {
        if (this.triggeringOperation != null && this.triggeringOperation.hasContext(iUndoContext)) {
            if (this.triggeringOperation instanceof IContextReplacingOperation) {
                ((IContextReplacingOperation)((Object)this.triggeringOperation)).replaceContext(iUndoContext, iUndoContext2);
            } else {
                this.triggeringOperation.removeContext(iUndoContext);
                this.triggeringOperation.addContext(iUndoContext2);
            }
        }
        int n = 0;
        while (n < this.children.size()) {
            IUndoableOperation iUndoableOperation = (IUndoableOperation)this.children.get(n);
            if (iUndoableOperation.hasContext(iUndoContext)) {
                if (iUndoableOperation instanceof IContextReplacingOperation) {
                    ((IContextReplacingOperation)((Object)iUndoableOperation)).replaceContext(iUndoContext, iUndoContext2);
                } else {
                    iUndoableOperation.removeContext(iUndoContext);
                    iUndoableOperation.addContext(iUndoContext2);
                }
            }
            ++n;
        }
        this.recomputeContexts();
    }

    public void addContext(IUndoContext iUndoContext) {
        if (this.triggeringOperation != null) {
            this.triggeringOperation.addContext(iUndoContext);
            this.recomputeContexts();
        }
    }
}

