/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class SystemTestExpression
extends Expression {
    private String fProperty;
    private String fExpectedValue;
    private static final String ATT_PROPERTY = "property";
    private static final int HASH_INITIAL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.SystemTestExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public SystemTestExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fProperty = iConfigurationElement.getAttribute(ATT_PROPERTY);
        Expressions.checkAttribute(ATT_PROPERTY, this.fProperty);
        this.fExpectedValue = iConfigurationElement.getAttribute("value");
        Expressions.checkAttribute("value", this.fExpectedValue);
    }

    public SystemTestExpression(String string, String string2) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.fProperty = string;
        this.fExpectedValue = string2;
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        String string = System.getProperty(this.fProperty);
        if (string == null) {
            return EvaluationResult.FALSE;
        }
        return EvaluationResult.valueOf(string.equals(this.fExpectedValue));
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markSystemPropertyAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SystemTestExpression)) {
            return false;
        }
        SystemTestExpression systemTestExpression = (SystemTestExpression)object;
        return this.fProperty.equals(systemTestExpression.fProperty) && this.fExpectedValue.equals(systemTestExpression.fExpectedValue);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpectedValue.hashCode() * 89 + this.fProperty.hashCode();
    }

    public String toString() {
        return "<systemTest property=\"" + this.fProperty + "\" value=\"" + this.fExpectedValue + "\"";
    }
}

