/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler
implements IConfigurationConstants {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private URL currentSiteURL;
    private Configuration config;
    private URL configURL;
    private InputStream input;

    public ConfigurationParser() throws InvocationTargetException {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Utils.log(Utils.newStatus("ConfigurationParser", parserConfigurationException));
            throw new InvocationTargetException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Utils.log(Utils.newStatus("ConfigurationParser", sAXException));
            throw new InvocationTargetException(sAXException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Configuration parse(URL var1_1) throws Exception {
        block17: {
            block20: {
                block14: {
                    block15: {
                        Utils.debug("Start parsing Configuration:" + var1_1);
                        var2_2 = 0L;
                        this.configURL = var1_1;
                        if (!"file".equals(var1_1.getProtocol())) ** GOTO lbl28
                        var4_3 = new File(var1_1.getFile());
                        if (var4_3.exists()) {
                            if (var4_3.canRead()) break block14;
                        }
                        var5_5 = null;
                        if (this.config == null) break block15;
                        this.config.setLastModified(var2_2);
                    }
                    try {
                        if (this.input != null) {
                            this.input.close();
                            this.input = null;
                        }
                    }
                    catch (IOException var8_8) {
                        Utils.log(var8_8.getLocalizedMessage());
                    }
                    return null;
                }
                var2_2 = var4_3.lastModified();
                this.input = new FileInputStream(var4_3);
                break block20;
lbl28:
                // 1 sources

                this.input = var1_1.openStream();
            }
            this.parser.parse(new InputSource(this.input), (DefaultHandler)this);
            var7_11 = this.config;
            var5_6 = null;
            if (this.config == null) break block17;
            this.config.setLastModified(var2_2);
        }
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (IOException var8_9) {
            Utils.log(var8_9.getLocalizedMessage());
        }
        return var7_11;
        catch (Exception var4_4) {
            try {
                Utils.log(Utils.newStatus("ConfigurationParser.parse() error:", var4_4));
                throw var4_4;
            }
            catch (Throwable var6_12) {
                var5_7 = null;
                if (this.config != null) {
                    this.config.setLastModified(var2_2);
                }
                try {
                    if (this.input != null) {
                        this.input.close();
                        this.input = null;
                    }
                }
                catch (IOException var8_10) {
                    Utils.log(var8_10.getLocalizedMessage());
                }
                throw var6_12;
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        try {
            String string4 = string2.trim();
            if (string4.equalsIgnoreCase("config")) {
                this.processConfig(attributes);
                return;
            }
            if (string4.equalsIgnoreCase("site")) {
                this.processSite(attributes);
                return;
            }
            if (string4.equalsIgnoreCase("feature")) {
                this.processFeature(attributes);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException(NLS.bind((String)Messages.InstalledSiteParser_UnableToCreateURL, (Object[])new String[]{malformedURLException.getMessage()}), malformedURLException);
        }
        catch (CoreException coreException) {
            throw new SAXException(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{coreException.toString()}), (Exception)((Object)coreException));
        }
    }

    private void processSite(Attributes attributes) throws MalformedURLException, CoreException {
        Object object;
        Object object2;
        int n;
        if (this.config == null) {
            return;
        }
        this.currentSiteURL = null;
        String string = attributes.getValue("url");
        if (string == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL(PlatformConfiguration.getInstallURL(), string);
            return;
        }
        uRL = Utils.makeAbsolute(Utils.getInstallURL(), uRL);
        if (!this.isValidSite(uRL)) {
            return;
        }
        this.currentSiteURL = uRL;
        String[] stringArray = null;
        String string2 = attributes.getValue("policy");
        if (string2 == null) {
            n = PlatformConfiguration.getDefaultPolicy();
            stringArray = DEFAULT_POLICY_LIST;
        } else {
            int n2 = 0;
            while (n2 < CFG_POLICY_TYPE.length) {
                if (string2.equals(CFG_POLICY_TYPE[n2])) break;
                ++n2;
            }
            if (n2 >= CFG_POLICY_TYPE.length) {
                n = PlatformConfiguration.getDefaultPolicy();
                stringArray = DEFAULT_POLICY_LIST;
            } else {
                n = n2;
                object2 = attributes.getValue("list");
                if (object2 != null) {
                    object = new StringTokenizer((String)object2, ",");
                    stringArray = new String[((StringTokenizer)object).countTokens()];
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        stringArray[n2] = ((StringTokenizer)object).nextToken();
                        ++n2;
                    }
                }
            }
        }
        SitePolicy sitePolicy = new SitePolicy(n, stringArray);
        object2 = new SiteEntry(uRL, sitePolicy);
        object = attributes.getValue("updateable");
        if (object != null) {
            if (((String)object).equals("true")) {
                ((SiteEntry)object2).setUpdateable(true);
            } else {
                ((SiteEntry)object2).setUpdateable(false);
            }
        }
        if ((object = attributes.getValue("enabled")) != null && ((String)object).equals("false")) {
            ((SiteEntry)object2).setEnabled(false);
        } else {
            ((SiteEntry)object2).setEnabled(true);
        }
        String string3 = attributes.getValue("linkfile");
        if (string3 != null && !string3.equals("")) {
            ((SiteEntry)object2).setLinkFileName(string3.replace('/', File.separatorChar));
        }
        Utils.debug("End process config site url:" + string + " policy:" + string2 + " updatable:" + (String)object);
        this.config.addSiteEntry(uRL.toExternalForm(), (SiteEntry)object2);
    }

    private void processFeature(Attributes attributes) throws MalformedURLException, CoreException {
        URL[] uRLArray;
        String string;
        if (this.currentSiteURL == null) {
            return;
        }
        String string2 = attributes.getValue("id");
        if (string2 == null) {
            return;
        }
        String string3 = attributes.getValue("version");
        String string4 = attributes.getValue("plugin-version");
        if (string4 == null || string4.trim().length() == 0) {
            string4 = string3;
        }
        if ((string = attributes.getValue("plugin-identifier")) != null && string.trim().length() == 0) {
            string = null;
        }
        String string5 = attributes.getValue("application");
        String string6 = attributes.getValue("root");
        StringTokenizer stringTokenizer = string6 != null ? new StringTokenizer(string6, ",") : new StringTokenizer("");
        ArrayList<URL[]> arrayList = new ArrayList<URL[]>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            try {
                uRLArray = new URL(stringTokenizer.nextToken());
                arrayList.add(uRLArray);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        boolean bl = false;
        String string7 = attributes.getValue("primary");
        if (string7 != null && string7.equals("true")) {
            bl = true;
        }
        FeatureEntry featureEntry = new FeatureEntry(string2, string3, string, string4, bl, string5, uRLArray);
        String string8 = attributes.getValue("url");
        if (string8 != null && string8.trim().length() > 0) {
            featureEntry.setURL(string8);
        }
        SiteEntry siteEntry = this.config.getSiteEntry(this.currentSiteURL.toExternalForm());
        siteEntry.addFeatureEntry(featureEntry);
    }

    private void processConfig(Attributes attributes) {
        String string;
        String string2 = attributes.getValue("date");
        if (string2 == null || string2.trim().length() == 0) {
            this.config = new Configuration();
        } else {
            long l = 0L;
            try {
                l = Long.parseLong(string2);
                this.config = new Configuration(new Date(l));
            }
            catch (NumberFormatException numberFormatException) {
                l = new Date().getTime();
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_date, (Object[])new String[]{string2}));
                this.config = new Configuration();
            }
        }
        this.config.setURL(this.configURL);
        try {
            string = attributes.getValue("shared_ur");
            if (string != null) {
                ConfigurationParser configurationParser = new ConfigurationParser();
                URL uRL = Utils.makeAbsolute(Utils.getInstallURL(), new URL(string));
                Configuration configuration = configurationParser.parse(uRL);
                if (configuration == null) {
                    throw new Exception();
                }
                this.config.setLinkedConfig(configuration);
            }
        }
        catch (Exception exception) {
            Utils.log(Utils.newStatus(Messages.ConfigurationParser_cannotLoadSharedInstall, exception));
        }
        if ((string = attributes.getValue("transient")) != null) {
            this.config.setTransient(string.equals("true"));
        }
        Utils.debug("End Processing Config Tag: date:" + attributes.getValue("date"));
    }

    private boolean isValidSite(URL uRL) {
        URL uRL2 = uRL;
        if (uRL.getProtocol().equals("platform")) {
            try {
                uRL2 = PlatformConfiguration.resolvePlatformURL(uRL);
            }
            catch (IOException iOException) {}
        }
        if (!PlatformConfiguration.supportsDetection(uRL2)) {
            return false;
        }
        File file = new File(uRL2.getFile().replace('/', File.separatorChar));
        if (!file.exists()) {
            Utils.debug("Site " + uRL2 + " does not exist ");
            return false;
        }
        return true;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        Utils.debug("End Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        try {
            String string4 = string2.trim();
            if (string4.equalsIgnoreCase("config")) {
                SiteEntry[] siteEntryArray = this.config.getSites();
                int n = 0;
                while (n < siteEntryArray.length) {
                    siteEntryArray[n].initialized();
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {}
    }
}

