/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Hashtable;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.RegistryProviderFactory;
import org.eclipse.core.internal.registry.osgi.EquinoxRegistryStrategy;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryProviderOSGI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static final String STORAGE_DIR = "org.eclipse.core.runtime";
    private Object masterRegistryKey = new Object();
    private Object userRegistryKey = new Object();
    private IExtensionRegistry defaultRegistry = null;
    private ServiceRegistration registryRegistration;
    private RegistryProviderOSGI defaultProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void start(BundleContext bundleContext) throws Exception {
        Activator.bundleContext = bundleContext;
        RegistryProperties.setContext(Activator.bundleContext);
        this.processCommandLine();
        this.startRegistry();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.stopRegistry();
        RegistryProperties.setContext(null);
        Activator.bundleContext = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    private void processCommandLine() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        serviceTracker.open();
        EnvironmentInfo environmentInfo = (EnvironmentInfo)serviceTracker.getService();
        serviceTracker.close();
        if (environmentInfo == null) {
            return;
        }
        String[] stringArray = environmentInfo.getNonFrameworkArgs();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-noregistrycache")) {
                RegistryProperties.setProperty("eclipse.noRegistryCache", "true");
            } else if (stringArray[n].equalsIgnoreCase("-noLazyRegistryCacheLoading")) {
                RegistryProperties.setProperty("eclipse.noLazyRegistryCacheLoading", "true");
            }
            ++n;
        }
    }

    public void startRegistry() throws CoreException {
        boolean[] blArray;
        File[] fileArray;
        Object object;
        String string = bundleContext.getProperty("eclipse.createRegistry");
        if (string != null && string.equalsIgnoreCase("false")) {
            return;
        }
        if ("true".equals(bundleContext.getProperty("eclipse.registry.nulltoken"))) {
            this.userRegistryKey = null;
        }
        Location location = OSGIUtils.getDefault().getConfigurationLocation();
        File file = new File(String.valueOf(location.getURL().getPath()) + '/' + STORAGE_DIR);
        boolean bl = location.isReadOnly();
        Location location2 = location.getParentLocation();
        if (location2 != null) {
            object = new File(String.valueOf(location2.getURL().getFile()) + '/' + STORAGE_DIR);
            fileArray = new File[]{file, object};
            blArray = new boolean[]{bl, true};
        } else {
            fileArray = new File[]{file};
            blArray = new boolean[]{bl};
        }
        object = new EquinoxRegistryStrategy(fileArray, blArray, this.masterRegistryKey);
        this.defaultRegistry = RegistryFactory.createRegistry((RegistryStrategy)object, this.masterRegistryKey, this.userRegistryKey);
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registryRegistration = bundleContext.registerService(clazz.getName(), (Object)this.defaultRegistry, new Hashtable());
        this.defaultProvider = new RegistryProviderOSGI();
        RegistryProviderFactory.setDefault(this.defaultProvider);
    }

    private void stopRegistry() {
        if (this.defaultRegistry != null) {
            RegistryProviderFactory.releaseDefault();
            this.defaultProvider.release();
            this.registryRegistration.unregister();
            this.defaultRegistry.stop(this.masterRegistryKey);
        }
    }
}

