/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class EclipseLogHook
implements HookConfigurator,
AdaptorHook {
    private static final String LOG_EXT = ".log";
    BaseAdaptor adaptor;
    static /* synthetic */ Class class$0;

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AdaptorUtil.register(clazz.getName(), this.adaptor.getFrameworkLog(), bundleContext);
        this.registerPerformanceLog(bundleContext);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public boolean matchDNChain(String string, String[] stringArray) {
        return false;
    }

    public FrameworkLog createFrameworkLog() {
        EclipseLog eclipseLog;
        String string = FrameworkProperties.getProperty("osgi.logfile");
        if (string != null) {
            eclipseLog = new EclipseLog(new File(string));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File file = null;
            if (location != null) {
                file = new File(location.getURL().getFile());
            }
            if (file != null) {
                String string2 = String.valueOf(Long.toString(System.currentTimeMillis())) + LOG_EXT;
                File file2 = new File(file, string2);
                FrameworkProperties.setProperty("osgi.logfile", file2.getAbsolutePath());
                eclipseLog = new EclipseLog(file2);
            } else {
                eclipseLog = new EclipseLog();
            }
        }
        if ("true".equals(FrameworkProperties.getProperty("eclipse.consoleLog"))) {
            eclipseLog.setConsoleLog(true);
        }
        return eclipseLog;
    }

    private void registerPerformanceLog(BundleContext bundleContext) {
        FrameworkLog frameworkLog = this.createPerformanceLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz.getName();
        Hashtable hashtable = new Hashtable(7);
        Dictionary dictionary = bundleContext.getBundle().getHeaders();
        hashtable.put("service.vendor", dictionary.get("Bundle-Vendor"));
        hashtable.put("service.ranking", new Integer(Integer.MIN_VALUE));
        hashtable.put("service.pid", String.valueOf(bundleContext.getBundle().getBundleId() + 46L) + frameworkLog.getClass().getName());
        hashtable.put("performance", Boolean.TRUE.toString());
        bundleContext.registerService(string, (Object)frameworkLog, hashtable);
    }

    private FrameworkLog createPerformanceLog() {
        int n;
        String string = FrameworkProperties.getProperty("osgi.logfile");
        if (string != null && (n = string.lastIndexOf(File.separatorChar)) > 0) {
            String string2 = String.valueOf(string.substring(0, n + 1)) + "performance.log";
            return new EclipseLog(new File(string2));
        }
        return new EclipseLog(new PrintWriter(System.err));
    }
}

