/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;

public class SystemPolicy
implements IBuddyPolicy {
    public static final byte BOOT = 0;
    public static final byte EXT = 1;
    public static final byte APP = 2;
    private static SystemPolicy[] instances = new SystemPolicy[3];
    private ClassLoader classLoader;

    public static SystemPolicy getInstance(final byte by) {
        if (instances[by] == null) {
            SystemPolicy.instances[by] = new SystemPolicy();
            SystemPolicy.instances[by].classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SystemPolicy.createClassLoader(by);
                }
            });
        }
        return instances[by];
    }

    public SystemPolicy() {
    }

    public SystemPolicy(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static ClassLoader createClassLoader(byte by) {
        switch (by) {
            case 2: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return new ParentClassLoader();
            }
            case 0: {
                return new ParentClassLoader();
            }
            case 1: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
                return new ParentClassLoader();
            }
        }
        return null;
    }

    public Class loadClass(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public URL loadResource(String string) {
        return this.classLoader.getResource(string);
    }

    public Enumeration loadResources(String string) {
        try {
            return this.classLoader.getResources(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

