/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.launcher;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.Tokenizer;
import org.eclipse.osgi.util.NLS;

public class Launcher {
    protected String consolePort = "";
    protected boolean console = false;
    protected String adaptorClassName = "org.eclipse.osgi.baseadaptor.BaseAdaptor";
    protected final String osgiConsoleClazz = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    protected String[] adaptorArgs = null;
    private static final String OSGI_CONSOLE_COMPONENT_NAME = "OSGi Console";
    private static final String OSGI_CONSOLE_COMPONENT = "console.jar";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void main(String[] stringArray) {
        new Launcher().doIt(stringArray);
    }

    protected void doIt(String[] stringArray) {
        String[] stringArray2 = this.parseArgs(stringArray);
        FrameworkAdaptor frameworkAdaptor = null;
        try {
            frameworkAdaptor = this.doAdaptor();
        }
        catch (Exception exception) {
            System.out.println(Msg.LAUNCHER_ADAPTOR_ERROR);
            exception.printStackTrace();
            return;
        }
        OSGi oSGi = this.doOSGi(frameworkAdaptor);
        if (oSGi != null) {
            if (this.console) {
                this.doConsole(oSGi, stringArray2);
            } else {
                oSGi.launch();
            }
        }
    }

    protected String[] parseArgs(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            Tokenizer tokenizer;
            boolean bl = false;
            String string = stringArray[n];
            int n2 = string.indexOf("\"");
            if (n2 > 0) {
                if (n2 == string.lastIndexOf("\"")) {
                    boolean bl2 = true;
                    ++n;
                    while (n < stringArray.length && bl2) {
                        string = String.valueOf(string) + " " + stringArray[n];
                        ++n;
                        if (n2 >= string.lastIndexOf("\"")) continue;
                        bl2 = false;
                    }
                }
            } else {
                n2 = string.indexOf("'");
                if (n2 > 0) {
                    if (n2 == string.lastIndexOf("'")) {
                        boolean bl3 = true;
                        ++n;
                        while (n < stringArray.length && bl3) {
                            string = String.valueOf(string) + " " + stringArray[n];
                            ++n;
                            if (n2 >= string.lastIndexOf("'")) continue;
                            bl3 = false;
                        }
                    }
                    string = string.replace('\'', '\"');
                }
            }
            if ((tokenizer = new Tokenizer(string)).hasMoreTokens()) {
                String string2 = tokenizer.getString(" ");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                String string3 = stringTokenizer.nextToken().toLowerCase();
                if (Launcher.matchCommand("-console", string3, 4)) {
                    this._console(string2);
                    bl = true;
                }
                if (Launcher.matchCommand("-adaptor", string3, 2)) {
                    this._adaptor(string2);
                    bl = true;
                }
                if (!bl) {
                    vector.addElement(string);
                }
            }
            ++n;
        }
        String[] stringArray2 = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = (String)enumeration.nextElement();
            ++n3;
        }
        return stringArray2;
    }

    public static boolean matchCommand(String string, String string2, int n) {
        int n2;
        if (n <= 0) {
            n = string.length();
        }
        if (n > (n2 = string2.length())) {
            n2 = n;
        }
        return string.regionMatches(0, string2, 0, n2);
    }

    protected void _console(String string) {
        this.console = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.consolePort = stringTokenizer.nextToken();
        }
    }

    protected void _adaptor(String string) {
        Tokenizer tokenizer = new Tokenizer(string);
        tokenizer.getToken(":");
        tokenizer.getChar();
        String string2 = tokenizer.getToken(":");
        if (string2.length() > 0) {
            this.adaptorClassName = string2;
        }
        Vector<String> vector = new Vector<String>();
        while (true) {
            tokenizer.getChar();
            String string3 = tokenizer.getString(":");
            if (string3 == null) break;
            vector.addElement(string3);
        }
        if (vector != null) {
            int n = vector.size();
            this.adaptorArgs = new String[n];
            Enumeration enumeration = vector.elements();
            int n2 = 0;
            while (n2 < n) {
                this.adaptorArgs[n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
    }

    protected FrameworkAdaptor doAdaptor() throws Exception {
        Class<?> clazz = Class.forName(this.adaptorClassName);
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class[] classArray2 = classArray;
        Constructor<?> constructor = clazz.getConstructor(classArray2);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{this.adaptorArgs});
    }

    private OSGi doOSGi(FrameworkAdaptor frameworkAdaptor) {
        return new OSGi(frameworkAdaptor);
    }

    private void doConsole(OSGi oSGi, String[] stringArray) {
        try {
            Object[] objectArray;
            Class[] classArray;
            Class<?> clazz = Class.forName("org.eclipse.osgi.framework.internal.core.FrameworkConsole");
            if (this.consolePort.length() == 0) {
                Class[] classArray2 = new Class[2];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz2;
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[1] = clazz3;
                classArray = classArray2;
                objectArray = new Object[]{oSGi, stringArray};
            } else {
                Class[] classArray3 = new Class[3];
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray3[0] = clazz4;
                classArray3[1] = Integer.TYPE;
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray3[2] = clazz5;
                classArray = classArray3;
                objectArray = new Object[]{oSGi, new Integer(this.consolePort), stringArray};
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            Thread thread = new Thread((Runnable)obj, OSGI_CONSOLE_COMPONENT_NAME);
            thread.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(NLS.bind(Msg.LAUNCHER_INVALID_PORT, this.consolePort));
        }
        catch (Exception exception) {
            this.informAboutMissingComponent(OSGI_CONSOLE_COMPONENT_NAME, OSGI_CONSOLE_COMPONENT);
        }
    }

    void informAboutMissingComponent(String string, String string2) {
        System.out.println();
        System.out.print(NLS.bind(Msg.LAUNCHER_COMPONENT_MISSING, string));
        System.out.println(NLS.bind(Msg.LAUNCHER_COMPONENT_JAR, string2));
        System.out.println();
    }
}

