/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.presentations.NativeStackPresentation;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class PartStack
extends LayoutPart
implements ILayoutContainer {
    private List children = new ArrayList(3);
    protected int appearance = 2;
    private LayoutPart requestedCurrent;
    private LayoutPart current;
    private LayoutPart presentationCurrent;
    private boolean ignoreSelectionChanges = false;
    protected IMemento savedPresentationState = null;
    private DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        public void close(IPresentablePart iPresentablePart) {
            PartStack.this.close(iPresentablePart);
        }

        public void close(IPresentablePart[] iPresentablePartArray) {
            PartStack.this.close(iPresentablePartArray);
        }

        public void dragStart(IPresentablePart iPresentablePart, Point point, boolean bl) {
        }

        public void dragStart(Point point, boolean bl) {
        }

        public boolean isPartMoveable(IPresentablePart iPresentablePart) {
            return false;
        }

        public void selectPart(IPresentablePart iPresentablePart) {
            PartStack.this.presentationSelectionChanged(iPresentablePart);
        }

        public boolean supportsState(int n) {
            return PartStack.this.supportsState(n);
        }

        public void setState(int n) {
            PartStack.this.setState(n);
        }

        public IPresentablePart getSelectedPart() {
            return PartStack.this.getSelectedPart();
        }

        public boolean isStackMoveable() {
            return PartStack.this.canMoveFolder();
        }

        public void flushLayout() {
            PartStack.this.flushLayout();
        }

        public IPresentablePart[] getPartList() {
            List list = PartStack.this.getPresentableParts();
            return list.toArray(new IPresentablePart[list.size()]);
        }
    };
    private boolean isMinimized;

    protected abstract boolean supportsState(int var1);

    protected abstract boolean canMoveFolder();

    protected abstract void derefPart(LayoutPart var1);

    public PartStack(int n) {
        super("PartStack");
        this.appearance = n;
    }

    protected final boolean isStandalone() {
        return false;
    }

    protected IPresentablePart getSelectedPart() {
        if (this.presentationCurrent == null) {
            return null;
        }
        return this.presentationCurrent.getPresentablePart();
    }

    protected IStackPresentationSite getPresentationSite() {
        return this.presentationSite;
    }

    public void describeLayout(StringBuffer stringBuffer) {
        int n = this.getActive();
        if (n == 1) {
            stringBuffer.append("active ");
        } else if (n == 2) {
            stringBuffer.append("active_nofocus ");
        }
        stringBuffer.append("(");
        LayoutPart[] layoutPartArray = this.getChildren();
        int n2 = 0;
        int n3 = 0;
        while (n3 < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n3];
            if (!(layoutPart instanceof PartPlaceholder)) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                if (layoutPart == this.requestedCurrent) {
                    stringBuffer.append("*");
                }
                layoutPart.describeLayout(stringBuffer);
                ++n2;
            }
            ++n3;
        }
        stringBuffer.append(")");
    }

    public void add(LayoutPart layoutPart) {
        this.children.add(layoutPart);
        this.showPart(layoutPart, null);
    }

    protected void add(LayoutPart layoutPart, Object object) {
        this.children.add(layoutPart);
        this.showPart(layoutPart, object);
    }

    public boolean allowsAdd(LayoutPart layoutPart) {
        return !this.isStandalone();
    }

    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        ILayoutContainer iLayoutContainer = this.getContainer();
        return iLayoutContainer == null || iLayoutContainer.allowsAutoFocus();
    }

    protected void close(IPresentablePart[] iPresentablePartArray) {
        int n = 0;
        while (n < iPresentablePartArray.length) {
            IPresentablePart iPresentablePart = iPresentablePartArray[n];
            this.close(iPresentablePart);
            ++n;
        }
    }

    protected void close(IPresentablePart iPresentablePart) {
        if (!this.presentationSite.isCloseable(iPresentablePart)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(iPresentablePart);
        if (layoutPart != null && layoutPart instanceof PartPane) {
            PartPane partPane = (PartPane)layoutPart;
            partPane.doHide();
        }
    }

    public boolean isDisposed() {
        return this.getPresentation() == null;
    }

    public void createControl(Composite composite) {
        if (!this.isDisposed()) {
            return;
        }
        NativeStackPresentation nativeStackPresentation = new NativeStackPresentation(composite, this.presentationSite);
        this.createControl(composite, nativeStackPresentation);
    }

    public void createControl(Composite composite, StackPresentation stackPresentation) {
        Object object;
        Assert.isTrue((boolean)this.isDisposed());
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        this.presentationSite.setPresentation(stackPresentation);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            object = (LayoutPart)iterator.next();
            this.showPart((LayoutPart)object, null);
        }
        object = this.getPresentation().getControl();
        object.setData((Object)this);
        this.updateActions(this.presentationCurrent);
        if (this.requestedCurrent instanceof PartPlaceholder) {
            this.requestedCurrent = null;
            this.updateContainerVisibleTab();
        }
        this.refreshPresentationSelection();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.presentationSite.dispose();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LayoutPart layoutPart = (LayoutPart)iterator.next();
            layoutPart.setContainer(null);
        }
        this.presentationCurrent = null;
        this.current = null;
    }

    public Rectangle getBounds() {
        System.out.println("PartStack:getBounds: returning hardcoded bounds");
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    public Control getControl() {
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation == null) {
            return null;
        }
        return stackPresentation.getControl();
    }

    public int getItemCount() {
        if (this.isDisposed()) {
            return this.children.size();
        }
        return this.getPresentableParts().size();
    }

    protected LayoutPart getPaneFor(IPresentablePart iPresentablePart) {
        if (iPresentablePart == null) {
            return null;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LayoutPart layoutPart = (LayoutPart)iterator.next();
            if (layoutPart.getPresentablePart() != iPresentablePart) continue;
            return layoutPart;
        }
        return null;
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    private IPresentablePart getPresentablePartAtIndex(int n) {
        List list = this.getPresentableParts();
        if (n >= 0 && n < list.size()) {
            return (IPresentablePart)list.get(n);
        }
        return null;
    }

    public List getPresentableParts() {
        ArrayList<IPresentablePart> arrayList = new ArrayList<IPresentablePart>(this.children.size());
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LayoutPart layoutPart = (LayoutPart)iterator.next();
            IPresentablePart iPresentablePart = layoutPart.getPresentablePart();
            if (iPresentablePart == null) continue;
            arrayList.add(iPresentablePart);
        }
        return arrayList;
    }

    protected StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public PartPane getVisiblePart() {
        if (this.current instanceof PartPane) {
            return (PartPane)this.current;
        }
        return null;
    }

    private void presentationSelectionChanged(IPresentablePart iPresentablePart) {
        if (this.ignoreSelectionChanges) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(iPresentablePart);
        Assert.isNotNull((Object)layoutPart);
        if (layoutPart == this.requestedCurrent) {
            return;
        }
        this.setSelection(layoutPart);
        if (layoutPart != null) {
            layoutPart.setFocus();
        }
    }

    public void remove(LayoutPart layoutPart) {
        IPresentablePart iPresentablePart = layoutPart.getPresentablePart();
        this.children.remove(layoutPart);
        StackPresentation stackPresentation = this.getPresentation();
        if (iPresentablePart != null && stackPresentation != null) {
            this.ignoreSelectionChanges = true;
            stackPresentation.removePart(iPresentablePart);
            this.ignoreSelectionChanges = false;
        }
        if (!this.isDisposed()) {
            layoutPart.setContainer(null);
        }
        if (layoutPart == this.requestedCurrent) {
            this.updateContainerVisibleTab();
        }
    }

    public void reparent(Composite composite) {
        if (!composite.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == composite) {
            return;
        }
        super.reparent(composite);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LayoutPart layoutPart = (LayoutPart)iterator.next();
            layoutPart.reparent(composite);
        }
    }

    public void replace(LayoutPart layoutPart, LayoutPart layoutPart2) {
        int n = this.children.indexOf(layoutPart);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.children.get(n3) instanceof PartPlaceholder) {
                ++n2;
            }
            ++n3;
        }
        Integer n4 = new Integer(n - n2);
        this.children.add(n, layoutPart2);
        this.showPart(layoutPart2, n4);
        if (layoutPart == this.requestedCurrent && !(layoutPart2 instanceof PartPlaceholder)) {
            this.setSelection(layoutPart2);
        }
        this.remove(layoutPart);
    }

    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        return this.getPresentation().computePreferredSize(bl, n, n2, n3);
    }

    public int getSizeFlags(boolean bl) {
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            return stackPresentation.getSizeFlags(bl);
        }
        return 0;
    }

    public IStatus restoreState(IMemento iMemento) {
        Integer n;
        IMemento[] iMementoArray;
        Object object;
        String string = iMemento.getString("activePageID");
        IMemento[] iMementoArray2 = iMemento.getChildren("page");
        if (iMementoArray2 != null) {
            int n2 = 0;
            while (n2 < iMementoArray2.length) {
                object = iMementoArray2[n2];
                iMementoArray = object.getString("content");
                PartPlaceholder partPlaceholder = new PartPlaceholder((String)iMementoArray);
                partPlaceholder.setContainer(this);
                this.add(partPlaceholder);
                if (iMementoArray.equals(string)) {
                    this.setSelection(partPlaceholder);
                }
                ++n2;
            }
        }
        this.setState((n = iMemento.getInteger("expanded")) == null || n != 0 ? 2 : 0);
        object = iMemento.getInteger("appearance");
        if (object != null) {
            this.appearance = (Integer)object;
        }
        this.savedPresentationState = null;
        iMementoArray = iMemento.getChildren("presentation");
        int n3 = 0;
        while (n3 < iMementoArray.length) {
            IMemento iMemento2 = iMementoArray[n3];
            iMemento2.getString("id");
            ++n3;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            stackPresentation.setVisible(bl);
        }
    }

    public IStatus saveState(IMemento iMemento) {
        Object object;
        if (this.requestedCurrent != null) {
            iMemento.putString("activePageID", this.requestedCurrent.getCompoundId());
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            object = (LayoutPart)iterator.next();
            IMemento iMemento2 = iMemento.createChild("page");
            IPresentablePart iPresentablePart = ((LayoutPart)object).getPresentablePart();
            String string = "LabelNotFound";
            if (iPresentablePart != null) {
                string = iPresentablePart.getName();
            }
            iMemento2.putString("label", string);
            iMemento2.putString("content", ((LayoutPart)object).getCompoundId());
        }
        iMemento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        iMemento.putInteger("appearance", this.appearance);
        if (this.savedPresentationState != null) {
            object = iMemento.createChild("presentation");
            object.putMemento(this.savedPresentationState);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    protected WorkbenchPage getPage() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        return (WorkbenchPage)workbenchWindow.getActivePage();
    }

    public void setActive(int n) {
        if (n == 1) {
            this.setMinimized(false);
        }
        this.presentationSite.setActive(n);
    }

    public int getActive() {
        return this.presentationSite.getActive();
    }

    public void setBounds(Rectangle rectangle) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(rectangle);
        }
    }

    public void setSelection(LayoutPart layoutPart) {
        if (layoutPart == this.requestedCurrent) {
            return;
        }
        this.requestedCurrent = layoutPart;
        this.refreshPresentationSelection();
    }

    protected abstract void updateActions(LayoutPart var1);

    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        this.refreshPresentationSelection();
    }

    private void refreshPresentationSelection() {
        if (this.isDeferred()) {
            return;
        }
        if (this.current == this.requestedCurrent) {
            return;
        }
        StackPresentation stackPresentation = this.getPresentation();
        if (stackPresentation != null) {
            IPresentablePart iPresentablePart;
            this.presentationCurrent = this.requestedCurrent;
            if (!this.isDisposed()) {
                this.updateActions(this.presentationCurrent);
            }
            if (this.presentationCurrent != null && (iPresentablePart = this.requestedCurrent.getPresentablePart()) != null && stackPresentation != null) {
                this.requestedCurrent.createControl(this.getParent());
                if (this.requestedCurrent.getControl().getParent() != this.getControl().getParent()) {
                    this.requestedCurrent.reparent(this.getControl().getParent());
                }
                this.requestedCurrent.moveAbove(this.getPresentation().getControl());
                stackPresentation.selectPart(this.presentationCurrent.getPresentablePart());
            }
            this.current = this.requestedCurrent;
        }
    }

    public int getState() {
        return this.presentationSite.getState();
    }

    public void setMinimized(boolean bl) {
        if (bl != this.isMinimized) {
            this.isMinimized = bl;
            this.refreshPresentationState();
        }
    }

    public boolean childObscuredByZoom(LayoutPart layoutPart) {
        return this.isObscuredByZoom();
    }

    public void childRequestZoomIn(LayoutPart layoutPart) {
        super.childRequestZoomIn(layoutPart);
        this.requestZoomIn();
    }

    public void childRequestZoomOut() {
        super.childRequestZoomOut();
        this.requestZoomOut();
    }

    public boolean childIsZoomed(LayoutPart layoutPart) {
        return this.isZoomed();
    }

    protected void setState(int n) {
        int n2 = this.presentationSite.getState();
        if (!this.supportsState(n) || n == n2) {
            return;
        }
        boolean bl = n == 0;
        this.setMinimized(bl);
        if (n == 1) {
            this.requestZoomIn();
        } else if (n2 == 1) {
            this.requestZoomOut();
        }
    }

    public void setZoomed(boolean bl) {
        super.setZoomed(bl);
        LayoutPart[] layoutPartArray = this.getChildren();
        int n = 0;
        while (n < layoutPartArray.length) {
            LayoutPart layoutPart = layoutPartArray[n];
            layoutPart.setZoomed(bl);
            ++n;
        }
        this.refreshPresentationState();
    }

    public boolean isZoomed() {
        ILayoutContainer iLayoutContainer = this.getContainer();
        if (iLayoutContainer != null) {
            return iLayoutContainer.childIsZoomed(this);
        }
        return false;
    }

    private void refreshPresentationState() {
        if (this.isZoomed()) {
            this.presentationSite.setPresentationState(1);
        } else {
            boolean bl;
            boolean bl2 = bl = this.presentationSite.getState() == 0;
            if (this.isMinimized) {
                this.presentationSite.setPresentationState(0);
            } else {
                this.presentationSite.setPresentationState(2);
            }
            if (this.isMinimized != bl) {
                WorkbenchPage workbenchPage;
                this.flushLayout();
                if (this.isMinimized && (workbenchPage = this.getPage()) != null) {
                    workbenchPage.refreshActiveView();
                }
            }
        }
    }

    private void showPart(LayoutPart layoutPart, Object object) {
        if (this.isDisposed()) {
            return;
        }
        layoutPart.setContainer(this);
        IPresentablePart iPresentablePart = layoutPart.getPresentablePart();
        if (iPresentablePart == null) {
            return;
        }
        this.presentationSite.getPresentation().addPart(iPresentablePart, object);
        if (this.requestedCurrent == null) {
            this.setSelection(layoutPart);
        }
    }

    private void updateContainerVisibleTab() {
        Object object;
        Object object2;
        LayoutPart[] layoutPartArray = this.getChildren();
        if (layoutPartArray.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane partPane = null;
        int n = 0;
        WorkbenchPage workbenchPage = this.getPage();
        if (workbenchPage != null) {
            object2 = workbenchPage.getSortedParts();
            object = Arrays.asList(object2);
            int n2 = 0;
            while (n2 < layoutPartArray.length) {
                IWorkbenchPartReference iWorkbenchPartReference;
                int n3;
                if (layoutPartArray[n2] instanceof PartPane && (n3 = object.indexOf(iWorkbenchPartReference = ((PartPane)layoutPartArray[n2]).getPartReference())) >= n) {
                    n = n3;
                    partPane = (PartPane)layoutPartArray[n2];
                }
                ++n2;
            }
        }
        if (partPane == null && (object2 = this.getPresentableParts()).size() != 0) {
            object = (IPresentablePart)this.getPresentableParts().get(0);
            partPane = (PartPane)this.getPaneFor((IPresentablePart)object);
        }
        this.setSelection(partPane);
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    public void showPartList() {
        this.getPresentation().showPartList();
    }

    public Control[] getTabList(LayoutPart layoutPart) {
        if (layoutPart != null) {
            IPresentablePart iPresentablePart = layoutPart.getPresentablePart();
            StackPresentation stackPresentation = this.getPresentation();
            if (iPresentablePart != null && stackPresentation != null) {
                return stackPresentation.getTabList(iPresentablePart);
            }
        }
        return new Control[0];
    }

    public IMemento getSavedPresentationState() {
        return this.savedPresentationState;
    }
}

