/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayoutUtil;
import org.eclipse.ui.internal.layout.GridInfo;
import org.eclipse.ui.internal.layout.LayoutCache;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.layout.SizeCache;

public class CellLayout
extends Layout {
    private Row defaultRowSettings = new Row(false);
    private Row defaultColSettings = new Row(true);
    int horizontalSpacing = 5;
    int verticalSpacing = 5;
    public int marginWidth = 5;
    public int marginHeight = 5;
    private int numCols;
    private List cols;
    private List rows = new ArrayList(16);
    private GridInfo gridInfo = new GridInfo();
    private int[] cachedRowMin = null;
    private int[] cachedColMin = null;
    public static int cacheMisses;
    public static int cacheHits;
    private LayoutCache cache = new LayoutCache();

    public CellLayout(int n) {
        this.numCols = n;
        this.cols = new ArrayList(n == 0 ? 3 : n);
    }

    public CellLayout setSpacing(int n, int n2) {
        this.horizontalSpacing = n;
        this.verticalSpacing = n2;
        return this;
    }

    public CellLayout setSpacing(Point point) {
        this.horizontalSpacing = point.x;
        this.verticalSpacing = point.y;
        return this;
    }

    public Point getSpacing() {
        return new Point(this.horizontalSpacing, this.verticalSpacing);
    }

    public CellLayout setMargins(int n, int n2) {
        this.marginWidth = n;
        this.marginHeight = n2;
        return this;
    }

    public CellLayout setMargins(Point point) {
        this.marginWidth = point.x;
        this.marginHeight = point.y;
        return this;
    }

    public Point getMargins() {
        return new Point(this.marginWidth, this.marginHeight);
    }

    public CellLayout setDefaultColumn(Row row) {
        this.defaultColSettings = row;
        return this;
    }

    public CellLayout setColumn(int n, Row row) {
        while (this.cols.size() <= n) {
            this.cols.add(null);
        }
        this.cols.set(n, row);
        return this;
    }

    public CellLayout setDefaultRow(Row row) {
        this.defaultRowSettings = row;
        return this;
    }

    public CellLayout setRow(int n, Row row) {
        while (this.rows.size() <= n) {
            this.rows.add(null);
        }
        this.rows.set(n, row);
        return this;
    }

    private Row getRow(int n, boolean bl) {
        if (bl) {
            if (n >= this.rows.size()) {
                return this.defaultRowSettings;
            }
            Row row = (Row)this.rows.get(n);
            if (row == null) {
                row = this.defaultRowSettings;
            }
            return row;
        }
        if (n >= this.cols.size()) {
            return this.defaultColSettings;
        }
        Row row = (Row)this.cols.get(n);
        if (row == null) {
            row = this.defaultColSettings;
        }
        return row;
    }

    private void initGrid(Control[] controlArray) {
        this.cache.setControls(controlArray);
        this.gridInfo.initGrid(controlArray, this);
        this.cachedRowMin = null;
        this.cachedColMin = null;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        boolean bl2;
        Control[] controlArray = composite.getChildren();
        this.initGrid(controlArray);
        if (bl) {
            this.cache.flush();
        }
        Point point = this.totalEmptySpace();
        int[] nArray = this.computeConstraints(true);
        int n3 = n == -1 ? this.preferredSize(nArray, false) : n - point.x;
        int n4 = n2;
        n4 = n2 == -1 ? this.preferredSize(this.computeSizes(nArray, n3, false), true) : n2 - point.y;
        Point point2 = new Point(n3 + point.x, n4 + point.y);
        Point point3 = CellLayoutUtil.computeMinimumSize(composite);
        boolean bl3 = point2.x >= point3.x;
        boolean bl4 = bl2 = point2.y >= point3.y;
        if (bl3) {
            if (bl2) {
                return point2;
            }
            return this.computeSize(composite, n, point3.y, false);
        }
        if (bl2) {
            return this.computeSize(composite, point3.x, n2, false);
        }
        return point3;
    }

    int[] computeSizes(int[] nArray, int n, boolean bl) {
        int[] nArray2 = this.computeMinSizes(nArray, bl);
        int n2 = CellLayout.sumOfSizes(nArray2);
        int n3 = this.getResizeDenominator(bl);
        int n4 = this.gridInfo.getNumRows(bl);
        if (n2 < n) {
            int n5 = n - n2;
            int n6 = 0;
            while (n6 < n4 && n3 > 0) {
                Row row = this.getRow(n6, bl);
                if (row.grows) {
                    int n7 = row.size;
                    int n8 = n5 * n7 / n3;
                    int n9 = n6;
                    nArray2[n9] = nArray2[n9] + n8;
                    n5 -= n8;
                    n3 -= n7;
                }
                ++n6;
            }
        }
        return nArray2;
    }

    int preferredSize(int[] nArray, boolean bl) {
        int[] nArray2 = this.computeMinSizes(nArray, bl);
        return CellLayout.sumOfSizes(nArray2) + this.getDynamicSize(nArray, nArray2, bl);
    }

    static int sumOfSizes(int[] nArray) {
        return CellLayout.sumOfSizes(nArray, 0, nArray.length);
    }

    static int sumOfSizes(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            int n5 = nArray[n4];
            if (n5 == -1) {
                return -1;
            }
            n3 += n5;
            ++n4;
        }
        return n3;
    }

    int getDynamicSize(int[] nArray, int[] nArray2, boolean bl) {
        int n = 0;
        int n2 = this.getResizeDenominator(bl);
        if (n2 == 0) {
            return 0;
        }
        int n3 = bl ? this.verticalSpacing : this.horizontalSpacing;
        int n4 = bl ? this.horizontalSpacing : this.verticalSpacing;
        int n5 = this.gridInfo.controls.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = this.gridInfo.getStartPos(n6, bl);
            int n8 = this.getSpan(n6, bl);
            int n9 = this.gridInfo.getStartPos(n6, !bl);
            int n10 = this.getSpan(n6, !bl);
            int n11 = this.getGrowthRatio(n7, n8, bl);
            if (n11 > 0) {
                int n12 = CellLayout.sumOfSizes(nArray, n9, n10);
                if (n12 != -1) {
                    n12 += n4 * (n10 - 1);
                }
                int n13 = this.computeControlSize(n6, n12, bl);
                n13 -= CellLayout.sumOfSizes(nArray2, n7, n8);
                n = Math.max(n, (n13 -= n3 * (n8 - 1)) * n2 / n11);
            }
            ++n6;
        }
        return n;
    }

    int computeControlSize(int n, int n2, boolean bl) {
        CellData cellData = this.gridInfo.getCellData(n);
        if (n2 == -1) {
            Point point = cellData.computeSize(this.cache.getCache(n), -1, -1);
            if (bl) {
                return point.y;
            }
            return point.x;
        }
        if (bl) {
            return cellData.computeSize((SizeCache)this.cache.getCache((int)n), (int)n2, (int)-1).y;
        }
        return cellData.computeSize((SizeCache)this.cache.getCache((int)n), (int)-1, (int)n2).x;
    }

    int getGrowthRatio(int n, int n2, boolean bl) {
        boolean bl2 = false;
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            Row row = this.getRow(n5, bl);
            if (row.largerThanChildren && row.grows) {
                bl2 = true;
            }
            n3 += row.size;
            ++n5;
        }
        if (!bl2) {
            return 0;
        }
        return n3;
    }

    int[] computeMinSizes(int[] nArray, boolean bl) {
        int[] nArray2;
        int[] nArray3 = nArray2 = bl ? this.cachedRowMin : this.cachedColMin;
        if (nArray2 == null) {
            int n;
            int n2;
            if (bl) {
                n2 = this.horizontalSpacing;
                n = this.verticalSpacing;
            } else {
                n2 = this.verticalSpacing;
                n = this.horizontalSpacing;
            }
            int n3 = this.gridInfo.getNumRows(bl);
            nArray2 = new int[n3];
            int n4 = this.gridInfo.getNumRows(!bl);
            int[] nArray4 = new int[n4];
            int n5 = -1;
            int n6 = 0;
            while (n6 < n3) {
                Row row = this.getRow(n6, bl);
                if (row.grows) {
                    n5 = n6;
                    nArray2[n6] = 0;
                } else {
                    nArray2[n6] = row.size;
                    if (row.largerThanChildren) {
                        this.gridInfo.getRow(nArray4, n6, bl);
                        int n7 = 0;
                        while (n7 < nArray4.length) {
                            int n8;
                            int n9;
                            int n10 = nArray4[n7];
                            if (n10 != -1 && (n9 = this.gridInfo.getStartPos(n10, bl)) + (n8 = this.getSpan(n10, bl)) - 1 == n6 && n9 > n5) {
                                int n11 = this.gridInfo.getStartPos(n10, !bl);
                                int n12 = this.getSpan(n10, !bl);
                                int n13 = this.getSpan(n10, bl);
                                int n14 = CellLayout.sumOfSizes(nArray, n11, n12);
                                if (n14 != -1) {
                                    n14 += n2 * (n8 - 1);
                                }
                                int n15 = this.computeControlSize(n10, n14, bl);
                                int n16 = CellLayout.sumOfSizes(nArray2, n11, n13 - 1) + n * (n13 - 1);
                                nArray2[n6] = Math.max(nArray2[n6], n15 - n16);
                            }
                            ++n7;
                        }
                    }
                }
                ++n6;
            }
        }
        if (bl) {
            this.cachedRowMin = nArray2;
        } else {
            this.cachedColMin = nArray2;
        }
        return nArray2;
    }

    private int[] computeConstraints(boolean bl) {
        int n = this.gridInfo.getNumRows(bl);
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Row row = this.getRow(n2, bl);
            nArray[n2] = !row.grows && !row.largerThanChildren ? row.size : -1;
            ++n2;
        }
        return nArray;
    }

    private int getResizeDenominator(boolean bl) {
        int n = 0;
        int n2 = this.gridInfo.getNumRows(bl);
        int n3 = 0;
        while (n3 < n2) {
            Row row = this.getRow(n3, bl);
            if (row.grows) {
                n += row.size;
            }
            ++n3;
        }
        return n;
    }

    protected int getSpan(int n, boolean bl) {
        CellData cellData = this.gridInfo.getCellData(n);
        if (bl) {
            return cellData.verticalSpan;
        }
        return cellData.horizontalSpan;
    }

    private Point totalEmptySpace() {
        int n = this.gridInfo.getRows();
        return new Point(2 * this.marginWidth + (this.gridInfo.getCols() - 1) * this.horizontalSpacing, 2 * this.marginHeight + (n - 1) * this.verticalSpacing);
    }

    private static int[] computeRowPositions(int n, int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = n;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray2[n3 + 1] = nArray2[n3] + nArray[n3] + n2;
            ++n3;
        }
        return nArray2;
    }

    protected void layout(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        this.initGrid(controlArray);
        if (bl) {
            this.cache.flush();
        }
        Point point = this.totalEmptySpace();
        int n = composite.getClientArea().width - point.x;
        int n2 = composite.getClientArea().height - point.y;
        int[] nArray = this.computeConstraints(true);
        int[] nArray2 = new int[this.gridInfo.getCols()];
        nArray2 = this.computeSizes(nArray, n, false);
        nArray = this.computeSizes(nArray2, n2, true);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int[] nArray3 = CellLayout.computeRowPositions(composite.getClientArea().y + this.marginHeight, nArray, this.verticalSpacing);
        int[] nArray4 = CellLayout.computeRowPositions(composite.getClientArea().x + this.marginWidth, nArray2, this.horizontalSpacing);
        int n3 = this.gridInfo.controls.length;
        int n4 = 0;
        while (n4 < n3) {
            CellData cellData = this.gridInfo.getCellData(n4);
            int n5 = this.gridInfo.controlRow[n4];
            int n6 = this.gridInfo.controlCol[n4];
            rectangle.x = nArray4[n6];
            rectangle.width = nArray4[n6 + cellData.horizontalSpan] - rectangle.x - this.horizontalSpacing;
            rectangle.y = nArray3[n5];
            rectangle.height = nArray3[n5 + cellData.verticalSpan] - rectangle.y - this.verticalSpacing;
            cellData.positionControl(this.cache.getCache(n4), rectangle);
            ++n4;
        }
    }

    public int getColumns() {
        return this.numCols;
    }

    public boolean canGrow(Composite composite, boolean bl) {
        this.initGrid(composite.getChildren());
        int n = this.gridInfo.getNumRows(bl);
        int n2 = 0;
        while (n2 < n) {
            Row row = this.getRow(n2, bl);
            if (row.grows) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

