/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBaseEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarEditEntryDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CalendarDayViewScreen
implements KeyListener,
SelectionListener {
    private static final int column_first = 0;
    private static final int column_second = 1;
    private static final int hour_nb = 16;
    private static final int start_hour = 6;
    private static final int end_hour = 21;
    private static CalendarDayViewScreen singleton = null;
    private Vector entriesoftheday;
    private Vector entriesInTable;
    private Date displayedDate;
    private CalendarShowCase calendarShowCase;
    private CalendarDataBase calendardatabase;
    private Shell shell;
    private GregorianCalendar g;
    private Command commandEditEntry;
    private Command commandNewEntry;
    private Command commandGoToDate;
    private Command commandExit;
    private Command commandChangeView;
    private Table table;
    private Font fontColumn1;
    private Font fontColumn2;
    private boolean quit = false;

    public static CalendarDayViewScreen createUniqueInstance(CalendarShowCase calendarShowCase, CalendarDataBase calendarDataBase) {
        if (singleton == null) {
            singleton = new CalendarDayViewScreen(calendarShowCase, calendarDataBase);
        }
        return singleton;
    }

    private CalendarDayViewScreen(CalendarShowCase calendarShowCase, CalendarDataBase calendarDataBase) {
        this.calendarShowCase = calendarShowCase;
        this.calendardatabase = calendarDataBase;
        this.entriesInTable = new Vector();
        this.quit = false;
    }

    private void buildRessources() {
        this.shell = new Shell(this.calendarShowCase.getComposite().getShell(), 1056);
        Rectangle rectangle = this.calendarShowCase.getComposite().getShell().getBounds();
        this.shell.setBounds(rectangle);
        this.g = new GregorianCalendar();
    }

    public void activate(Date date) {
        this.displayedDate = new Date();
        this.displayedDate.setTime(date.getTime());
        this.entriesoftheday = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
        this.buildRessources();
        this.build();
    }

    public Date getDisplayedDate() {
        return (Date)this.displayedDate.clone();
    }

    private void build() {
        this.commandExit = new Command((Control)this.shell, 7, 0);
        this.commandExit.setText(Messages.getString("CalendarDayViewScreen.0"));
        this.commandExit.setLongLabel(Messages.getString("CalendarDayViewScreen.1"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.commandGoToDate = new Command((Control)this.shell, 1, 2);
        this.commandGoToDate.setText(Messages.getString("CalendarDayViewScreen.2"));
        this.commandGoToDate.addSelectionListener((SelectionListener)this);
        this.commandChangeView = new Command((Control)this.shell, 1, 3);
        this.commandChangeView.setText(Messages.getString("CalendarDayViewScreen.3"));
        this.commandChangeView.addSelectionListener((SelectionListener)this);
        this.buildTable();
        this.setInitialSelection();
        this.setEditCommands();
        this.shell.setText(this.HeaderfromDate());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
        this.shell.layout();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void setInitialSelection() {
        this.table.select(0);
    }

    private void buildTable() {
        if (this.table != null) {
            this.table.dispose();
        }
        this.table = new Table((Composite)this.shell, 2564);
        TableColumn tableColumn = new TableColumn(this.table, 2048);
        TableColumn tableColumn2 = new TableColumn(this.table, 2048);
        this.fontColumn1 = this.table.getFont();
        FontData[] fontDataArray = this.fontColumn1.getFontData();
        this.fontColumn2 = new Font((Device)this.shell.getDisplay(), fontDataArray[0]);
        fontDataArray[0].setStyle(fontDataArray[0].getStyle() | 2);
        this.fontColumn1 = new Font((Device)this.shell.getDisplay(), fontDataArray[0]);
        this.fillTable();
        tableColumn.pack();
        int n = tableColumn.getWidth();
        Rectangle rectangle = this.shell.getClientArea();
        tableColumn2.setWidth(rectangle.width - n);
        this.table.addKeyListener((KeyListener)this);
        this.table.addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        this.limitedDispose();
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    private void limitedDispose() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setVisible(false);
            this.table.removeAll();
            this.table.dispose();
        }
        if (this.fontColumn1 != null && !this.fontColumn1.isDisposed()) {
            this.fontColumn1.dispose();
        }
        if (this.fontColumn2 != null && !this.fontColumn2.isDisposed()) {
            this.fontColumn2.dispose();
        }
        if (this.commandEditEntry != null) {
            this.commandEditEntry = null;
        }
        if (this.commandNewEntry != null) {
            this.commandNewEntry = null;
        }
        if (this.commandGoToDate != null) {
            this.commandGoToDate = null;
        }
        if (this.commandExit != null) {
            this.commandExit = null;
        }
        if (this.commandChangeView != null) {
            this.commandChangeView = null;
        }
        this.g = null;
    }

    private void setEditCommands() {
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return;
        }
        if (this.entriesInTable.get(n) != null) {
            if (this.commandEditEntry == null) {
                if (this.commandNewEntry != null) {
                    this.commandNewEntry.removeSelectionListener((SelectionListener)this);
                    this.commandNewEntry.dispose();
                    this.commandNewEntry = null;
                }
                this.commandEditEntry = new Command((Control)this.shell, 1, 5);
                this.commandEditEntry.setText(Messages.getString("CalendarDayViewScreen.4"));
                this.commandEditEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.5"));
                this.commandEditEntry.addSelectionListener((SelectionListener)this);
                this.commandEditEntry.setDefaultCommand();
            }
        } else if (this.commandNewEntry == null) {
            if (this.commandEditEntry != null) {
                this.commandEditEntry.removeSelectionListener((SelectionListener)this);
                this.commandEditEntry.dispose();
                this.commandEditEntry = null;
            }
            this.commandNewEntry = new Command((Control)this.shell, 1, 5);
            this.commandNewEntry.setText(Messages.getString("CalendarDayViewScreen.6"));
            this.commandNewEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.7"));
            this.commandNewEntry.addSelectionListener((SelectionListener)this);
            this.commandNewEntry.setDefaultCommand();
        }
    }

    private void resetTable() {
        this.resetVectors();
        this.table.setVisible(false);
        this.table.removeAll();
        this.fillTable();
        this.table.setVisible(true);
    }

    private String HeaderfromDate() {
        this.g.setTime(this.displayedDate);
        String string = "";
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        string = String.valueOf(string) + dateFormat.format(this.displayedDate);
        return string;
    }

    private void fillTable() {
        int n = 0;
        int n2 = 0;
        this.entriesInTable.clear();
        int n3 = 6;
        while (n3 < 22) {
            TableItem tableItem;
            if (n >= this.entriesoftheday.size()) {
                this.fillRowsInTable(n3, n2);
                break;
            }
            this.g.setTime(((CalendarDataBaseEntry)this.entriesoftheday.get(n)).getStartDate());
            Integer n4 = new Integer(this.g.get(11));
            Integer n5 = new Integer(n3);
            if (n4 < 6) {
                n4 = new Integer(6);
            }
            if (n4 > 21) {
                n4 = new Integer(21);
            }
            if (n4 == n3) {
                tableItem = new TableItem(this.table, 16384, n2);
                tableItem.setText(0, this.hourToTableHour(n5).toString());
                tableItem.setText(1, ((CalendarDataBaseEntry)this.entriesoftheday.get(n)).toStringLarge());
                this.entriesInTable.add(this.entriesoftheday.get(n));
                ++n;
                ++n2;
                while (n < this.entriesoftheday.size()) {
                    this.g.setTime(((CalendarDataBaseEntry)this.entriesoftheday.get(n)).getStartDate());
                    n4 = new Integer(this.g.get(11));
                    if (n4 == n3) {
                        TableItem tableItem2 = new TableItem(this.table, 16384, n2);
                        tableItem2.setText(1, ((CalendarDataBaseEntry)this.entriesoftheday.get(n)).toStringLarge());
                        this.entriesInTable.add(this.entriesoftheday.get(n));
                        ++n;
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                tableItem = new TableItem(this.table, 16384, n2);
                tableItem.setText(0, this.hourToTableHour(n5).toString());
                this.entriesInTable.add(null);
                ++n2;
            }
            ++n3;
        }
        this.decorateTable();
    }

    private void fillRowsInTable(int n, int n2) {
        int n3 = n;
        while (n3 < 22) {
            TableItem tableItem = new TableItem(this.table, 16384, n2);
            Integer n4 = new Integer(n3);
            tableItem.setText(0, this.hourToTableHour(n4).toString());
            this.entriesInTable.add(null);
            ++n2;
            ++n3;
        }
    }

    private Integer hourToTableHour(Integer n) {
        if (n > 12) {
            return new Integer(n - 12);
        }
        return new Integer(n);
    }

    /*
     * Unable to fully structure code
     */
    private int tableHourtoHour(int var1_1) {
        var2_2 = this.table.getItem(this.table.getSelectionIndex());
        var3_3 = Integer.parseInt(var2_2.getText(0));
        if (var3_3 != 12) ** GOTO lbl8
        return 12;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.table.getItem(var1_1);
            if (Integer.parseInt(var2_2.getText(0)) != 12) continue;
            return var3_3 + 12;
lbl8:
            // 2 sources

            ** while (--var1_1 > 0)
        }
lbl9:
        // 1 sources

        return var3_3;
    }

    private Date CreateDate(int n) {
        this.g.setTime(this.displayedDate);
        this.g.set(11, n);
        this.g.set(12, 0);
        this.g.set(13, 0);
        Date date = this.g.getTime();
        return date;
    }

    private void decorateTable() {
        int n = 0;
        while (n < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(n);
            if (tableItem == null) break;
            tableItem.setFont(0, this.fontColumn1);
            tableItem.setFont(1, this.fontColumn2);
            tableItem.setBackground(0, this.shell.getDisplay().getSystemColor(18));
            ++n;
        }
    }

    private void createNewEntry() {
        int n = this.table.getSelectionIndex();
        this.table.getItem(n);
        int n2 = this.tableHourtoHour(n);
        Date date = this.CreateDate(n2);
        CalendarDataBaseEntry calendarDataBaseEntry = new CalendarDataBaseEntry(date, date, Messages.getString("CalendarDayViewScreen.9"), Messages.getString("CalendarDayViewScreen.10"), null);
        this.OpenEditDialogAndManageResult(calendarDataBaseEntry, n, true);
    }

    private void editEntry() {
        int n = this.table.getSelectionIndex();
        CalendarDataBaseEntry calendarDataBaseEntry = (CalendarDataBaseEntry)this.entriesInTable.get(n);
        this.OpenEditDialogAndManageResult(calendarDataBaseEntry, n, false);
    }

    private void OpenEditDialogAndManageResult(CalendarDataBaseEntry calendarDataBaseEntry, int n, boolean bl) {
        CalendarEditEntryDialog calendarEditEntryDialog = new CalendarEditEntryDialog(this.shell);
        boolean bl2 = calendarEditEntryDialog.open(calendarDataBaseEntry, bl);
        if (bl2) {
            if (bl) {
                this.calendardatabase.addEntry(calendarDataBaseEntry);
                this.resetTable();
            } else {
                CalendarDataBaseEntry calendarDataBaseEntry2 = (CalendarDataBaseEntry)calendarDataBaseEntry.clone();
                this.calendardatabase.removeEntry(calendarDataBaseEntry);
                this.calendardatabase.addEntry(calendarDataBaseEntry2);
                this.resetTable();
            }
        } else if (!bl) {
            this.calendardatabase.removeEntry(calendarDataBaseEntry);
            this.entriesInTable.set(n, null);
            this.resetTable();
            if (n == this.entriesInTable.size()) {
                --n;
            }
        }
        this.table.setSelection(n);
        this.table.showItem(this.table.getItem(n));
        this.setEditCommands();
    }

    private void updateView() {
        this.resetTable();
        this.shell.setText(this.HeaderfromDate());
        this.setInitialSelection();
    }

    private void resetVectors() {
        this.entriesoftheday.clear();
        this.entriesInTable.clear();
        this.entriesoftheday = this.calendardatabase.getEntriesOfTheDay(this.displayedDate);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget.equals(this.table)) {
            if (this.commandNewEntry != null) {
                this.createNewEntry();
            } else if (this.commandEditEntry != null) {
                this.editEntry();
            }
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        try {
            Date date;
            if (selectionEvent.widget.equals(this.commandChangeView)) {
                this.dispose();
            } else if (selectionEvent.widget.equals(this.commandExit)) {
                this.setQuit(true);
                this.dispose();
            } else if (selectionEvent.widget.equals(this.commandNewEntry)) {
                this.createNewEntry();
            } else if (selectionEvent.widget.equals(this.commandEditEntry)) {
                this.editEntry();
            } else if (selectionEvent.widget.equals(this.table)) {
                this.setEditCommands();
            } else if (selectionEvent.widget.equals(this.commandGoToDate) && (date = this.calendarShowCase.goToDate(this.shell)) != null) {
                this.displayedDate = date;
                this.updateView();
            }
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.g.setFirstDayOfWeek(1);
        this.g.setTime(this.displayedDate);
        if (keyEvent.keyCode == 0x1000004) {
            if (this.g.get(2) == 11 && this.g.get(5) == 31) {
                return;
            }
            this.g.add(6, 1);
            this.displayedDate = this.g.getTime();
            this.updateView();
        } else if (keyEvent.keyCode == 0x1000003) {
            if (this.g.get(2) == 0 && this.g.get(5) == 1) {
                return;
            }
            this.g.add(6, -1);
            this.displayedDate = this.g.getTime();
            this.updateView();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean quitWanted() {
        return this.quit;
    }

    private void setQuit(boolean bl) {
        this.quit = bl;
    }
}

