/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class ColorCellEditor
extends DialogCellEditor {
    private static final int DEFAULT_EXTENT = 16;
    private static final int GAP = 6;
    private Composite composite;
    private Label colorLabel;
    private Label rgbLabel;
    private Image image;

    public ColorCellEditor(Composite composite) {
        this(composite, 0);
    }

    public ColorCellEditor(Composite composite, int n) {
        super(composite, n);
        this.doSetValue(new RGB(0, 0, 0));
    }

    private ImageData createColorImage(Control control, RGB rGB) {
        GC gC = new GC((Drawable)control);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getAscent();
        gC.dispose();
        int n2 = 6;
        int n3 = 16;
        if (control instanceof Table) {
            n3 = ((Table)control).getItemHeight() - 1;
        } else if (control instanceof Tree) {
            n3 = ((Tree)control).getItemHeight() - 1;
        }
        if (n > n3) {
            n = n3;
        }
        int n4 = n2 + n;
        int n5 = n3;
        int n6 = n2;
        int n7 = (n5 - n) / 2;
        RGB rGB2 = new RGB(0, 0, 0);
        PaletteData paletteData = new PaletteData(new RGB[]{rGB2, rGB2, rGB});
        ImageData imageData = new ImageData(n4, n5, 4, paletteData);
        imageData.transparentPixel = 0;
        int n8 = n - 1;
        int n9 = 0;
        while (n9 < n) {
            int n10 = 0;
            while (n10 < n) {
                if (n10 == 0 || n9 == 0 || n10 == n8 || n9 == n8) {
                    imageData.setPixel(n10 + n6, n9 + n7, 1);
                } else {
                    imageData.setPixel(n10 + n6, n9 + n7, 2);
                }
                ++n10;
            }
            ++n9;
        }
        return imageData;
    }

    protected Control createContents(Composite composite) {
        Color color = composite.getBackground();
        this.composite = new Composite(composite, this.getStyle());
        this.composite.setBackground(color);
        this.composite.setLayout((Layout)new ColorCellLayout());
        this.colorLabel = new Label(this.composite, 16384);
        this.colorLabel.setBackground(color);
        this.rgbLabel = new Label(this.composite, 16384);
        this.rgbLabel.setBackground(color);
        this.rgbLabel.setFont(composite.getFont());
        return this.composite;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
    }

    protected Object openDialogBox(Control control) {
        ColorDialog colorDialog = new ColorDialog(control.getShell());
        Object object = this.getValue();
        if (object != null) {
            colorDialog.setRGB((RGB)object);
        }
        object = colorDialog.open();
        return colorDialog.getRGB();
    }

    protected void updateContents(Object object) {
        RGB rGB = (RGB)object;
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        if (this.image != null) {
            this.image.dispose();
        }
        ImageData imageData = this.createColorImage((Control)this.colorLabel.getParent().getParent(), rGB);
        this.image = new Image((Device)this.colorLabel.getDisplay(), imageData);
        this.colorLabel.setImage(this.image);
        this.rgbLabel.setText("(" + rGB.red + "," + rGB.green + "," + rGB.blue + ")");
    }

    private class ColorCellLayout
    extends Layout {
        private ColorCellLayout() {
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = ColorCellEditor.this.colorLabel.computeSize(-1, -1, bl);
            Point point2 = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, bl);
            return new Point(point.x + 6 + point2.x, Math.max(point.y, point2.y));
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Point point = ColorCellEditor.this.colorLabel.computeSize(-1, -1, bl);
            Point point2 = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, bl);
            int n = (rectangle.height - point2.y) / 2;
            if (n < 0) {
                n = 0;
            }
            ColorCellEditor.this.colorLabel.setBounds(-1, 0, point.x, point.y);
            ColorCellEditor.this.rgbLabel.setBounds(point.x + 6 - 1, n, rectangle.width - point.x - 6, rectangle.height);
        }
    }
}

