/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;

public class AddRemoteScreen
extends AbsScreen
implements ModifyListener {
    Button remoteButton;
    Button localButton;
    Text name;
    Text url;
    Vector bookmarks = new Vector();
    Composite screenPane;
    ScrollBar scrollBarV;
    Rectangle screenPaneBounds;

    public AddRemoteScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.screenPane = this.init(Messages.YouSelectedRemote, true);
        this.scrollBarV = this.screen.getVerticalBar();
        this.scrollBarV.addSelectionListener((SelectionListener)this);
        WrappedLabel wrappedLabel = new WrappedLabel(this.screenPane, 0, 0);
        wrappedLabel.setText(Messages.EnterName);
        this.name = new Text(this.screenPane, 2048);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener((ModifyListener)this);
        WrappedLabel wrappedLabel2 = new WrappedLabel(this.screenPane, 0, 0);
        wrappedLabel2.setText(Messages.EnterURL);
        this.url = new Text(this.screenPane, 2048);
        this.url.setSelection(7, 7);
        this.url.setLayoutData((Object)new GridData(768));
        this.fillSpace();
        this.separator();
        this.setButtons(1, 0, 4);
        this.screen.pack();
        this.screen.layout();
    }

    protected void refresh() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        BookmarkUtil.load(this.view.bookmarkFile, this.bookmarks);
        this.name.setText("");
        this.url.setText("http://");
    }

    protected void action() {
        this.name.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(5, false);
        } else if (selectionEvent.widget == this.nextButton) {
            BookmarkSite bookmarkSite = new BookmarkSite(this.name.getText(), this.url.getText(), false, true, false, "");
            this.bookmarks.add(bookmarkSite);
            BookmarkUtil.store(this.view.bookmarkFile, this.bookmarks);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (selectionEvent.widget == this.scrollBarV) {
            this.screenPane.setBounds(this.screenPaneBounds.x, this.screenPaneBounds.y - this.scrollBarV.getSelection(), this.screenPaneBounds.width, this.screenPaneBounds.height + this.scrollBarV.getSelection());
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.name.getText().length() == 0 || BookmarkUtil.searchByName(this.bookmarks, this.name.getText()) >= 0) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    public void controlResized(ControlEvent controlEvent) {
        if (!this.screen.isDisposed()) {
            this.screen.setBounds(this.view.parent.getClientArea());
        }
        if (this.buttonPane == null) {
            return;
        }
        this.screenPaneBounds = this.screenPane.getBounds();
        int n = this.buttonPane.getLocation().y + this.buttonPane.getSize().y;
        int n2 = this.screenPane.getSize().y;
        if (n > n2) {
            this.scrollBarV.setMaximum(n - n2);
            this.scrollBarV.setSelection(0);
            if (!this.scrollBarV.getVisible()) {
                this.scrollBarV.setVisible(true);
            }
        } else if (this.scrollBarV.getVisible()) {
            this.scrollBarV.setVisible(false);
        }
    }
}

