/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.util.FeatureWrap;

public class InstallingScreen
extends AbsScreen {
    public static final int PROGRESS_MAX_VALUE = 10;
    public Label featureName;
    public ProgressBar featureProgress;
    public ProgressBar overallProgress;
    private int totalInstallFeaturesCount = 0;
    private UpdateMonitor installFeatureMonitor;
    private InstallFeatureThread installFeaturesThread;
    private Composite pane;
    private StringBuffer installLog;
    private boolean isExisted = false;

    InstallingScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.wrap = false;
        this.pane.setLayout((Layout)rowLayout);
        new Label(this.pane, 0).setText(Messages.Installing);
        this.featureName = new Label(this.pane, 0);
        this.featureProgress = new ProgressBar(this.screen, 65536);
        this.featureProgress.setMaximum(10);
        Label label = new Label(this.screen, 0);
        label.setText(Messages.OverallProgress);
        this.overallProgress = new ProgressBar(this.screen, 65536);
        this.fillSpace();
        this.setButtons(0, 2, 0);
        this.screen.layout();
    }

    protected void refresh() {
        this.cancelButton.setEnabled(true);
        this.featureName.setText("");
        this.featureProgress.setSelection(0);
        this.overallProgress.setSelection(0);
        this.screen.layout();
    }

    protected void action() {
        this.cancelButton.setFocus();
        ISite iSite = null;
        try {
            iSite = SiteManager.getSite(new URL("file", null, Platform.getInstallLocation().getURL().getPath()), null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (iSite == null) {
            System.out.println("Error: error to get local site for installation.");
            return;
        }
        this.totalInstallFeaturesCount = 0;
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            if (((FeatureWrap)this.view.availableFeatures.elementAt(n)).isSelected()) {
                ++this.totalInstallFeaturesCount;
            }
            ++n;
        }
        this.overallProgress.setMaximum(this.totalInstallFeaturesCount);
        this.installFeatureMonitor = new UpdateMonitor();
        this.installLog = new StringBuffer();
        this.installFeaturesThread = new InstallFeatureThread("", iSite, this.view.availableFeatures, this.installLog, this.installFeatureMonitor);
        this.installFeaturesThread.start();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (InstallingScreen.this.installFeaturesThread.isFinished()) {
                    Object object;
                    if (InstallingScreen.this.isExisted) {
                        return;
                    }
                    InstallingScreen.this.isExisted = true;
                    if (InstallingScreen.this.installFeaturesThread.getDoneWorksCount() == InstallingScreen.this.totalInstallFeaturesCount) {
                        InstallingScreen.this.featureName.setText(NLS.bind((String)Messages.FeaturesInstalled, (Object[])new Object[]{new Integer(InstallingScreen.this.totalInstallFeaturesCount).toString()}));
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection(10);
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.totalInstallFeaturesCount);
                        InstallingScreen.this.view.enableRestartCommand = true;
                        object = new MessageBox(InstallingScreen.this.screen.getShell(), 194);
                        object.setText(Messages.ConfirmRestart);
                        object.setMessage(NLS.bind((String)Messages.RecommendToRestart, (Object[])InstallingScreen.this.view.RuntimeName));
                        if (object.open() == 64) {
                            System.getProperties().put("eworkbench.returnCode", new Integer(1));
                            PlatformUI.getWorkbench().close();
                        }
                    } else {
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                        AppPlugin.log(Messages.InstallNotCompleted, null);
                        AppPlugin.log(InstallingScreen.this.installLog.toString(), null);
                        object = new MessageBox(InstallingScreen.this.screen.getShell(), 33);
                        object.setText(Messages.InstallStatus);
                        object.setMessage(Messages.InstallNotCompleted);
                        object.open();
                    }
                    InstallingScreen.this.isExisted = false;
                    InstallingScreen.this.cancelButton.setEnabled(false);
                    InstallingScreen.this.installFeaturesThread = null;
                    object = new File(String.valueOf(Utils.getConfigurationLocation().getURL().getPath()) + "org.eclipse.update", "platform.xml");
                    boolean bl = ((File)object).delete();
                    if (AppPlugin.DEBUG) {
                        AppPlugin.log("[eUpdate] " + (bl ? "Success" : "Fail") + " to delete " + ((File)object).toString(), null);
                    }
                    InstallingScreen.this.setVisible(false);
                    NormalView normalView = InstallingScreen.this.view;
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                } else {
                    if (InstallingScreen.this.installFeaturesThread.isAlive()) {
                        InstallingScreen.this.featureName.setText(InstallingScreen.this.installFeaturesThread.getCurrentFeatureName());
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                    }
                    Display.getCurrent().timerExec(300, (Runnable)this);
                }
            }
        });
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.cancelButton && this.installFeaturesThread != null && !this.installFeaturesThread.isFinished()) {
            this.installFeatureMonitor.setCanceled(true);
        }
    }

    private class InstallFeatureThread
    extends Thread {
        private ISite site;
        private Vector features;
        private Vector beSuccessfullyInstalleds;
        private StringBuffer log;
        private IProgressMonitor monitor;
        private int count;
        private String currentFeatureName = "";
        private boolean isThreadFinished = false;

        public InstallFeatureThread(String string, ISite iSite, Vector vector, StringBuffer stringBuffer, IProgressMonitor iProgressMonitor) {
            super(string);
            this.site = iSite;
            this.features = vector;
            this.log = stringBuffer;
            this.monitor = iProgressMonitor;
            this.count = 0;
            this.beSuccessfullyInstalleds = new Vector();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = 0;
            try {
                try {
                    this.isThreadFinished = false;
                    var2_2 = null;
                    var1_1 = 0;
                    while (var1_1 < this.features.size()) {
                        block28: {
                            var2_2 = (FeatureWrap)this.features.elementAt(var1_1);
                            if (var2_2.isSelected()) {
                                try {
                                    if (!this.monitor.isCanceled()) {
                                        this.currentFeatureName = var2_2.getShowedName();
                                        this.site.install(var2_2.getFeature(), null, this.monitor);
                                        var2_2.releaseFeature();
                                        try {
                                            if (this.features.size() >= 10) {
                                                InstallFeatureThread.sleep(500L);
                                            } else {
                                                InstallFeatureThread.sleep(100L);
                                            }
                                        }
                                        catch (InterruptedException v0) {}
                                        ++this.count;
                                        this.beSuccessfullyInstalleds.add(var2_2.getVID());
                                        break block28;
                                    }
                                    this.isThreadFinished = true;
                                }
                                catch (CoreException var3_4) {
                                    if (!(var3_4 instanceof InstallAbortedException)) {
                                        this.log.append(var2_2.getShowedName()).append("\n");
                                        var3_4.printStackTrace();
                                        break block28;
                                    }
                                    this.isThreadFinished = true;
                                }
                                var4_5 = null;
                                if (this.beSuccessfullyInstalleds.size() > 0) {
                                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                                }
                                var6_8 = var1_1;
                                while (true) {
                                    if (var6_8 >= this.features.size()) break;
                                    var7_11 = (FeatureWrap)this.features.elementAt(var6_8);
                                    if (var7_11.isSelected()) {
                                        this.log.append(var7_11.getShowedName()).append("\n");
                                    }
                                    ++var6_8;
                                }
                                this.isThreadFinished = true;
                                return;
                            }
                        }
                        ++var1_1;
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var2_3) {
                    var2_3.printStackTrace();
                    ** GOTO lbl-1000
                }
            }
            catch (Throwable var5_14) {
                var4_6 = null;
                if (this.beSuccessfullyInstalleds.size() > 0) {
                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                }
                var6_9 = var1_1;
            }
            while (true) {
                if (var6_9 >= this.features.size()) {
                    this.isThreadFinished = true;
                    throw var5_14;
                }
                var7_12 = (FeatureWrap)this.features.elementAt(var6_9);
                if (var7_12.isSelected()) {
                    this.log.append(var7_12.getShowedName()).append("\n");
                }
                ++var6_9;
            }
lbl-1000:
            // 2 sources

            {
                var4_7 = null;
                if (this.beSuccessfullyInstalleds.size() > 0) {
                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                }
                var6_10 = var1_1;
            }
            while (true) {
                if (var6_10 >= this.features.size()) {
                    this.isThreadFinished = true;
                    return;
                }
                var7_13 = (FeatureWrap)this.features.elementAt(var6_10);
                if (var7_13.isSelected()) {
                    this.log.append(var7_13.getShowedName()).append("\n");
                }
                ++var6_10;
            }
        }

        private void removeOldVersion(Vector vector) {
            try {
                IConfiguredSite iConfiguredSite = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0];
                IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getFeatureReferences();
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation iUnconfigureAndUninstallFeatureOperation = null;
                int n = 0;
                while (n < vector.size()) {
                    VersionedIdentifier versionedIdentifier = (VersionedIdentifier)vector.elementAt(n);
                    try {
                        int n2 = 0;
                        while (n2 < iFeatureReferenceArray.length) {
                            if (iFeatureReferenceArray[n2] != null && versionedIdentifier.getIdentifier().equals(iFeatureReferenceArray[n2].getVersionedIdentifier().getIdentifier()) && versionedIdentifier.getVersion().isGreaterThan(iFeatureReferenceArray[n2].getVersionedIdentifier().getVersion())) {
                                iUnconfigureAndUninstallFeatureOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(iConfiguredSite, iFeatureReferenceArray[n2].getFeature(null));
                                iUnconfigureAndUninstallFeatureOperation.execute(null, null);
                                iFeatureReferenceArray[n2] = null;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    ++n;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return;
            }
        }

        public String getCurrentFeatureName() {
            return this.currentFeatureName;
        }

        public int getDoneWorksCount() {
            return this.count;
        }

        public boolean isFinished() {
            return this.isThreadFinished;
        }
    }
}

