/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.WrappedLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Messages;

public class ManageScreen
extends AbsScreen {
    private SortedList featureList;
    private WrappedLabel description;
    private Command propCommand;
    private Command updateCommand;
    private Command uninsCommand;
    private Command restartCommand;
    private Vector allImportedPlugins = new Vector();
    private boolean isRequiredFeature;
    private IFeatureReference[] frs;
    private IFeature beingSelected;

    public ManageScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(Messages.AppsFeatures);
        this.featureList = new SortedList(this.screen, 768);
        this.featureList.setLayoutData((Object)new GridData(1808));
        this.featureList.addSelectionListener((SelectionListener)this);
        this.separator();
        this.description = new WrappedLabel(this.screen, 0, 0, 3);
        this.description.setLayoutData(new GridData(768));
        this.setButtons(1, 0, 0);
        this.propCommand = new Command((Control)this.screen, 1, 10);
        this.propCommand.setText(Messages.Properties);
        this.propCommand.setLongLabel(Messages.ShowProperties);
        this.propCommand.addSelectionListener((SelectionListener)this);
        this.updateCommand = new Command((Control)this.screen, 1, 9);
        this.updateCommand.setText(Messages.Update);
        this.updateCommand.setLongLabel(Messages.UpdateFeature);
        this.updateCommand.addSelectionListener((SelectionListener)this);
        this.uninsCommand = new Command((Control)this.screen, 1, 8);
        this.uninsCommand.setText(Messages.Uninstall);
        this.uninsCommand.setLongLabel(Messages.UninstallFeature);
        this.uninsCommand.addSelectionListener((SelectionListener)this);
        this.restartCommand = new Command((Control)this.screen, 1, 7);
        this.restartCommand.setText(NLS.bind((String)Messages.RestartWED, (Object[])this.view.RuntimeName));
        this.restartCommand.addSelectionListener((SelectionListener)this);
        this.screen.layout();
    }

    protected void refresh() {
        this.featureList.removeAll();
        this.propCommand.setEnabled(false);
        this.updateCommand.setEnabled(false);
        this.uninsCommand.setEnabled(false);
        this.restartCommand.setEnabled(this.view.enableRestartCommand);
        this.description.setText("");
        try {
            this.frs = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0].getFeatureReferences();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return;
        }
        IFeature iFeature = null;
        int n = 0;
        while (n < this.frs.length) {
            try {
                VersionedIdentifier versionedIdentifier = this.frs[n].getVersionedIdentifier();
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.view.deletedFeatures.size()) {
                    if (versionedIdentifier.equals((VersionedIdentifier)this.view.deletedFeatures.elementAt(n2))) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.featureList.add(String.valueOf(this.frs[n].getName()) + " (" + versionedIdentifier.getVersion() + ")");
                    iFeature = this.frs[n].getFeature(null);
                    if (SiteManager.getLocalSite().getFeatureStatus(iFeature).getCode() != -1) {
                        IImport[] iImportArray = iFeature.getImports();
                        int n3 = 0;
                        while (n3 < iImportArray.length) {
                            String string = iImportArray[n3].getVersionedIdentifier().getIdentifier();
                            if (!this.allImportedPlugins.contains(string)) {
                                this.allImportedPlugins.add(string);
                            }
                            ++n3;
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n;
        }
    }

    protected void action() {
        this.featureList.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            String[] stringArray = this.featureList.getSelection();
            this.propCommand.setEnabled(stringArray.length == 1);
            this.updateCommand.setEnabled(stringArray.length == 1);
            this.uninsCommand.setEnabled(stringArray.length == 1);
            this.isRequiredFeature = false;
            if (stringArray.length == 1) {
                IURLEntry iURLEntry;
                VersionedIdentifier versionedIdentifier;
                block37: {
                    versionedIdentifier = null;
                    int n = 0;
                    while (n < this.frs.length) {
                        String string;
                        try {
                            versionedIdentifier = this.frs[n].getVersionedIdentifier();
                            string = " (" + versionedIdentifier.getVersion().toString() + ")";
                        }
                        catch (Exception exception) {
                            string = " (?.?.?)";
                        }
                        if (stringArray[0].equals(String.valueOf(this.frs[n].getName()) + string)) {
                            try {
                                this.beingSelected = this.frs[n].getFeature(null);
                            }
                            catch (CoreException coreException) {
                                coreException.printStackTrace();
                            }
                            break;
                        }
                        ++n;
                    }
                    if (this.beingSelected == null) {
                        this.propCommand.setEnabled(false);
                        this.updateCommand.setEnabled(false);
                        this.uninsCommand.setEnabled(false);
                        return;
                    }
                    try {
                        if (SiteManager.getLocalSite().getFeatureStatus(this.beingSelected).getCode() == -1) break block37;
                        IPluginEntry[] iPluginEntryArray = this.beingSelected.getPluginEntries();
                        int n2 = 0;
                        while (n2 < iPluginEntryArray.length) {
                            int n3 = 0;
                            while (n3 < this.allImportedPlugins.size()) {
                                if (((String)this.allImportedPlugins.elementAt(n3)).equals(iPluginEntryArray[n2].getVersionedIdentifier().getIdentifier())) {
                                    this.isRequiredFeature = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!this.isRequiredFeature) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
                if (versionedIdentifier != null) {
                    if (versionedIdentifier.getIdentifier().startsWith("com.ibm.pvc.wece.device.")) {
                        this.uninsCommand.setEnabled(false);
                    } else if (versionedIdentifier.getIdentifier().startsWith("com.ibm.pvc.wed.core.")) {
                        this.uninsCommand.setEnabled(false);
                    }
                }
                try {
                    if (SiteManager.getLocalSite().getFeatureStatus(this.beingSelected).getCode() == -1) {
                        this.updateCommand.setEnabled(false);
                        this.uninsCommand.setEnabled(true);
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                if ((iURLEntry = this.beingSelected.getDescription()) != null) {
                    this.description.setText(iURLEntry.getAnnotation());
                } else {
                    this.description.setText("");
                }
                this.screen.layout();
            }
        } else if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        } else if (selectionEvent.widget == this.propCommand) {
            this.view.availableFeatures.removeAllElements();
            this.view.availableFeatures.add(this.beingSelected);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(11, true);
        } else if (selectionEvent.widget == this.updateCommand) {
            this.view.availableFeatures.removeAllElements();
            this.view.availableFeatures.add(this.beingSelected);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(9, true);
        } else if (selectionEvent.widget == this.uninsCommand) {
            if (this.isRequiredFeature) {
                MessageBox messageBox = new MessageBox(this.screen.getShell(), 34);
                messageBox.setText(Messages.Notice);
                messageBox.setMessage(Messages.FeatureIsRequired);
                messageBox.open();
                return;
            }
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(Messages.ConfirmUninstall);
            messageBox.setMessage(Messages.UninstallQuery);
            if (messageBox.open() == 64) {
                this.view.availableFeatures.removeAllElements();
                this.view.availableFeatures.add(this.beingSelected);
                this.setVisible(false);
                ((Object)((Object)this.view)).getClass();
                ((Object)((Object)this.view)).getClass();
                this.view.showScreen(12, true);
            }
        } else if (selectionEvent.widget == this.restartCommand) {
            MessageBox messageBox = new MessageBox(this.screen.getShell(), 194);
            messageBox.setText(Messages.ConfirmExit);
            messageBox.setMessage(NLS.bind((String)Messages.ExitWEDQuery, (Object[])this.view.RuntimeName));
            if (messageBox.open() == 64) {
                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                PlatformUI.getWorkbench().close();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.featureList) {
            this.widgetSelected(selectionEvent);
            if ("win32".equals(Platform.getOS()) && "x86".equals(Platform.getOSArch())) {
                this.view.availableFeatures.removeAllElements();
                this.view.availableFeatures.add(this.beingSelected);
                this.setVisible(false);
                ((Object)((Object)this.view)).getClass();
                ((Object)((Object)this.view)).getClass();
                this.view.showScreen(11, true);
            }
        }
    }
}

