/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.URLKey;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Site
extends SiteModel
implements ISiteWithMirrors {
    public static final String DEFAULT_INSTALLED_FEATURE_PATH = "features/";
    public static final String DEFAULT_PLUGIN_PATH = "plugins/";
    public static final String DEFAULT_FEATURE_PATH = "features/";
    public static final String SITE_FILE = "site";
    public static final String SITE_XML = "site.xml";
    private ISiteContentProvider siteContentProvider;
    private Map featureCache = new HashMap();

    public boolean equals(Object object) {
        if (!(object instanceof ISite)) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        ISite iSite = (ISite)object;
        return UpdateManagerUtils.sameURL(this.getURL(), iSite.getURL());
    }

    public URL getURL() {
        URL uRL = null;
        try {
            uRL = this.getSiteContentProvider().getURL();
        }
        catch (CoreException coreException) {
            AppPlugin.warn(null, coreException);
        }
        return uRL;
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public ICategory[] getCategories() {
        CategoryModel[] categoryModelArray = this.getCategoryModels();
        if (categoryModelArray.length == 0) {
            return new ICategory[0];
        }
        return (ICategory[])categoryModelArray;
    }

    public ICategory getCategory(String string) {
        ICategory iCategory = null;
        boolean bl = false;
        int n = this.getCategoryModels().length;
        int n2 = 0;
        while (n2 < n) {
            if (this.getCategoryModels()[n2].getName().equals(string)) {
                iCategory = (ICategory)((Object)this.getCategoryModels()[n2]);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            String string2 = this.getURL() != null ? this.getURL().toExternalForm() : "<no site url>";
            AppPlugin.warn(NLS.bind((String)Messages.Site_CannotFindCategory, (Object[])new String[]{string, string2}));
            if (this.getCategoryModels().length <= 0) {
                AppPlugin.warn(Messages.Site_NoCategories);
            }
        }
        return iCategory;
    }

    public ISiteFeatureReference[] getRawFeatureReferences() {
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getFeatureReferenceModels();
        if (siteFeatureReferenceModelArray.length == 0) {
            return new ISiteFeatureReference[0];
        }
        return (ISiteFeatureReference[])siteFeatureReferenceModelArray;
    }

    public ISiteFeatureReference[] getFeatureReferences() {
        if (this.getCurrentConfiguredSite() != null) {
            return this.filterFeatures(this.getRawFeatureReferences());
        }
        return this.getRawFeatureReferences();
    }

    private ISiteFeatureReference[] filterFeatures(ISiteFeatureReference[] iSiteFeatureReferenceArray) {
        ArrayList<ISiteFeatureReference> arrayList = new ArrayList<ISiteFeatureReference>();
        if (iSiteFeatureReferenceArray != null) {
            int n = 0;
            while (n < iSiteFeatureReferenceArray.length) {
                ISiteFeatureReference iSiteFeatureReference = iSiteFeatureReferenceArray[n];
                if (UpdateManagerUtils.isValidEnvironment(iSiteFeatureReference)) {
                    arrayList.add(iSiteFeatureReference);
                } else if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_WARNINGS) {
                    AppPlugin.warn("Filtered out feature reference:" + iSiteFeatureReference);
                }
                ++n;
            }
        }
        ISiteFeatureReference[] iSiteFeatureReferenceArray2 = new ISiteFeatureReference[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(iSiteFeatureReferenceArray2);
        }
        return iSiteFeatureReferenceArray2;
    }

    public ISiteFeatureReference getFeatureReference(IFeature iFeature) {
        if (iFeature == null) {
            AppPlugin.warn("Site:getFeatureReference: The feature is null");
            return null;
        }
        ISiteFeatureReference[] iSiteFeatureReferenceArray = this.getFeatureReferences();
        ISiteFeatureReference iSiteFeatureReference = null;
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            iSiteFeatureReference = iSiteFeatureReferenceArray[n];
            if (UpdateManagerUtils.sameURL(iFeature.getURL(), iSiteFeatureReference.getURL())) {
                return iSiteFeatureReference;
            }
            ++n;
        }
        AppPlugin.warn("Feature " + iFeature + " not found on site" + this.getURL());
        return null;
    }

    public IArchiveReference[] getArchives() {
        ArchiveReferenceModel[] archiveReferenceModelArray = this.getArchiveReferenceModels();
        if (archiveReferenceModelArray.length == 0) {
            return new IArchiveReference[0];
        }
        return (IArchiveReference[])archiveReferenceModelArray;
    }

    public ISiteContentProvider getSiteContentProvider() throws CoreException {
        if (this.siteContentProvider == null) {
            throw Utilities.newCoreException(Messages.Site_NoContentProvider, null);
        }
        return this.siteContentProvider;
    }

    public String getDefaultPackagedFeatureType() {
        return "org.eclipse.ercp.update.packaged";
    }

    public IPluginEntry[] getPluginEntries() {
        throw new UnsupportedOperationException();
    }

    public int getPluginEntryCount() {
        throw new UnsupportedOperationException();
    }

    public IPluginEntry[] getPluginEntriesOnlyReferencedBy(IFeature iFeature) throws CoreException {
        IPluginEntry[] iPluginEntryArray = new IPluginEntry[]{};
        if (iFeature == null) {
            return iPluginEntryArray;
        }
        IPluginEntry[] iPluginEntryArray2 = iFeature.getPluginEntries();
        if (iPluginEntryArray2 != null) {
            HashSet<VersionedIdentifier> hashSet = new HashSet<VersionedIdentifier>();
            ISiteFeatureReference[] iSiteFeatureReferenceArray = this.getFeatureReferences();
            if (iSiteFeatureReferenceArray != null) {
                int n = 0;
                while (n < iSiteFeatureReferenceArray.length) {
                    IPluginEntry[] iPluginEntryArray3;
                    IFeature iFeature2 = null;
                    try {
                        iFeature2 = iSiteFeatureReferenceArray[n].getFeature(null);
                    }
                    catch (CoreException coreException) {
                        AppPlugin.warn(null, coreException);
                    }
                    if (!iFeature.equals(iFeature2) && (iPluginEntryArray3 = iSiteFeatureReferenceArray[n].getFeature(null).getPluginEntries()) != null) {
                        int n2 = 0;
                        while (n2 < iPluginEntryArray3.length) {
                            hashSet.add(iPluginEntryArray3[n2].getVersionedIdentifier());
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            ArrayList<IPluginEntry> arrayList = new ArrayList<IPluginEntry>();
            int n = 0;
            while (n < iPluginEntryArray2.length) {
                if (!hashSet.contains(iPluginEntryArray2[n].getVersionedIdentifier())) {
                    arrayList.add(iPluginEntryArray2[n]);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                iPluginEntryArray = new IPluginEntry[arrayList.size()];
                arrayList.toArray(iPluginEntryArray);
            }
        }
        return iPluginEntryArray;
    }

    public void addPluginEntry(IPluginEntry iPluginEntry) {
        throw new UnsupportedOperationException();
    }

    public long getDownloadSizeFor(IFeature iFeature) {
        throw new UnsupportedOperationException();
    }

    public long getInstallSizeFor(IFeature iFeature) {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature iFeature, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IFeatureContentConsumer iFeatureContentConsumer, IVerifier iVerifier, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void remove(IFeature iFeature, IProgressMonitor iProgressMonitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSiteContentProvider(ISiteContentProvider iSiteContentProvider) {
        this.siteContentProvider = iSiteContentProvider;
    }

    public IConfiguredSite getCurrentConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public IFeature createFeature(String string, URL uRL) throws CoreException {
        return this.createFeature(string, uRL, null);
    }

    public IFeature createFeature(String string, URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        IFeatureFactory iFeatureFactory;
        URLKey uRLKey = new URLKey(uRL);
        IFeature iFeature = (IFeature)this.featureCache.get(uRLKey);
        if (iFeature != null) {
            return iFeature;
        }
        if (string == null || string.equals("")) {
            string = this.getDefaultPackagedFeatureType();
        }
        if ((iFeature = (iFeatureFactory = FeatureTypeFactory.getInstance().getFactory(string)).createFeature(uRL, this, iProgressMonitor)) != null) {
            this.featureCache.put(uRLKey, iFeature);
        }
        return iFeature;
    }

    protected void removeFeatureFromCache(URL uRL) {
        URLKey uRLKey = new URLKey(uRL);
        this.featureCache.remove(uRLKey);
    }

    public IURLEntry[] getMirrorSiteEntries() {
        URLEntryModel[] uRLEntryModelArray = this.getMirrorSiteEntryModels();
        if (uRLEntryModelArray.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])uRLEntryModelArray;
    }
}

