/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.security.CertificatePair;

public class JarVerificationResult
implements IVerificationResult {
    private int resultCode;
    private int verificationCode;
    private Exception resultException;
    private List certificates;
    private CertificatePair[] rootCertificates;
    private CertificatePair foundCertificate;
    private String signerInfo;
    private String verifierInfo;
    private ContentReference contentReference;
    private IFeature feature;
    private boolean featureVerification;
    private boolean alreadySeen;

    public int getResultCode() {
        return this.resultCode;
    }

    public Exception getVerificationException() {
        return this.resultException;
    }

    public void setResultCode(int n) {
        this.resultCode = n;
    }

    public void setResultException(Exception exception) {
        this.resultException = exception;
    }

    public int getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(int n) {
        this.verificationCode = n;
    }

    public void addCertificates(Certificate[] certificateArray) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(certificateArray);
        this.rootCertificates = null;
    }

    public CertificatePair[] getRootCertificates() {
        if (this.rootCertificates == null) {
            this.rootCertificates = new CertificatePair[0];
            ArrayList<CertificatePair> arrayList = new ArrayList<CertificatePair>();
            if (this.certificates != null && this.certificates.size() > 0) {
                Iterator iterator = this.certificates.iterator();
                while (iterator.hasNext()) {
                    Certificate[] certificateArray = (Certificate[])iterator.next();
                    if (certificateArray == null || certificateArray.length <= 0) continue;
                    CertificatePair certificatePair = new CertificatePair();
                    certificatePair.setIssuer(certificateArray[0]);
                    int n = 0;
                    while (n < certificateArray.length - 1) {
                        X509Certificate x509Certificate = (X509Certificate)certificateArray[n];
                        X509Certificate x509Certificate2 = (X509Certificate)certificateArray[n + 1];
                        if (!x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
                            certificatePair.setRoot(x509Certificate);
                            if (!arrayList.contains(certificatePair)) {
                                arrayList.add(certificatePair);
                            }
                            certificatePair = new CertificatePair();
                            certificatePair.setIssuer(x509Certificate2);
                        }
                        ++n;
                    }
                    if (certificatePair == null) continue;
                    certificatePair.setRoot(certificateArray[certificateArray.length - 1]);
                    if (arrayList.contains(certificatePair)) continue;
                    arrayList.add(certificatePair);
                }
            }
            if (arrayList.size() > 0) {
                this.rootCertificates = new CertificatePair[arrayList.size()];
                arrayList.toArray(this.rootCertificates);
            }
        }
        return this.rootCertificates;
    }

    private CertificatePair getFoundCertificate() {
        return this.foundCertificate;
    }

    public void setFoundCertificate(CertificatePair certificatePair) {
        this.foundCertificate = certificatePair;
    }

    private void initializeCertificates() {
        CertificatePair certificatePair;
        Object object;
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        if (this.getFoundCertificate() == null) {
            object = this.getRootCertificates();
            if (((CertificatePair[])object).length == 0) {
                return;
            }
            certificatePair = object[0];
        } else {
            certificatePair = this.getFoundCertificate();
        }
        x509Certificate = (X509Certificate)certificatePair.getRoot();
        x509Certificate2 = (X509Certificate)certificatePair.getIssuer();
        object = new StringBuffer();
        ((StringBuffer)object).append(this.issuerString(x509Certificate2.getSubjectDN()));
        ((StringBuffer)object).append("\r\n");
        ((StringBuffer)object).append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(x509Certificate2.getNotBefore()), this.dateString(x509Certificate2.getNotAfter())}));
        ((StringBuffer)object).append(this.checkValidity(x509Certificate2));
        this.signerInfo = ((StringBuffer)object).toString();
        if (x509Certificate2 != null && !x509Certificate2.equals(x509Certificate)) {
            object = new StringBuffer();
            ((StringBuffer)object).append(this.issuerString(x509Certificate2.getIssuerDN()));
            ((StringBuffer)object).append("\r\n");
            ((StringBuffer)object).append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(x509Certificate.getNotBefore()), this.dateString(x509Certificate.getNotAfter())}));
            ((StringBuffer)object).append(this.checkValidity(x509Certificate));
            this.verifierInfo = ((StringBuffer)object).toString();
        }
    }

    private String checkValidity(X509Certificate x509Certificate) {
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return "\r\n" + Messages.JarVerificationResult_ExpiredCertificate;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return "\r\n" + Messages.JarVerificationResult_CertificateNotYetValid;
        }
        return "\r\n" + Messages.JarVerificationResult_CertificateValid;
    }

    private String issuerString(Principal principal) {
        return principal.toString();
    }

    private String dateString(Date date) {
        return DateFormat.getDateInstance().format(date);
    }

    public String getSignerInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.signerInfo;
    }

    public String getVerifierInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.verifierInfo;
    }

    public ContentReference getContentReference() {
        return this.contentReference;
    }

    public void setContentReference(ContentReference contentReference) {
        this.contentReference = contentReference;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature iFeature) {
        this.feature = iFeature;
    }

    public String getText() {
        return null;
    }

    public boolean isFeatureVerification() {
        return this.featureVerification;
    }

    public void isFeatureVerification(boolean bl) {
        this.featureVerification = bl;
    }

    public boolean alreadySeen() {
        return this.alreadySeen;
    }

    public boolean alreadySeen(boolean bl) {
        this.alreadySeen = bl;
        return this.alreadySeen;
    }
}

