/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;

public class RemoveSiteCommand
extends ScriptedCommand {
    private IConfiguredSite csite;
    private File sitePath;

    public RemoveSiteCommand(String string) throws Exception {
        block8: {
            if (string != null) {
                this.sitePath = new File(string);
                if (!this.sitePath.getName().equals("eclipse")) {
                    this.sitePath = new File(this.sitePath, "eclipse");
                }
                if (!this.sitePath.exists()) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
                }
                IConfiguredSite[] iConfiguredSiteArray = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
                int n = 0;
                while (n < iConfiguredSiteArray.length) {
                    File file = new File(iConfiguredSiteArray[n].getSite().getURL().getFile());
                    if (file.equals(this.sitePath)) {
                        this.csite = iConfiguredSiteArray[n];
                        break;
                    }
                    ++n;
                }
                if (this.csite == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noConfiguredSite, (Object[])new String[]{string}));
                }
                break block8;
            }
            throw new Exception(Messages.Standalone_noSite3);
        }
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iStatus != null) {
            AppPlugin.log(iStatus);
            return false;
        }
        try {
            this.getConfiguration().removeConfiguredSite(this.csite);
            this.getConfiguration().getConfiguredSites();
            SiteManager.getLocalSite().save();
            return true;
        }
        catch (CoreException coreException) {
            AppPlugin.log(coreException);
            return false;
        }
    }
}

