/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.InternalGCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class GC {
    public int internal_handle;
    Drawable drawable;
    InternalGCData data;
    static final Color DefaultBackground = new Color(Device.getDevice(), 255, 255, 255);
    static final Color DefaultForeground = new Color(Device.getDevice(), 0, 0, 0);
    Font font;
    Color background;
    Color foreground;
    int lineStyle;
    int lineWidth;
    Rectangle clipping;
    boolean xorMode = false;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0x2000000);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        InternalGCData data = new InternalGCData();
        data.style = GC.checkStyle(style);
        this.internal_handle = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public void copyArea(Image destImage, int x, int y) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (destImage == null) {
            SWT.error(4);
        }
        if (destImage.type != 0) {
            SWT.error(5);
        }
        Rectangle destBounds = destImage.getBounds();
        Rectangle srcBounds = this.drawableInternal_getBounds();
        if (destBounds.height > srcBounds.height - y) {
            destBounds.height = srcBounds.height - y;
        }
        if (destBounds.width > srcBounds.width - x) {
            destBounds.width = srcBounds.width - x;
        }
        this.drawableInternal_copyArea(destImage.internal_handle, x, y, destBounds.width, destBounds.height);
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_CopyArea(this.internal_handle, x, y, width, height, destX, destY);
    }

    ImageData copyData(ImageData source, int x, int y, int w, int h) {
        if (x < 0 || y < 0 || w < 1 || h < 1) {
            SWT.error(5);
        }
        if (x + w > source.width) {
            SWT.error(6);
        }
        if (y + h > source.height) {
            SWT.error(6);
        }
        if (x == 0 && y == 0 && w == source.width && h == source.height) {
            return (ImageData)source.clone();
        }
        ImageData dest = new ImageData(w, h, source.depth, source.palette, source.scanlinePad, null, 0, null, null, -1, source.transparentPixel, source.type, x, y, source.disposalMethod, source.delayTime);
        if (source.palette.isDirect) {
            ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), x, y, w, h, 0, 0, 0, 255, null, 0, 0, 0, dest.data, dest.depth, dest.bytesPerLine, dest.getByteOrder(), 0, 0, w, h, 0, 0, 0, false, false);
        } else {
            ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), x, y, w, h, null, null, null, 255, null, 0, 0, 0, dest.data, dest.depth, dest.bytesPerLine, dest.getByteOrder(), 0, 0, w, h, null, null, null, false, false);
        }
        if (source.maskData != null) {
            dest.maskPad = source.maskPad;
            int destBpl = (dest.width + 7) / 8;
            destBpl = (destBpl + (dest.maskPad - 1)) / dest.maskPad * dest.maskPad;
            dest.maskData = new byte[destBpl * dest.height];
            int srcBpl = (w + 7) / 8;
            srcBpl = (srcBpl + (source.maskPad - 1)) / source.maskPad * source.maskPad;
            ImageData.blit(1, source.maskData, 1, srcBpl, 1, x, y, w, h, null, null, null, 255, null, 0, 0, 0, dest.maskData, 1, destBpl, 1, 0, 0, w, h, null, null, null, false, false);
        } else if (source.alpha != -1) {
            dest.alpha = source.alpha;
        } else if (source.alphaData != null) {
            dest.alphaData = new byte[dest.width * dest.height];
            ImageData.blit(1, source.alphaData, 8, w, 1, x, y, w, h, null, null, null, 255, null, 0, 0, 0, dest.alphaData, 8, dest.width, 1, 0, 0, dest.width, dest.height, null, null, null, false, false);
        }
        return dest;
    }

    public void dispose() {
        if (this.internal_handle == 0) {
            return;
        }
        Device device = this.data.device;
        if (device.isDisposed()) {
            return;
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.internal_handle, this.data);
        }
        OS.Graphics_Dispose(this.internal_handle);
        this.drawable = null;
        this.internal_handle = 0;
        Image image = this.data.image;
        if (image != null) {
            image.memGC = null;
        }
        this.data.image = null;
        this.data.font = null;
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawArc(this.internal_handle, x, y, width + 1, height + 1, startAngle, arcAngle);
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawFocus(this.internal_handle, x, y, width, height);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        OS.Graphics_DrawImage(this.internal_handle, image.internal_handle, x, y);
    }

    void drawableInternal_copyArea(int imageHandle, int x, int y, int width, int height) {
        this.drawable.internal_copyArea(imageHandle, x, y, width, height);
    }

    Rectangle drawableInternal_getBounds() {
        return this.drawable.internal_getBounds();
    }

    int drawableInternal_getDepth() {
        if (this.drawable instanceof Control) {
            return ((Display)this.data.device).internal_getDepth();
        }
        if (this.drawable instanceof Display) {
            return ((Display)this.drawable).internal_getDepth();
        }
        if (this.drawable instanceof Image) {
            return ((Image)this.drawable).internal_getDepth();
        }
        return 0;
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        int[] bounds = OS.Image_GetBounds(image.internal_handle);
        int imgWidth = bounds[2];
        int imgHeight = bounds[3];
        if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
            SWT.error(5);
        }
        OS.Graphics_DrawImageRegion(this.internal_handle, image.internal_handle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawLine(this.internal_handle, x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawOval(this.internal_handle, x, y, width + 1, height + 1);
    }

    public void drawPoint(int x, int y) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawLine(this.internal_handle, x, y, x + 1, y);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.Graphics_DrawPolygon(this.internal_handle, pointArray, pointArray.length);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.Graphics_DrawPolyline(this.internal_handle, pointArray, pointArray.length);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_DrawRectangle(this.internal_handle, x, y, width + 1, height + 1);
    }

    public void drawRectangle(Rectangle rect) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        OS.Graphics_DrawRoundRectangle(this.internal_handle, x, y, width + 1, height + 1, arcWidth, arcHeight);
    }

    public void drawString(String string, int x, int y) {
        int drawFlags = 0;
        this.drawText(string, x, y, drawFlags);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int drawFlags = isTransparent ? 1 : 0;
        this.drawText(string, x, y, drawFlags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int nativeFlags = 0;
        if ((flags & 2) != 0) {
            nativeFlags |= 1;
        }
        if ((flags & 8) != 0) {
            nativeFlags |= 4;
        }
        if ((flags & 4) != 0) {
            nativeFlags |= 2;
        }
        if ((flags & 1) != 0) {
            nativeFlags |= 8;
        }
        OS.Graphics_DrawString(this.internal_handle, string, x, y, nativeFlags);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.internal_handle == ((GC)object).internal_handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_FillArc(this.internal_handle, x, y, width + 1, height + 1, startAngle, arcAngle);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int redBits;
        int greenBits;
        int blueBits;
        int depth;
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB fromRGB = this.getForeground().getRGB();
        RGB toRGB = this.getBackground().getRGB();
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width *= -1;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height *= -1;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            RGB tempRGB = toRGB;
            toRGB = fromRGB;
            fromRGB = tempRGB;
        }
        if ((depth = this.drawableInternal_getDepth()) >= 24) {
            blueBits = 8;
            greenBits = 8;
            redBits = 8;
        } else if (depth >= 16) {
            redBits = 5;
            greenBits = 6;
            blueBits = 5;
        } else if (depth == 15) {
            blueBits = 5;
            greenBits = 5;
            redBits = 5;
        } else {
            blueBits = 0;
            greenBits = 0;
            redBits = 0;
        }
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, redBits, greenBits, blueBits);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_FillOval(this.internal_handle, x, y, width, height);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.Graphics_FillPolygon(this.internal_handle, pointArray, pointArray.length);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_FillRectangle(this.internal_handle, x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        OS.Graphics_FillRoundRectangle(this.internal_handle, x, y, width, height, arcWidth / 2, arcHeight / 2);
    }

    public int getAdvanceWidth(char ch) {
        return OS.Font_GetAdvanceWidth(this.font.internal_handle, ch);
    }

    public int getAlpha() {
        return 255;
    }

    public Color getBackground() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.background;
    }

    public int getCharWidth(char ch) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.textExtent((String)String.valueOf((char)ch), (int)0).x;
    }

    public Rectangle getClipping() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (this.clipping != null) {
            return this.clipping;
        }
        return this.drawable.internal_getDefaultClipping();
    }

    public Font getFont() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return new FontMetrics(this.getFont().internal_handle);
    }

    public Color getForeground() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.foreground;
    }

    public int getLineStyle() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.lineStyle;
    }

    public int getLineWidth() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.lineWidth;
    }

    public int getStyle() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return this.xorMode;
    }

    public int hashCode() {
        return this.internal_handle;
    }

    void init(Drawable drawable, InternalGCData data) {
        this.drawable = drawable;
        this.data = data;
        if (data.background == null) {
            data.background = DefaultBackground;
        }
        if (data.foreground == null) {
            data.foreground = DefaultForeground;
        }
        if (data.font == null) {
            data.font = data.device.getSystemFont();
        }
        this.setBackground(data.background);
        this.setForeground(data.foreground);
        this.setFont(data.font);
        this.setLineStyle(1);
        this.setLineWidth(1);
        Image image = data.image;
        if (image != null) {
            image.memGC = this;
        }
    }

    public boolean isClipped() {
        return this.clipping != null;
    }

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    public void setAlpha(int alpha) {
    }

    public void setBackground(Color color) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.Graphics_SetBackground(this.internal_handle, color.internal_handle);
        this.background = color;
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_SetClipping(this.internal_handle, x, y, width, height);
        this.clipping = new Rectangle(x, y, width, height);
    }

    public void setClipping(Rectangle rect) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            OS.Graphics_ClearClipping(this.internal_handle);
            this.clipping = null;
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setFont(Font font) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            font = this.data.device.getSystemFont();
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        OS.Graphics_SetFont(this.internal_handle, font.internal_handle);
        this.font = font;
    }

    public void setForeground(Color color) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        OS.Graphics_SetForeground(this.internal_handle, color.internal_handle);
        this.foreground = color;
    }

    /*
     * WARNING - void declaration
     */
    public void setLineStyle(int style) {
        void var2_2;
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        switch (style) {
            case 1: {
                int uglLineStyle = 1;
                break;
            }
            case 2: {
                int uglLineStyle = 2;
                break;
            }
            case 3: {
                int uglLineStyle = 4;
                break;
            }
            case 4: {
                int uglLineStyle = 8;
                break;
            }
            case 5: {
                int uglLineStyle = 16;
                break;
            }
            default: {
                SWT.error(5);
                return;
            }
        }
        this.lineStyle = style;
        OS.Graphics_SetLineStyle(this.internal_handle, (int)var2_2);
    }

    public void setLineWidth(int width) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_SetLineWidth(this.internal_handle, width);
        this.lineWidth = width;
    }

    public void setXORMode(boolean xor) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        OS.Graphics_SetXORMode(this.internal_handle, xor);
        this.xorMode = xor;
    }

    public Point stringExtent(String string) {
        int measureFlags = 0;
        return this.textExtent(string, measureFlags);
    }

    public Point textExtent(String string, int flags) {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() > 0) {
            int nativeFlags = 0;
            if ((flags & 2) != 0) {
                nativeFlags |= 1;
            }
            if ((flags & 8) != 0) {
                nativeFlags |= 4;
            }
            if ((flags & 4) != 0) {
                nativeFlags |= 2;
            }
            int[] extent = OS.Font_StringExtent(this.font.internal_handle, string, nativeFlags);
            return new Point(extent[0], extent[1]);
        }
        return new Point(0, this.getFontMetrics().getHeight());
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.internal_handle + "}";
    }
}

