/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public final class DefaultOperationHistory
implements IOperationHistory {
    public static boolean DEBUG_OPERATION_HISTORY_NOTIFICATION = false;
    public static boolean DEBUG_OPERATION_HISTORY_UNEXPECTED = false;
    public static boolean DEBUG_OPERATION_HISTORY_DISPOSE = false;
    public static boolean DEBUG_OPERATION_HISTORY_OPENOPERATION = false;
    public static boolean DEBUG_OPERATION_HISTORY_APPROVAL = false;
    static final int DEFAULT_LIMIT = 20;
    ListenerList approvers = new ListenerList(1);
    private Map limits = Collections.synchronizedMap(new HashMap());
    ListenerList listeners = new ListenerList(1);
    private List redoList = Collections.synchronizedList(new ArrayList());
    private List undoList = Collections.synchronizedList(new ArrayList());
    final Object undoRedoHistoryLock = new Object();
    private ICompositeOperation openComposite = null;
    final Object openCompositeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IUndoableOperation iUndoableOperation) {
        Assert.isNotNull((Object)iUndoableOperation);
        IUndoContext[] iUndoContextArray = this.openCompositeLock;
        synchronized (this.openCompositeLock) {
            if (this.openComposite != null && this.openComposite != iUndoableOperation) {
                this.openComposite.add(iUndoableOperation);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.checkUndoLimit(iUndoableOperation)) {
                iUndoContextArray = this.undoRedoHistoryLock;
                synchronized (iUndoContextArray) {
                    this.undoList.add(iUndoableOperation);
                }
                this.notifyAdd(iUndoableOperation);
                iUndoContextArray = iUndoableOperation.getContexts();
                int n = 0;
                while (n < iUndoContextArray.length) {
                    this.flushRedo(iUndoContextArray[n]);
                    ++n;
                }
            } else {
                iUndoableOperation.dispose();
            }
            return;
        }
    }

    public void addOperationApprover(IOperationApprover iOperationApprover) {
        this.approvers.add((Object)iOperationApprover);
    }

    public void addOperationHistoryListener(IOperationHistoryListener iOperationHistoryListener) {
        this.listeners.add((Object)iOperationHistoryListener);
    }

    public boolean canRedo(IUndoContext iUndoContext) {
        IUndoableOperation iUndoableOperation = this.getRedoOperation(iUndoContext);
        return iUndoableOperation != null && iUndoableOperation.canRedo();
    }

    public boolean canUndo(IUndoContext iUndoContext) {
        IUndoableOperation iUndoableOperation = this.getUndoOperation(iUndoContext);
        return iUndoableOperation != null && iUndoableOperation.canUndo();
    }

    private boolean checkRedoLimit(IUndoableOperation iUndoableOperation) {
        IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
        int n = 0;
        while (n < iUndoContextArray.length) {
            int n2 = this.getLimit(iUndoContextArray[n]);
            if (n2 > 0) {
                this.forceRedoLimit(iUndoContextArray[n], n2 - 1);
            } else {
                iUndoableOperation.removeContext(iUndoContextArray[n]);
            }
            ++n;
        }
        return iUndoableOperation.getContexts().length > 0;
    }

    private boolean checkUndoLimit(IUndoableOperation iUndoableOperation) {
        IUndoContext[] iUndoContextArray = iUndoableOperation.getContexts();
        int n = 0;
        while (n < iUndoContextArray.length) {
            int n2 = this.getLimit(iUndoContextArray[n]);
            if (n2 > 0) {
                this.forceUndoLimit(iUndoContextArray[n], n2 - 1);
            } else {
                iUndoableOperation.removeContext(iUndoContextArray[n]);
            }
            ++n;
        }
        return iUndoableOperation.getContexts().length > 0;
    }

    public void dispose(IUndoContext iUndoContext, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            if (DEBUG_OPERATION_HISTORY_DISPOSE) {
                Tracing.printTrace("OPERATIONHISTORY", "Flushing context " + iUndoContext);
            }
            this.flushUndo(iUndoContext);
            this.flushRedo(iUndoContext);
            this.limits.remove(iUndoContext);
            return;
        }
        if (bl) {
            this.flushUndo(iUndoContext);
        }
        if (bl2) {
            this.flushRedo(iUndoContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doRedo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, IUndoableOperation iUndoableOperation) throws ExecutionException {
        IStatus iStatus = this.getRedoApproval(iUndoableOperation, iAdaptable);
        if (iStatus.isOK()) {
            this.notifyAboutToRedo(iUndoableOperation);
            try {
                iStatus = iUndoableOperation.redo(iProgressMonitor, iAdaptable);
            }
            catch (OperationCanceledException operationCanceledException) {
                iStatus = Status.CANCEL_STATUS;
            }
            catch (ExecutionException executionException) {
                this.notifyNotOK(iUndoableOperation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "ExecutionException while redoing " + iUndoableOperation);
                }
                throw executionException;
            }
            catch (Exception exception) {
                this.notifyNotOK(iUndoableOperation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Exception while redoing " + iUndoableOperation);
                }
                throw new ExecutionException("While redoing the operation, an exception occurred", exception);
            }
        }
        if (iStatus.isOK()) {
            boolean bl = true;
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.redoList.remove(iUndoableOperation);
                if (this.checkUndoLimit(iUndoableOperation)) {
                    this.undoList.add(iUndoableOperation);
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                iUndoableOperation.dispose();
            }
            this.notifyRedone(iUndoableOperation);
        } else {
            this.notifyNotOK(iUndoableOperation, iStatus);
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, IUndoableOperation iUndoableOperation) throws ExecutionException {
        IStatus iStatus = this.getUndoApproval(iUndoableOperation, iAdaptable);
        if (iStatus.isOK()) {
            this.notifyAboutToUndo(iUndoableOperation);
            try {
                iStatus = iUndoableOperation.undo(iProgressMonitor, iAdaptable);
            }
            catch (OperationCanceledException operationCanceledException) {
                iStatus = Status.CANCEL_STATUS;
            }
            catch (ExecutionException executionException) {
                this.notifyNotOK(iUndoableOperation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "ExecutionException while undoing " + iUndoableOperation);
                }
                throw executionException;
            }
            catch (Exception exception) {
                this.notifyNotOK(iUndoableOperation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Exception while undoing " + iUndoableOperation);
                }
                throw new ExecutionException("While undoing the operation, an exception occurred", exception);
            }
        }
        if (iStatus.isOK()) {
            boolean bl = true;
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.undoList.remove(iUndoableOperation);
                if (this.checkRedoLimit(iUndoableOperation)) {
                    this.redoList.add(iUndoableOperation);
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                iUndoableOperation.dispose();
            }
            this.notifyUndone(iUndoableOperation);
        } else {
            this.notifyNotOK(iUndoableOperation, iStatus);
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IUndoableOperation iUndoableOperation, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        Assert.isNotNull((Object)iUndoableOperation);
        if (!iUndoableOperation.canExecute()) {
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        IStatus iStatus = this.getExecuteApproval(iUndoableOperation, iAdaptable);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        boolean bl = false;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null) {
                if (this.openComposite == iUndoableOperation) {
                    return IOperationHistory.OPERATION_INVALID_STATUS;
                }
                this.openComposite.add(iUndoableOperation);
                bl = true;
            }
        }
        if (!bl) {
            this.notifyAboutToExecute(iUndoableOperation);
        }
        try {
            iStatus = iUndoableOperation.execute(iProgressMonitor, iAdaptable);
        }
        catch (OperationCanceledException operationCanceledException) {
            iStatus = Status.CANCEL_STATUS;
        }
        catch (ExecutionException executionException) {
            this.notifyNotOK(iUndoableOperation);
            throw executionException;
        }
        catch (Exception exception) {
            this.notifyNotOK(iUndoableOperation);
            throw new ExecutionException("While executing the operation, an exception occurred", exception);
        }
        if (!bl) {
            if (iStatus.isOK()) {
                this.notifyDone(iUndoableOperation);
                this.add(iUndoableOperation);
            } else {
                this.notifyNotOK(iUndoableOperation, iStatus);
                iUndoableOperation.dispose();
            }
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IUndoableOperation[] filter(List list, IUndoContext iUndoContext) {
        ArrayList<IUndoableOperation> arrayList = new ArrayList<IUndoableOperation>();
        Iterator iterator = list.iterator();
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            while (iterator.hasNext()) {
                IUndoableOperation iUndoableOperation = (IUndoableOperation)iterator.next();
                if (!iUndoableOperation.hasContext(iUndoContext)) continue;
                arrayList.add(iUndoableOperation);
            }
        }
        return arrayList.toArray(new IUndoableOperation[arrayList.size()]);
    }

    private void flushRedo(IUndoContext iUndoContext) {
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            Tracing.printTrace("OPERATIONHISTORY", "Flushing redo history for " + iUndoContext);
        }
        IUndoableOperation[] iUndoableOperationArray = this.filter(this.redoList, iUndoContext);
        int n = 0;
        while (n < iUndoableOperationArray.length) {
            IUndoableOperation iUndoableOperation = iUndoableOperationArray[n];
            if (iUndoContext == GLOBAL_UNDO_CONTEXT || iUndoableOperation.getContexts().length == 1) {
                this.redoList.remove(iUndoableOperation);
                this.internalRemove(iUndoableOperation);
            } else {
                iUndoableOperation.removeContext(iUndoContext);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUndo(IUndoContext iUndoContext) {
        Object object;
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            Tracing.printTrace("OPERATIONHISTORY", "Flushing undo history for " + iUndoContext);
        }
        IUndoableOperation[] iUndoableOperationArray = this.filter(this.undoList, iUndoContext);
        int n = 0;
        while (n < iUndoableOperationArray.length) {
            object = iUndoableOperationArray[n];
            if (iUndoContext == GLOBAL_UNDO_CONTEXT || object.getContexts().length == 1) {
                this.undoList.remove(object);
                this.internalRemove((IUndoableOperation)object);
            } else {
                object.removeContext(iUndoContext);
            }
            ++n;
        }
        ICompositeOperation iCompositeOperation = null;
        object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite.hasContext(iUndoContext)) {
                if (iUndoContext == GLOBAL_UNDO_CONTEXT || this.openComposite.getContexts().length == 1) {
                    iCompositeOperation = this.openComposite;
                    this.openComposite = null;
                } else {
                    this.openComposite.removeContext(iUndoContext);
                }
            }
        }
        if (iCompositeOperation != null) {
            this.notifyNotOK(iCompositeOperation);
        }
    }

    private void forceRedoLimit(IUndoContext iUndoContext, int n) {
        IUndoableOperation[] iUndoableOperationArray = this.filter(this.redoList, iUndoContext);
        int n2 = iUndoableOperationArray.length;
        if (n2 > 0) {
            int n3 = 0;
            while (n2 > n) {
                IUndoableOperation iUndoableOperation = iUndoableOperationArray[n3];
                if (iUndoContext == GLOBAL_UNDO_CONTEXT || iUndoableOperation.getContexts().length == 1) {
                    this.redoList.remove(iUndoableOperation);
                    this.internalRemove(iUndoableOperation);
                } else {
                    iUndoableOperation.removeContext(iUndoContext);
                }
                --n2;
                ++n3;
            }
        }
    }

    private void forceUndoLimit(IUndoContext iUndoContext, int n) {
        IUndoableOperation[] iUndoableOperationArray = this.filter(this.undoList, iUndoContext);
        int n2 = iUndoableOperationArray.length;
        if (n2 > 0) {
            int n3 = 0;
            while (n2 > n) {
                IUndoableOperation iUndoableOperation = iUndoableOperationArray[n3];
                if (iUndoContext == GLOBAL_UNDO_CONTEXT || iUndoableOperation.getContexts().length == 1) {
                    this.undoList.remove(iUndoableOperation);
                    this.internalRemove(iUndoableOperation);
                } else {
                    iUndoableOperation.removeContext(iUndoContext);
                }
                --n2;
                ++n3;
            }
        }
    }

    public int getLimit(IUndoContext iUndoContext) {
        if (!this.limits.containsKey(iUndoContext)) {
            return 20;
        }
        return (Integer)this.limits.get(iUndoContext);
    }

    private IStatus getRedoApproval(IUndoableOperation iUndoableOperation, IAdaptable iAdaptable) {
        Object[] objectArray = this.approvers.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IOperationApprover iOperationApprover = (IOperationApprover)objectArray[n];
            IStatus iStatus = iOperationApprover.proceedRedoing(iUndoableOperation, this, iAdaptable);
            if (!iStatus.isOK()) {
                if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                    Tracing.printTrace("OPERATIONHISTORY", "Redo not approved by " + iOperationApprover + "for operation " + iUndoableOperation + " approved by " + iStatus);
                }
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IUndoableOperation[] getRedoHistory(IUndoContext iUndoContext) {
        Assert.isNotNull((Object)iUndoContext);
        return this.filter(this.redoList, iUndoContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUndoableOperation getRedoOperation(IUndoContext iUndoContext) {
        Assert.isNotNull((Object)iUndoContext);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int n = this.redoList.size() - 1;
            while (n >= 0) {
                IUndoableOperation iUndoableOperation = (IUndoableOperation)this.redoList.get(n);
                if (iUndoableOperation.hasContext(iUndoContext)) {
                    return iUndoableOperation;
                }
                --n;
            }
        }
        return null;
    }

    private IStatus getUndoApproval(IUndoableOperation iUndoableOperation, IAdaptable iAdaptable) {
        Object[] objectArray = this.approvers.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IOperationApprover iOperationApprover = (IOperationApprover)objectArray[n];
            IStatus iStatus = iOperationApprover.proceedUndoing(iUndoableOperation, this, iAdaptable);
            if (!iStatus.isOK()) {
                if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                    Tracing.printTrace("OPERATIONHISTORY", "Undo not approved by " + iOperationApprover + "for operation " + iUndoableOperation + " with status " + iStatus);
                }
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    public IUndoableOperation[] getUndoHistory(IUndoContext iUndoContext) {
        Assert.isNotNull((Object)iUndoContext);
        return this.filter(this.undoList, iUndoContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUndoableOperation getUndoOperation(IUndoContext iUndoContext) {
        Assert.isNotNull((Object)iUndoContext);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int n = this.undoList.size() - 1;
            while (n >= 0) {
                IUndoableOperation iUndoableOperation = (IUndoableOperation)this.undoList.get(n);
                if (iUndoableOperation.hasContext(iUndoContext)) {
                    return iUndoableOperation;
                }
                --n;
            }
        }
        return null;
    }

    private IStatus getExecuteApproval(IUndoableOperation iUndoableOperation, IAdaptable iAdaptable) {
        Object[] objectArray = this.approvers.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IOperationApprover2 iOperationApprover2;
            IStatus iStatus;
            if (objectArray[n] instanceof IOperationApprover2 && !(iStatus = (iOperationApprover2 = (IOperationApprover2)objectArray[n]).proceedExecuting(iUndoableOperation, this, iAdaptable)).isOK()) {
                if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                    Tracing.printTrace("OPERATIONHISTORY", "Execute not approved by " + iOperationApprover2 + "for operation " + iUndoableOperation + " with status " + iStatus);
                }
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    private void internalRemove(IUndoableOperation iUndoableOperation) {
        iUndoableOperation.dispose();
        this.notifyRemoved(iUndoableOperation);
    }

    private void notifyListeners(OperationHistoryEvent operationHistoryEvent) {
        this.preNotifyOperation(operationHistoryEvent.getOperation(), operationHistoryEvent);
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            try {
                ((IOperationHistoryListener)objectArray[n]).historyNotification(operationHistoryEvent);
            }
            catch (Exception exception) {
                this.handleNotificationException(exception);
            }
            ++n;
        }
    }

    private void notifyAboutToExecute(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_EXECUTE " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(1, this, iUndoableOperation));
    }

    private void notifyAboutToRedo(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_REDO " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(2, this, iUndoableOperation));
    }

    private void notifyAboutToUndo(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_UNDO " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(3, this, iUndoableOperation));
    }

    private void notifyAdd(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_ADDED " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(5, this, iUndoableOperation));
    }

    private void notifyDone(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "DONE " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(4, this, iUndoableOperation));
    }

    private void notifyNotOK(IUndoableOperation iUndoableOperation) {
        this.notifyNotOK(iUndoableOperation, null);
    }

    private void notifyNotOK(IUndoableOperation iUndoableOperation, IStatus iStatus) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_NOT_OK " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(7, this, iUndoableOperation, iStatus));
    }

    private void notifyRedone(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "REDONE " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(9, this, iUndoableOperation));
    }

    private void notifyRemoved(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_REMOVED " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(8, this, iUndoableOperation));
    }

    private void notifyUndone(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "UNDONE " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(10, this, iUndoableOperation));
    }

    private void notifyChanged(IUndoableOperation iUndoableOperation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_CHANGED " + iUndoableOperation);
        }
        this.notifyListeners(new OperationHistoryEvent(6, this, iUndoableOperation));
    }

    private void preNotifyOperation(IUndoableOperation iUndoableOperation, OperationHistoryEvent operationHistoryEvent) {
        if (iUndoableOperation instanceof IAdvancedUndoableOperation) {
            try {
                ((IAdvancedUndoableOperation)((Object)iUndoableOperation)).aboutToNotify(operationHistoryEvent);
            }
            catch (Exception exception) {
                this.handleNotificationException(exception);
            }
        }
    }

    public IStatus redo(IUndoContext iUndoContext, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        Assert.isNotNull((Object)iUndoContext);
        IUndoableOperation iUndoableOperation = this.getRedoOperation(iUndoContext);
        if (iUndoableOperation == null) {
            return IOperationHistory.NOTHING_TO_REDO_STATUS;
        }
        if (!iUndoableOperation.canRedo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Redo operation not valid - " + iUndoableOperation);
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doRedo(iProgressMonitor, iAdaptable, iUndoableOperation);
    }

    public IStatus redoOperation(IUndoableOperation iUndoableOperation, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        IStatus iStatus;
        Assert.isNotNull((Object)iUndoableOperation);
        if (iUndoableOperation.canRedo()) {
            iStatus = this.getRedoApproval(iUndoableOperation, iAdaptable);
            if (iStatus.isOK()) {
                iStatus = this.doRedo(iProgressMonitor, iAdaptable, iUndoableOperation);
            }
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Redo operation not valid - " + iUndoableOperation);
            }
            iStatus = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return iStatus;
    }

    public void removeOperationApprover(IOperationApprover iOperationApprover) {
        this.approvers.remove((Object)iOperationApprover);
    }

    public void removeOperationHistoryListener(IOperationHistoryListener iOperationHistoryListener) {
        this.listeners.remove((Object)iOperationHistoryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOperation(IUndoableOperation iUndoableOperation, IUndoableOperation[] iUndoableOperationArray) {
        int n;
        Object object;
        int n2;
        ArrayList<IUndoContext> arrayList;
        int n3;
        boolean bl = false;
        Object object2 = this.undoRedoHistoryLock;
        synchronized (object2) {
            n3 = this.undoList.indexOf(iUndoableOperation);
            if (n3 > -1) {
                bl = true;
                this.undoList.remove(iUndoableOperation);
                arrayList = new ArrayList<IUndoContext>(iUndoableOperationArray.length);
                n2 = 0;
                while (n2 < iUndoableOperationArray.length) {
                    object = iUndoableOperationArray[n2].getContexts();
                    n = 0;
                    while (n < ((IUndoContext[])object).length) {
                        arrayList.add(object[n]);
                        ++n;
                    }
                    this.undoList.add(n3, iUndoableOperationArray[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    object = (IUndoContext)arrayList.get(n2);
                    this.forceUndoLimit((IUndoContext)object, this.getLimit((IUndoContext)object));
                    ++n2;
                }
            }
        }
        if (bl) {
            this.internalRemove(iUndoableOperation);
            int n4 = 0;
            while (n4 < iUndoableOperationArray.length) {
                this.notifyAdd(iUndoableOperationArray[n4]);
                ++n4;
            }
            return;
        }
        object2 = this.undoRedoHistoryLock;
        synchronized (object2) {
            n3 = this.redoList.indexOf(iUndoableOperation);
            if (n3 == -1) {
                return;
            }
            arrayList = new ArrayList(iUndoableOperationArray.length);
            this.redoList.remove(iUndoableOperation);
            n2 = 0;
            while (n2 < iUndoableOperationArray.length) {
                object = iUndoableOperationArray[n2].getContexts();
                n = 0;
                while (n < ((IUndoContext[])object).length) {
                    arrayList.add(object[n]);
                    ++n;
                }
                this.redoList.add(n3, iUndoableOperationArray[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < arrayList.size()) {
                object = (IUndoContext)arrayList.get(n2);
                this.forceRedoLimit((IUndoContext)object, this.getLimit((IUndoContext)object));
                ++n2;
            }
        }
        this.internalRemove(iUndoableOperation);
        int n5 = 0;
        while (n5 < iUndoableOperationArray.length) {
            this.notifyAdd(iUndoableOperationArray[n5]);
            ++n5;
        }
    }

    public void setLimit(IUndoContext iUndoContext, int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)iUndoContext);
        this.limits.put(iUndoContext, new Integer(n));
        this.forceUndoLimit(iUndoContext, n);
        this.forceRedoLimit(iUndoContext, n);
    }

    public IStatus undo(IUndoContext iUndoContext, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        Assert.isNotNull((Object)iUndoContext);
        IUndoableOperation iUndoableOperation = this.getUndoOperation(iUndoContext);
        if (iUndoableOperation == null) {
            return IOperationHistory.NOTHING_TO_UNDO_STATUS;
        }
        if (!iUndoableOperation.canUndo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Undo operation not valid - " + iUndoableOperation);
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doUndo(iProgressMonitor, iAdaptable, iUndoableOperation);
    }

    public IStatus undoOperation(IUndoableOperation iUndoableOperation, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        IStatus iStatus;
        Assert.isNotNull((Object)iUndoableOperation);
        if (iUndoableOperation.canUndo()) {
            iStatus = this.getUndoApproval(iUndoableOperation, iAdaptable);
            if (iStatus.isOK()) {
                iStatus = this.doUndo(iProgressMonitor, iAdaptable, iUndoableOperation);
            }
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Undo operation not valid - " + iUndoableOperation);
            }
            iStatus = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOperation(ICompositeOperation iCompositeOperation, int n) {
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite != iCompositeOperation) {
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Open operation called while another operation is open.  old: " + this.openComposite + "; new:  " + iCompositeOperation);
                }
                throw new IllegalStateException("Cannot open an operation while one is already open");
            }
            this.openComposite = iCompositeOperation;
        }
        if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
            Tracing.printTrace("OPERATIONHISTORY", "Opening operation " + this.openComposite);
        }
        if (n == 1) {
            this.notifyAboutToExecute(this.openComposite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOperation(boolean bl, boolean bl2, int n) {
        ICompositeOperation iCompositeOperation = null;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED && this.openComposite == null) {
                Tracing.printTrace("OPERATIONHISTORY", "Attempted to close operation when none was open");
                return;
            }
            if (this.openComposite != null) {
                if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
                    Tracing.printTrace("OPERATIONHISTORY", "Closing operation " + this.openComposite);
                }
                iCompositeOperation = this.openComposite;
                this.openComposite = null;
            }
        }
        if (iCompositeOperation != null) {
            if (bl) {
                if (n == 1) {
                    this.notifyDone(iCompositeOperation);
                }
                if (bl2) {
                    this.add(iCompositeOperation);
                }
            } else if (n == 1) {
                this.notifyNotOK(iCompositeOperation);
            }
        }
    }

    public void operationChanged(IUndoableOperation iUndoableOperation) {
        if (this.undoList.contains(iUndoableOperation) || this.redoList.contains(iUndoableOperation)) {
            this.notifyChanged(iUndoableOperation);
        }
    }

    private void handleNotificationException(Throwable throwable) {
        if (throwable instanceof OperationCanceledException) {
            return;
        }
        if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
            Tracing.printTrace("OPERATIONHISTORY", "Exception during notification callback " + throwable);
        }
        throwable.printStackTrace();
    }
}

