/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    private final JobManager manager;
    protected boolean acquireRule = false;
    boolean isBlocked = false;
    protected boolean isRunning = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    private int top;

    ThreadJob(JobManager jobManager, ISchedulingRule iSchedulingRule) {
        super("Implicit Job");
        this.manager = jobManager;
        this.setSystem(true);
        this.setPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.setRule(iSchedulingRule);
    }

    private void illegalPop(ISchedulingRule iSchedulingRule) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to endRule: ");
        stringBuffer.append(iSchedulingRule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            stringBuffer.append(", does not match most recent begin: ");
            stringBuffer.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            stringBuffer.append(", but there was no matching beginRule");
        } else {
            stringBuffer.append(", but the rule stack was out of bounds: " + this.top);
        }
        stringBuffer.append(".  See log for trace information if rule tracing is enabled.");
        String string = stringBuffer.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(string);
            RuntimeException runtimeException = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)runtimeException);
            RuntimeLog.log((IStatus)status);
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private void illegalPush(ISchedulingRule iSchedulingRule, ISchedulingRule iSchedulingRule2) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to beginRule: ");
        stringBuffer.append(iSchedulingRule);
        stringBuffer.append(", does not match outer scope rule: ");
        stringBuffer.append(iSchedulingRule2);
        String string = stringBuffer.toString();
        if (JobManager.DEBUG) {
            System.out.println(string);
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)new IllegalArgumentException());
            RuntimeLog.log((IStatus)status);
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private boolean isCanceled(IProgressMonitor iProgressMonitor) {
        try {
            return iProgressMonitor.isCanceled();
        }
        catch (RuntimeException runtimeException) {
            Status status = new Status(4, "org.eclipse.core.jobs", 2, "ThreadJob.isCanceled", (Throwable)runtimeException);
            RuntimeLog.log((IStatus)status);
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ThreadJob joinRun(IProgressMonitor var1_1) {
        if (this.isCanceled(var1_1)) {
            throw new OperationCanceledException();
        }
        var2_2 = this.manager.findBlockingJob(this);
        var3_3 = var2_2 == null ? null : var2_2.getThread();
        var4_4 = this;
        try {
            if (this.manager.getLockManager().aboutToWait(var3_3)) {
                var12_5 = this;
                var10_6 = null;
                this.manager.getLockManager().aboutToRelease();
                return var12_5;
            }
            try {
                this.waitStart(var1_1, var2_2);
                var5_11 = Thread.currentThread();
                while (true) lbl-1000:
                // 2 sources

                {
                    if (this.isCanceled(var1_1)) {
                        throw new OperationCanceledException();
                    }
                    if (!this.manager.runNow(this)) break block16;
                    var9_13 = this;
                    var7_16 = null;
                    if (this != var4_4) break block17;
                    this.waitEnd(var1_1);
                    break;
                }
            }
            catch (Throwable var8_20) {
                var7_19 = null;
                if (this != var4_4) throw var8_20;
                this.waitEnd(var1_1);
                throw var8_20;
            }
            {
                block20: {
                    block21: {
                        block18: {
                            block19: {
                                block16: {
                                    block17: {
                                    }
                                    var10_7 = null;
                                    this.manager.getLockManager().aboutToRelease();
                                    return var9_13;
                                }
                                var2_2 = this.manager.findBlockingJob(this);
                                v0 = var3_3 = var2_2 == null ? null : var2_2.getThread();
                                if (var3_3 != var5_11 || !(var2_2 instanceof ThreadJob)) break block18;
                                var4_4 = (ThreadJob)var2_2;
                                var4_4.push(this.getRule());
                                var4_4.isBlocked = this.isBlocked;
                                var9_14 = var4_4;
                                var7_17 = null;
                                if (this != var4_4) break block19;
                                this.waitEnd(var1_1);
                            }
                            var10_8 = null;
                            this.manager.getLockManager().aboutToRelease();
                            return var9_14;
                        }
                        if (!this.manager.getLockManager().aboutToWait(var3_3)) break block20;
                        var9_15 = this;
                        var7_18 = null;
                        if (this != var4_4) break block21;
                        this.waitEnd(var1_1);
                    }
                    var10_9 = null;
                    this.manager.getLockManager().aboutToRelease();
                    return var9_15;
                }
                var6_12 = this;
                synchronized (var6_12) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException v1) {}
                    continue;
                }
                ** while (true)
            }
        }
        catch (Throwable var11_21) {
            var10_10 = null;
            this.manager.getLockManager().aboutToRelease();
            throw var11_21;
        }
    }

    boolean pop(ISchedulingRule iSchedulingRule) {
        if (this.top < 0 || this.ruleStack[this.top] != iSchedulingRule) {
            this.illegalPop(iSchedulingRule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule iSchedulingRule) {
        ISchedulingRule iSchedulingRule2 = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, iSchedulingRuleArray, 0, this.ruleStack.length);
            this.ruleStack = iSchedulingRuleArray;
        }
        this.ruleStack[this.top] = iSchedulingRule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
        }
        if (iSchedulingRule2 != null && iSchedulingRule != null && !iSchedulingRule2.contains(iSchedulingRule)) {
            this.illegalPush(iSchedulingRule, iSchedulingRule2);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.isBlocked = false;
        this.isRunning = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor iProgressMonitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.isRunning = true;
            this.notify();
        }
        return ASYNC_FINISH;
    }

    void setRealJob(Job job) {
        this.realJob = job;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ThreadJob");
        stringBuffer.append('(').append(this.realJob).append(',').append('[');
        int n = 0;
        while (n <= this.top && n < this.ruleStack.length) {
            stringBuffer.append(this.ruleStack[n]).append(',');
            ++n;
        }
        stringBuffer.append(']').append(')');
        return stringBuffer.toString();
    }

    private void waitEnd(IProgressMonitor iProgressMonitor) {
        LockManager lockManager = this.manager.getLockManager();
        Thread thread = Thread.currentThread();
        if (this.isRunning()) {
            lockManager.addLockThread(thread, this.getRule());
            lockManager.resumeSuspendedLocks(thread);
        } else {
            lockManager.removeLockWaitThread(thread, this.getRule());
        }
    }

    private void waitStart(IProgressMonitor iProgressMonitor, InternalJob internalJob) {
        this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
        this.isBlocked = true;
        this.manager.reportBlocked(iProgressMonitor, internalJob);
    }
}

