/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContentHandlerProxy
extends ContentHandler
implements ServiceTrackerCustomizer {
    protected ContentHandler realHandler;
    protected ServiceTracker contentHandlerServiceTracker;
    protected BundleContext context;
    protected ServiceReference contentHandlerServiceReference;
    protected String contentType;
    protected int ranking = -1;
    static /* synthetic */ Class class$0;

    public ContentHandlerProxy(String string, ServiceReference serviceReference, BundleContext bundleContext) {
        Class<?> clazz;
        this.context = bundleContext;
        this.contentType = string;
        if (serviceReference != null) {
            this.setNewHandler(serviceReference, this.getRank(serviceReference));
        } else {
            this.realHandler = new DefaultContentHandler();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.net.ContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.contentHandlerServiceTracker = new ServiceTracker(bundleContext, clazz.getName(), (ServiceTrackerCustomizer)this);
        StreamHandlerFactory.secureAction.open(this.contentHandlerServiceTracker);
    }

    private void setNewHandler(ServiceReference serviceReference, int n) {
        this.contentHandlerServiceReference = serviceReference;
        this.ranking = n;
        this.realHandler = (ContentHandler)StreamHandlerFactory.secureAction.getService(serviceReference, this.context);
    }

    public Object addingService(ServiceReference serviceReference) {
        Object object = serviceReference.getProperty("url.content.mimetype");
        if (!(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.contentType)) {
                int n2 = this.getRank(serviceReference);
                if (n2 > this.ranking) {
                    this.setNewHandler(serviceReference, n2);
                }
                return serviceReference;
            }
            ++n;
        }
        return null;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        int n = this.getRank(serviceReference);
        if (serviceReference == this.contentHandlerServiceReference) {
            ServiceReference serviceReference2;
            if (n < this.ranking && (serviceReference2 = this.contentHandlerServiceTracker.getServiceReference()) != this.contentHandlerServiceReference && serviceReference2 != null) {
                this.setNewHandler(serviceReference2, (Integer)serviceReference2.getProperty("service.ranking"));
            }
        } else if (n > this.ranking) {
            this.setNewHandler(serviceReference, n);
        }
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        if (serviceReference == this.contentHandlerServiceReference) {
            ServiceReference serviceReference2 = this.contentHandlerServiceTracker.getServiceReference();
            if (serviceReference2 != null) {
                this.setNewHandler(serviceReference2, this.getRank(serviceReference2));
            } else {
                this.ranking = -1;
                this.realHandler = new DefaultContentHandler();
            }
        }
    }

    public Object getContent(URLConnection uRLConnection) throws IOException {
        return this.realHandler.getContent(uRLConnection);
    }

    private int getRank(ServiceReference serviceReference) {
        Object object = serviceReference.getProperty("service.ranking");
        return object instanceof Integer ? (Integer)object : 0;
    }

    class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        public Object getContent(URLConnection uRLConnection) throws IOException {
            return uRLConnection.getInputStream();
        }
    }
}

