/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;

public class ResolverExport
extends VersionSupplier {
    private ResolverBundle resolverBundle;

    ResolverExport(ResolverBundle resolverBundle, ExportPackageDescription exportPackageDescription) {
        super(exportPackageDescription);
        this.resolverBundle = resolverBundle;
    }

    public ExportPackageDescription getExportPackageDescription() {
        return (ExportPackageDescription)this.base;
    }

    public BundleDescription getBundle() {
        return this.getExportPackageDescription().getExporter();
    }

    ResolverBundle getExporter() {
        return this.resolverBundle;
    }

    ResolverExport[] getRoots() {
        ArrayList arrayList = new ArrayList(1);
        this.addRoots(arrayList);
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    private void addRoots(ArrayList arrayList) {
        if (arrayList.contains(this)) {
            return;
        }
        ResolverImport resolverImport = this.getExporter().getImport(this.getName());
        if (resolverImport != null && resolverImport.getMatchingExport() != null && resolverImport.getMatchingExport() != this) {
            resolverImport.getMatchingExport().addRoots(arrayList);
            return;
        }
        arrayList.add(0, this);
        BundleConstraint[] bundleConstraintArray = this.getExporter().getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            ResolverExport resolverExport;
            if (bundleConstraintArray[n].getMatchingBundle() != null && (resolverExport = bundleConstraintArray[n].getBundle().getExport(this.getName())) != null && !resolverExport.isDropped()) {
                resolverExport.addRoots(arrayList);
            }
            ++n;
        }
    }
}

