/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.osgi.framework.BundleException;

public class UserState
extends StateImpl {
    private List added = new ArrayList();
    private List removed = new ArrayList();
    private List updated = new ArrayList();

    public synchronized boolean addBundle(BundleDescription bundleDescription) {
        if (!super.addBundle(bundleDescription)) {
            return false;
        }
        this.added.add(bundleDescription.getLocation());
        return true;
    }

    public synchronized boolean removeBundle(BundleDescription bundleDescription) {
        if (!super.removeBundle(bundleDescription)) {
            return false;
        }
        this.removed.add(bundleDescription.getLocation());
        return true;
    }

    public boolean updateBundle(BundleDescription bundleDescription) {
        if (!super.updateBundle(bundleDescription)) {
            return false;
        }
        this.updated.add(bundleDescription.getLocation());
        return true;
    }

    public String[] getAllAdded() {
        return this.added.toArray(new String[this.added.size()]);
    }

    public String[] getAllRemoved() {
        return this.removed.toArray(new String[this.removed.size()]);
    }

    public String[] getAllUpdated() {
        return this.updated.toArray(new String[this.updated.size()]);
    }

    public StateDelta compare(State state) throws BundleException {
        BundleDescription[] bundleDescriptionArray = this.getBundles();
        StateDeltaImpl stateDeltaImpl = new StateDeltaImpl(this);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            BundleDescription bundleDescription = state.getBundleByLocation(bundleDescriptionArray[n].getLocation());
            if (bundleDescription == null) {
                stateDeltaImpl.recordBundleAdded((BundleDescriptionImpl)bundleDescriptionArray[n]);
            } else if (this.updated.contains(bundleDescriptionArray[n].getLocation())) {
                stateDeltaImpl.recordBundleUpdated((BundleDescriptionImpl)bundleDescriptionArray[n]);
            }
            ++n;
        }
        BundleDescription[] bundleDescriptionArray2 = state.getBundles();
        int n2 = 0;
        while (n2 < bundleDescriptionArray2.length) {
            BundleDescription bundleDescription = this.getBundleByLocation(bundleDescriptionArray2[n2].getLocation());
            if (bundleDescription == null) {
                stateDeltaImpl.recordBundleRemoved((BundleDescriptionImpl)bundleDescriptionArray2[n2]);
            }
            ++n2;
        }
        return stateDeltaImpl;
    }
}

