/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

class DigestedInputStream
extends FilterInputStream {
    MessageDigest[] digest;
    byte[][] result;
    long remaining;

    DigestedInputStream(InputStream inputStream, MessageDigest[] messageDigestArray, byte[][] byArray, long l) {
        super(inputStream);
        this.remaining = l;
        this.digest = new MessageDigest[messageDigestArray.length];
        int n = 0;
        while (n < messageDigestArray.length) {
            try {
                this.digest[n] = (MessageDigest)messageDigestArray[n].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("MessageDigest must support clone");
            }
            ++n;
        }
        this.result = byArray;
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            int n2 = 0;
            while (n2 < this.digest.length) {
                this.digest[n2].update((byte)n);
                ++n2;
            }
            --this.remaining;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining == 0L) {
            this.verifyDigests();
        }
        return n;
    }

    private void verifyDigests() throws IOException {
        int n = 0;
        while (n < this.digest.length) {
            byte[] byArray = this.digest[n].digest();
            if (!MessageDigest.isEqual(this.result[n], byArray)) {
                throw new IOException("Corrupted file: the digest is valid for " + this.digest[n].getAlgorithm());
            }
            ++n;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            int n4 = 0;
            while (n4 < this.digest.length) {
                this.digest[n4].update(byArray, n, n3);
                ++n4;
            }
            this.remaining -= (long)n3;
        } else {
            this.remaining = 0L;
        }
        if (this.remaining <= 0L) {
            this.verifyDigests();
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while (l - l2 > 0L) {
            int n = l - l2 > (long)byArray.length ? byArray.length : (int)(l - l2);
            if ((n = this.read(byArray, 0, n)) == -1) break;
            l2 += (long)n;
            l -= (long)n;
        }
        return l2;
    }
}

