/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class PreferencePage
implements IPreferencePage {
    private Image image = null;
    private ImageDescriptor imageDescriptor = null;
    private IPreferenceStore preferenceStore;
    private boolean isValid = true;
    private Control body;
    private Control control;
    private boolean createDefaultAndApplyButton = true;
    private Button defaultsButton = null;
    private IPreferencePageContainer container = null;
    private Button applyButton = null;
    private Label descriptionLabel;
    private String description = null;
    private Point size = null;
    private String title = null;

    protected PreferencePage() {
        this("");
    }

    protected PreferencePage(String string) {
        this.title = string;
    }

    protected PreferencePage(String string, ImageDescriptor imageDescriptor) {
        this.title = string;
        this.imageDescriptor = imageDescriptor;
    }

    protected abstract Control createContents(Composite var1);

    public void createControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.body = this.createContents(composite);
        this.setControl(this.body);
        if (this.body != null) {
            this.body.setLayoutData((Object)new GridData(1808));
        }
        composite.layout();
    }

    private void setControl(Control control) {
        this.control = control;
    }

    public Control getControl() {
        return this.control;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return null;
    }

    public IPreferencePageContainer getContainer() {
        return this.container;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.doGetPreferenceStore();
        }
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        if (this.container != null) {
            return this.container.getPreferenceStore();
        }
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void noDefaultAndApplyButton() {
        this.createDefaultAndApplyButton = false;
    }

    public boolean okToLeave() {
        return this.isValid();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performCancel() {
        return true;
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }

    public void setContainer(IPreferencePageContainer iPreferencePageContainer) {
        this.container = iPreferencePageContainer;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.preferenceStore = iPreferenceStore;
    }

    public void setSize(Point point) {
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    public String toString() {
        return this.title;
    }

    protected Composite createNoteComposite(Font font, Composite composite, String string, String string2) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setFont(font);
        final Label label = new Label(composite2, 1);
        label.setText(string);
        label.setFont(JFaceResources.getBannerFont());
        label.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.jface.bannerfont".equals(propertyChangeEvent.getProperty())) {
                    label.setFont(JFaceResources.getFont("org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        Label label2 = new Label(composite2, 64);
        label2.setText(string2);
        label2.setFont(font);
        return composite2;
    }

    protected Button getApplyButton() {
        return this.applyButton;
    }

    protected Button getDefaultsButton() {
        return this.defaultsButton;
    }

    public void applyData(Object object) {
    }

    public String getTitle() {
        if (this.title == null) {
            return "title not supplied";
        }
        return this.title;
    }

    public Image getImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public Point computeSize() {
        return new Point(0, 0);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }
}

