/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.AndExpression;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.internal.expressions.EnablementExpression;
import org.eclipse.core.internal.expressions.EqualsExpression;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.OrExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.internal.expressions.TestExpression;
import org.eclipse.core.internal.expressions.WithExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class StandardElementHandler
extends ElementHandler {
    public Expression create(ExpressionConverter expressionConverter, IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getName();
        if ("instanceof".equals(string)) {
            return new InstanceofExpression(iConfigurationElement);
        }
        if ("test".equals(string)) {
            return new TestExpression(iConfigurationElement);
        }
        if ("or".equals(string)) {
            OrExpression orExpression = new OrExpression();
            this.processChildren(expressionConverter, iConfigurationElement, orExpression);
            return orExpression;
        }
        if ("and".equals(string)) {
            AndExpression andExpression = new AndExpression();
            this.processChildren(expressionConverter, iConfigurationElement, andExpression);
            return andExpression;
        }
        if ("not".equals(string)) {
            return new NotExpression(expressionConverter.perform(iConfigurationElement.getChildren()[0]));
        }
        if ("with".equals(string)) {
            WithExpression withExpression = new WithExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, withExpression);
            return withExpression;
        }
        if ("adapt".equals(string)) {
            AdaptExpression adaptExpression = new AdaptExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, adaptExpression);
            return adaptExpression;
        }
        if ("iterate".equals(string)) {
            IterateExpression iterateExpression = new IterateExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, iterateExpression);
            return iterateExpression;
        }
        if ("count".equals(string)) {
            return new CountExpression(iConfigurationElement);
        }
        if ("systemTest".equals(string)) {
            return new SystemTestExpression(iConfigurationElement);
        }
        if ("resolve".equals(string)) {
            ResolveExpression resolveExpression = new ResolveExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, resolveExpression);
            return resolveExpression;
        }
        if ("enablement".equals(string)) {
            EnablementExpression enablementExpression = new EnablementExpression(iConfigurationElement);
            this.processChildren(expressionConverter, iConfigurationElement, enablementExpression);
            return enablementExpression;
        }
        if ("equals".equals(string)) {
            return new EqualsExpression(iConfigurationElement);
        }
        return null;
    }
}

