/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.PropertyCache;
import org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import org.eclipse.core.internal.expressions.TypeExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class TypeExtensionManager
implements IRegistryChangeListener {
    private String fExtensionPoint;
    private static final String TYPE = "type";
    private static final IPropertyTester[] EMPTY_PROPERTY_TESTER_ARRAY = new IPropertyTester[0];
    private static final IPropertyTester NULL_PROPERTY_TESTER = new IPropertyTester(){

        public boolean handles(String string, String string2) {
            return false;
        }

        public boolean isInstantiated() {
            return true;
        }

        public boolean isDeclaringPluginActive() {
            return true;
        }

        public IPropertyTester instantiate() throws CoreException {
            return this;
        }

        public boolean test(Object object, String string, Object[] objectArray, Object object2) {
            return false;
        }
    };
    private Map fTypeExtensionMap;
    private Map fConfigurationElementMap;
    private PropertyCache fPropertyCache;

    public TypeExtensionManager(String string) {
        Assert.isNotNull((Object)string);
        this.fExtensionPoint = string;
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        this.initializeCaches();
    }

    public Property getProperty(Object object, String string, String string2) throws CoreException {
        return this.getProperty(object, string, string2, false);
    }

    public synchronized Property getProperty(Object object, String string, String string2, boolean bl) throws CoreException {
        TypeExtension typeExtension;
        IPropertyTester iPropertyTester;
        Class<?> clazz;
        Property property;
        Property property2;
        long l = 0L;
        if (Expressions.TRACING) {
            l = System.currentTimeMillis();
        }
        if ((property2 = this.fPropertyCache.get(property = new Property(clazz = object instanceof Class ? (Class<?>)object : object.getClass(), string, string2))) != null) {
            if (property2.isValidCacheEntry(bl)) {
                if (Expressions.TRACING) {
                    System.out.println("[Type Extension] - method " + clazz.getName() + "#" + string2 + " found in cache: " + (System.currentTimeMillis() - l) + " ms.");
                }
                return property2;
            }
            this.fPropertyCache.remove(property2);
        }
        if ((iPropertyTester = (typeExtension = this.get(clazz)).findTypeExtender(this, string, string2, object instanceof Class, bl)) == TypeExtension.CONTINUE || iPropertyTester == null) {
            throw new CoreException((IStatus)new ExpressionStatus(201, Messages.format(ExpressionMessages.TypeExtender_unknownMethod, new Object[]{string2, clazz.toString()})));
        }
        property.setPropertyTester(iPropertyTester);
        this.fPropertyCache.put(property);
        if (Expressions.TRACING) {
            System.out.println("[Type Extension] - method " + clazz.getName() + "#" + string2 + " not found in cache: " + (System.currentTimeMillis() - l) + " ms.");
        }
        return property;
    }

    TypeExtension get(Class clazz) {
        TypeExtension typeExtension = (TypeExtension)this.fTypeExtensionMap.get(clazz);
        if (typeExtension == null) {
            typeExtension = new TypeExtension(clazz);
            this.fTypeExtensionMap.put(clazz, typeExtension);
        }
        return typeExtension;
    }

    IPropertyTester[] loadTesters(Class clazz) {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        String string;
        if (this.fConfigurationElementMap == null) {
            this.fConfigurationElementMap = new HashMap();
            string = Platform.getExtensionRegistry();
            iConfigurationElementArray = string.getConfigurationElementsFor(ExpressionPlugin.getPluginId(), this.fExtensionPoint);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                object = iConfigurationElement.getAttribute(TYPE);
                ArrayList<IConfigurationElement> arrayList = (ArrayList<IConfigurationElement>)this.fConfigurationElementMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<IConfigurationElement>();
                    this.fConfigurationElementMap.put(object, arrayList);
                }
                arrayList.add(iConfigurationElement);
                ++n;
            }
        }
        if ((iConfigurationElementArray = (IConfigurationElement[])this.fConfigurationElementMap.get(string = clazz.getName())) == null) {
            return EMPTY_PROPERTY_TESTER_ARRAY;
        }
        IPropertyTester[] iPropertyTesterArray = new IPropertyTester[iConfigurationElementArray.size()];
        int n = 0;
        while (n < iPropertyTesterArray.length) {
            object = (IConfigurationElement)iConfigurationElementArray.get(n);
            try {
                iPropertyTesterArray[n] = new PropertyTesterDescriptor((IConfigurationElement)object);
            }
            catch (CoreException coreException) {
                ExpressionPlugin.getDefault().getLog().log(coreException.getStatus());
                iPropertyTesterArray[n] = NULL_PROPERTY_TESTER;
            }
            ++n;
        }
        this.fConfigurationElementMap.remove(string);
        return iPropertyTesterArray;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(ExpressionPlugin.getPluginId(), this.fExtensionPoint);
        if (iExtensionDeltaArray.length > 0) {
            this.initializeCaches();
        }
    }

    private synchronized void initializeCaches() {
        this.fTypeExtensionMap = new HashMap();
        this.fConfigurationElementMap = null;
        this.fPropertyCache = new PropertyCache(1000);
    }
}

