/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private Object token;

    public EclipseBundleListener(ExtensionRegistry extensionRegistry, Object object) {
        this.registry = extensionRegistry;
        this.token = object;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        switch (bundleEvent.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundleArray) {
        int n = 0;
        while (n < bundleArray.length) {
            if (this.isBundleResolved(bundleArray[n])) {
                this.addBundle(bundleArray[n]);
            } else {
                this.removeBundle(bundleArray[n]);
            }
            ++n;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        this.registry.remove(Long.toString(bundle.getBundleId()));
    }

    private void addBundle(Bundle bundle) {
        Object object;
        Object object2;
        String string = Long.toString(bundle.getBundleId());
        if (this.registry.hasContribution(string)) {
            return;
        }
        if (bundle.getBundleId() == 0L) {
            return;
        }
        if (bundle.getSymbolicName() == null) {
            return;
        }
        if (!this.isSingleton(bundle)) {
            return;
        }
        boolean bl = OSGIUtils.getDefault().isFragment(bundle);
        if (bl && (object2 = OSGIUtils.getDefault().getHosts(bundle)) != null && !this.isSingleton(object2[0])) {
            return;
        }
        object2 = null;
        String string2 = bl ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        try {
            object = bundle.getEntry(string2);
            if (object != null) {
                object2 = ((URL)object).openStream();
            }
        }
        catch (IOException iOException) {
            object2 = null;
        }
        if (object2 == null) {
            return;
        }
        object = null;
        try {
            object = ResourceTranslator.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {}
        IContributor iContributor = ContributorFactoryOSGi.createContributor(bundle);
        this.registry.addContribution((InputStream)object2, iContributor, true, string2, (ResourceBundle)object, this.token);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSingleton(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String string = (String)dictionary.get("Bundle-SymbolicName");
        try {
            if (string == null) return true;
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)string);
            if (manifestElementArray.length <= 0) return true;
            String string2 = manifestElementArray[0].getDirective("singleton");
            if (string2 == null) {
                string2 = manifestElementArray[0].getAttribute("singleton");
            }
            if ("true".equalsIgnoreCase(string2)) return true;
            int n = 1;
            String string3 = (String)dictionary.get("Bundle-ManifestVersion");
            if (string3 == null) {
                if (OSGIUtils.getDefault().getBundle(manifestElementArray[0].getValue()) == bundle) {
                    return true;
                }
                n = 4;
            }
            if (!this.registry.debug()) {
                if (n != 4) return false;
            }
            String string4 = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundle.getLocation());
            RuntimeLog.log((IStatus)new Status(n, "org.eclipse.equinox.registry", 0, string4, null));
            return false;
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

