/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class RegistryReader {
    public static final String ATT_CLASS = "class";
    public static final String TAG_DESCRIPTION = "description";

    protected RegistryReader() {
    }

    protected static void logError(IConfigurationElement iConfigurationElement, String string) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Plugin " + iExtension.getNamespace() + ", extension " + iExtension.getExtensionPointUniqueIdentifier());
        stringBuffer.append("\n" + string);
        WorkbenchPlugin.log(stringBuffer.toString());
    }

    protected static void logMissingAttribute(IConfigurationElement iConfigurationElement, String string) {
        RegistryReader.logError(iConfigurationElement, "Required attribute '" + string + "' not defined");
    }

    protected static void logMissingElement(IConfigurationElement iConfigurationElement, String string) {
        RegistryReader.logError(iConfigurationElement, "Required sub element '" + string + "' not defined");
    }

    protected static void logUnknownElement(IConfigurationElement iConfigurationElement) {
        RegistryReader.logError(iConfigurationElement, "Unknown extension tag found: " + iConfigurationElement.getName());
    }

    public static IExtension[] orderExtensions(IExtension[] iExtensionArray) {
        IExtension[] iExtensionArray2 = new IExtension[iExtensionArray.length];
        System.arraycopy(iExtensionArray, 0, iExtensionArray2, 0, iExtensionArray.length);
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((IExtension)object).getNamespace();
                String string2 = ((IExtension)object2).getNamespace();
                return string.compareToIgnoreCase(string2);
            }
        };
        Collections.sort(Arrays.asList(iExtensionArray2), comparator);
        return iExtensionArray2;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement iConfigurationElement) {
        this.readElements(iConfigurationElement.getChildren());
    }

    protected void readElements(IConfigurationElement[] iConfigurationElementArray) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (!this.readElement(iConfigurationElementArray[n])) {
                RegistryReader.logUnknownElement(iConfigurationElementArray[n]);
            }
            ++n;
        }
    }

    protected void readExtension(IExtension iExtension) {
        this.readElements(iExtension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry iExtensionRegistry, String string, String string2) {
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        iExtensionArray = RegistryReader.orderExtensions(iExtensionArray);
        int n = 0;
        while (n < iExtensionArray.length) {
            this.readExtension(iExtensionArray[n]);
            ++n;
        }
    }

    public static String getDescription(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_DESCRIPTION);
        if (iConfigurationElementArray.length >= 1) {
            return iConfigurationElementArray[0].getValue();
        }
        return "";
    }

    public static String getClassValue(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 != null) {
            return string2;
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(string);
        if (iConfigurationElementArray.length == 0) {
            return null;
        }
        return iConfigurationElementArray[0].getAttribute(ATT_CLASS);
    }
}

