/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.core.InternalSiteManager;

public class SiteManager {
    private static String os;
    private static String ws;
    private static String arch;
    private static String nl;
    private static boolean isHttpProxyEnable;

    private SiteManager() {
    }

    public static ISite getSite(URL uRL) throws CoreException {
        return InternalSiteManager.getSite(uRL, true, null);
    }

    public static ISite getSite(URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        return InternalSiteManager.getSite(uRL, true, iProgressMonitor);
    }

    public static ISite getSite(URL uRL, boolean bl) throws CoreException {
        return InternalSiteManager.getSite(uRL, bl, null);
    }

    public static ISite getSite(URL uRL, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        return InternalSiteManager.getSite(uRL, bl, iProgressMonitor);
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.getLocalSite();
    }

    public static void handleNewChanges() throws CoreException {
    }

    public static String getOSArch() {
        if (arch == null) {
            arch = Platform.getOSArch();
        }
        return arch;
    }

    public static String getOS() {
        if (os == null) {
            os = Platform.getOS();
        }
        return os;
    }

    public static String getWS() {
        if (ws == null) {
            ws = Platform.getWS();
        }
        return ws;
    }

    public static void setOSArch(String string) {
        arch = string;
    }

    public static void setOS(String string) {
        os = string;
    }

    public static void setWS(String string) {
        ws = string;
    }

    public static void setNL(String string) {
        nl = string;
    }

    public static long getEstimatedTransferRate(URL uRL) {
        if (uRL == null) {
            return 0L;
        }
        return InternalSiteManager.getEstimatedTransferRate(uRL.getHost());
    }

    public static String getNL() {
        if (nl == null) {
            nl = Platform.getNL();
        }
        return nl;
    }

    public static String getHttpProxyServer() {
        return AppPlugin.getPlugin().getPluginPreferences().getString(AppPlugin.HTTP_PROXY_HOST);
    }

    public static String getHttpProxyPort() {
        return AppPlugin.getPlugin().getPluginPreferences().getString(AppPlugin.HTTP_PROXY_PORT);
    }

    public static boolean isHttpProxyEnable() {
        return isHttpProxyEnable;
    }

    public static void setHttpProxyInfo(boolean bl, String string, String string2) {
        isHttpProxyEnable = bl;
        if (!bl || string == null || string2 == null) {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.proxySet");
            AppPlugin.warn("Remove proxy server info");
            AppPlugin.getPlugin().getPluginPreferences().setValue(AppPlugin.HTTP_PROXY_ENABLE, bl);
            AppPlugin.getPlugin().savePluginPreferences();
            return;
        }
        System.getProperties().setProperty("http.proxySet", bl ? "true" : "false");
        System.getProperties().setProperty("http.proxyHost", string);
        System.getProperties().setProperty("http.proxyPort", string2);
        AppPlugin.warn("Added proxy server info:" + string + ":" + string2);
        AppPlugin.getPlugin().getPluginPreferences().setValue(AppPlugin.HTTP_PROXY_HOST, string);
        AppPlugin.getPlugin().getPluginPreferences().setValue(AppPlugin.HTTP_PROXY_PORT, string2);
        AppPlugin.getPlugin().getPluginPreferences().setValue(AppPlugin.HTTP_PROXY_ENABLE, bl);
        AppPlugin.getPlugin().savePluginPreferences();
    }
}

