/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.DeltaInstallHandler;

public class JarDeltaInstallHandler
extends DeltaInstallHandler {
    protected void overlayPlugin(IPluginEntry iPluginEntry, IPluginEntry iPluginEntry2, IFeatureContentConsumer iFeatureContentConsumer) throws CoreException, IOException {
        if (iPluginEntry2 instanceof PluginEntry && ((PluginEntry)iPluginEntry2).isUnpack()) {
            super.overlayPlugin(iPluginEntry, iPluginEntry2, iFeatureContentConsumer);
        }
        this.oldFeature.getFeatureContentProvider().getPluginEntryContentReferences(iPluginEntry, null);
        this.feature.getFeatureContentProvider().getPluginEntryContentReferences(iPluginEntry2, null);
        URI uRI = null;
        try {
            uRI = new URI(String.valueOf(iFeatureContentConsumer.getFeature().getSite().getURL().getPath()) + "plugins/" + iPluginEntry.getVersionedIdentifier().toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException.getMessage());
        }
        File file = new File(uRI);
        JarFile jarFile = new JarFile(file);
        URI uRI2 = null;
        try {
            uRI2 = new URI(String.valueOf(iFeatureContentConsumer.getFeature().getSite().getURL().getPath()) + "plugins/" + iPluginEntry2.getVersionedIdentifier().toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException.getMessage());
        }
        File file2 = new File(uRI2);
        JarFile jarFile2 = new JarFile(file2);
        String string = uRI + "-" + new Date().getTime();
        File file3 = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        JarDeltaInstallHandler.addToJar(jarOutputStream, jarFile2);
        JarDeltaInstallHandler.addToJar(jarOutputStream, jarFile);
        jarOutputStream.closeEntry();
        jarOutputStream.finish();
        fileOutputStream.close();
        jarFile2.close();
        jarFile.close();
        file2 = new File(uRI2);
        file2.delete();
        file2.createNewFile();
        try {
            FileInputStream fileInputStream = new FileInputStream(file3);
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addToJar(JarOutputStream jarOutputStream, JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            byte[] byArray = new byte[4096];
            int n = 0;
            jarOutputStream.putNextEntry(zipEntry);
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                jarOutputStream.write(byArray, 0, n);
            }
        }
    }
}

