/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFileContentConsumer;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFile
extends Site {
    private List pluginEntries = new ArrayList(0);

    public ISiteContentConsumer createSiteContentConsumer(IFeature iFeature) throws CoreException {
        SiteFileContentConsumer siteFileContentConsumer = new SiteFileContentConsumer(iFeature);
        siteFileContentConsumer.setSite(this);
        return siteFileContentConsumer;
    }

    public String getDefaultPackagedFeatureType() {
        return "org.eclipse.ercp.update.installed";
    }

    public IFeatureReference install(IFeature iFeature, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.install(iFeature, null, iVerificationListener, iProgressMonitor);
    }

    public IFeatureReference install(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iFeature == null) {
            return null;
        }
        InstallMonitor installMonitor = iProgressMonitor == null ? null : (iProgressMonitor instanceof InstallMonitor ? (InstallMonitor)iProgressMonitor : new InstallMonitor(iProgressMonitor));
        IFeature iFeature2 = this.createExecutableFeature(iFeature);
        IFeatureReference iFeatureReference = null;
        iFeatureReference = iFeature.install(iFeature2, iFeatureReferenceArray, iVerificationListener, installMonitor);
        return iFeatureReference;
    }

    public IFeatureReference install(IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IFeatureContentConsumer iFeatureContentConsumer, IVerifier iVerifier, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        if (iFeature == null) {
            return null;
        }
        InstallMonitor installMonitor = iProgressMonitor == null ? null : (iProgressMonitor instanceof InstallMonitor ? (InstallMonitor)iProgressMonitor : new InstallMonitor(iProgressMonitor));
        IFeature iFeature2 = this.createExecutableFeature(iFeature);
        iFeatureContentConsumer.addChild(iFeature2);
        IVerifier iVerifier2 = iFeature.getFeatureContentProvider().getVerifier();
        if (iVerifier2 != null) {
            iVerifier2.setParent(iVerifier);
        }
        IFeatureReference iFeatureReference = null;
        iFeatureReference = iFeature.install(iFeature2, iFeatureReferenceArray, iVerificationListener, installMonitor);
        return iFeatureReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(IFeature var1_1, IProgressMonitor var2_2) throws CoreException {
        block35: {
            if (var1_1 == null) {
                AppPlugin.warn("Feature to remove is null");
                return;
            }
            var3_3 = ErrorRecoveryLog.getLog();
            var4_4 = var2_2 == null ? null : (var2_2 instanceof InstallMonitor != false ? (InstallMonitor)var2_2 : new InstallMonitor(var2_2));
            var5_5 = new InstallHandlerProxy(4, var1_1, var1_1.getInstallHandlerEntry(), var4_4);
            var6_6 = false;
            var7_7 = null;
            try {
                try {
                    var3_3.open("REMOVE_LOG");
                    this.aboutToRemove(var1_1);
                    var3_3.append("END_ABOUT_TO_REMOVE");
                    var5_5.uninstallInitiated();
                    var8_8 = this.getPluginEntriesOnlyReferencedBy(var1_1);
                    if (var4_4 != null) {
                        var4_4.beginTask(NLS.bind((String)Messages.SiteFile_Removing, (Object[])new String[]{var1_1.getLabel()}), var8_8.length + 1);
                    }
                    if ((var9_10 = this.getFeatureReferences()) != null) {
                        var10_11 = 0;
                        while (var10_11 < var9_10.length) {
                            var11_15 = var9_10[var10_11];
                            if (var11_15.getVersionedIdentifier().equals(var1_1.getVersionedIdentifier())) {
                                this.removeFeatureReferenceModel((FeatureReferenceModel)var11_15);
                                break;
                            }
                            ++var10_11;
                        }
                    }
                    if (InstallRegistry.getInstance().get("feature_" + var1_1.getVersionedIdentifier()) == null) {
                        AppPlugin.log(NLS.bind((String)Messages.SiteFile_featureNotRemoved, (Object[])new String[]{var1_1.getVersionedIdentifier().toString()}), null);
                    } else {
                        var10_12 = var1_1.getFeatureContentProvider().getFeatureEntryArchiveReferences(var4_4);
                        var11_16 = 0;
                        while (true) {
                            if (var11_16 >= var10_12.length) {
                                InstallRegistry.unregisterFeature(var1_1);
                                break;
                            }
                            try {
                                UpdateManagerUtils.removeFromFileSystem(var10_12[var11_16].asFile());
                                if (var4_4 != null) {
                                    var4_4.worked(1);
                                }
                            }
                            catch (IOException var12_18) {
                                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFile_CannotRemoveFeature, (Object[])new String[]{var1_1.getVersionedIdentifier().getIdentifier(), this.getURL().toExternalForm()}), var12_18);
                            }
                            ++var11_16;
                        }
                    }
                    var10_13 = 0;
                    while (true) {
                        if (var10_13 >= var8_8.length) break;
                        this.remove(var1_1, var8_8[var10_13], var4_4);
                        ++var10_13;
                    }
                    var10_14 = var1_1.getIncludedFeatureReferences();
                    var11_17 = 0;
                    while (true) {
                        if (var11_17 >= var10_14.length) {
                            this.removeFeatureFromCache(var1_1.getURL());
                            var5_5.completeUninstall();
                            var6_6 = true;
                        }
                        var12_19 = null;
                        try {
                            var12_19 = var10_14[var11_17].getFeature(null);
                        }
                        catch (CoreException v0) {
                            AppPlugin.warn("Unable to retrieve feature to remove for:" + var10_14[var11_17]);
                        }
                        if (var12_19 != null && !this.getCurrentConfiguredSite().isConfigured(var12_19)) {
                            this.remove(var10_14[var11_17].getFeature(null), var4_4);
                        }
                        ++var11_17;
                    }
                }
                catch (Throwable var8_9) {
                    var7_7 = var8_9;
                }
            }
            catch (Throwable var14_20) {
                var13_21 = null;
                var15_23 = null;
                try {
                    if (var6_6) {
                        var3_3.close("END_REMOVE_LOG");
                        var3_3.delete();
                    } else {
                        var3_3.close("END_REMOVE_LOG");
                    }
                    var5_5.uninstallCompleted(var6_6);
                }
                catch (Throwable var16_25) {
                    var15_23 = var16_25;
                }
                if (var7_7 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var1_1.getLabel()}), var7_7);
                }
                if (var15_23 != null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var1_1.getLabel()}), var15_23);
                }
                throw var14_20;
            }
            {
                var13_22 = null;
                var15_24 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 540->576)] { 
lbl95:
            // 1 sources

            if (var6_6) {
                var3_3.close("END_REMOVE_LOG");
                var3_3.delete();
            } else {
                var3_3.close("END_REMOVE_LOG");
            }
            var5_5.uninstallCompleted(var6_6);
            break block35;
lbl102:
            // 1 sources

            catch (Throwable var16_26) {
                var15_24 = var16_26;
            }
        }
        if (var7_7 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var1_1.getLabel()}), var7_7);
        }
        if (var15_24 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{var1_1.getLabel()}), var15_24);
        }
    }

    public long getDownloadSizeFor(IFeature iFeature) {
        long l = 0L;
        IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
        IPluginEntry[] iPluginEntryArray2 = this.getPluginEntries();
        iPluginEntryArray = UpdateManagerUtils.diff(iPluginEntryArray, iPluginEntryArray2);
        INonPluginEntry[] iNonPluginEntryArray = iFeature.getNonPluginEntries();
        try {
            l = iFeature.getFeatureContentProvider().getDownloadSizeFor(iPluginEntryArray, iNonPluginEntryArray);
        }
        catch (CoreException coreException) {
            AppPlugin.warn(null, coreException);
            l = -1L;
        }
        return l;
    }

    public long getInstallSizeFor(IFeature iFeature) {
        long l = 0L;
        try {
            ArrayList<IPluginEntry> arrayList = new ArrayList<IPluginEntry>();
            arrayList.addAll(Arrays.asList(iFeature.getPluginEntries()));
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
            IFeature iFeature2 = null;
            int n = 0;
            while (n < iIncludedFeatureReferenceArray.length) {
                iFeature2 = iIncludedFeatureReferenceArray[n].getFeature(null);
                if (iFeature2 != null) {
                    arrayList.addAll(Arrays.asList(iFeature2.getPluginEntries()));
                }
                ++n;
            }
            IPluginEntry[] iPluginEntryArray = new IPluginEntry[]{};
            if (arrayList.size() > 0) {
                iPluginEntryArray = new IPluginEntry[arrayList.size()];
                arrayList.toArray(iPluginEntryArray);
            }
            IPluginEntry[] iPluginEntryArray2 = this.getPluginEntries();
            iPluginEntryArray = UpdateManagerUtils.diff(iPluginEntryArray, iPluginEntryArray2);
            INonPluginEntry[] iNonPluginEntryArray = iFeature.getNonPluginEntries();
            l = iFeature.getFeatureContentProvider().getInstallSizeFor(iPluginEntryArray, iNonPluginEntryArray);
        }
        catch (CoreException coreException) {
            AppPlugin.warn(null, coreException);
            l = -1L;
        }
        return l;
    }

    public void addPluginEntry(IPluginEntry iPluginEntry) {
        this.pluginEntries.add(iPluginEntry);
    }

    public IPluginEntry[] getPluginEntries() {
        IPluginEntry[] iPluginEntryArray = new IPluginEntry[]{};
        if (this.pluginEntries != null && !this.pluginEntries.isEmpty()) {
            iPluginEntryArray = new IPluginEntry[this.pluginEntries.size()];
            this.pluginEntries.toArray(iPluginEntryArray);
        }
        return iPluginEntryArray;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    private IFeature createExecutableFeature(IFeature iFeature) throws CoreException {
        IFeature iFeature2 = null;
        IFeatureFactory iFeatureFactory = FeatureTypeFactory.getInstance().getFactory("org.eclipse.ercp.update.installed");
        iFeature2 = iFeatureFactory.createFeature(null, this, null);
        ((FeatureModel)((Object)iFeature2)).setFeatureIdentifier(iFeature.getVersionedIdentifier().getIdentifier());
        ((FeatureModel)((Object)iFeature2)).setFeatureVersion(iFeature.getVersionedIdentifier().getVersion().toString());
        return iFeature2;
    }

    private void remove(IFeature iFeature, IPluginEntry iPluginEntry, InstallMonitor installMonitor) throws CoreException {
        if (iPluginEntry == null) {
            return;
        }
        if (InstallRegistry.getInstance().get("plugin_" + iPluginEntry.getVersionedIdentifier()) == null) {
            AppPlugin.log(NLS.bind((String)Messages.SiteFile_pluginNotRemoved, (Object[])new String[]{iPluginEntry.getVersionedIdentifier().toString()}), null);
            return;
        }
        ContentReference[] contentReferenceArray = iFeature.getFeatureContentProvider().getPluginEntryArchiveReferences(iPluginEntry, installMonitor);
        int n = 0;
        while (n < contentReferenceArray.length) {
            try {
                UpdateManagerUtils.removeFromFileSystem(contentReferenceArray[n].asFile());
                if (installMonitor != null) {
                    installMonitor.worked(1);
                }
            }
            catch (IOException iOException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFile_CannotRemovePlugin, (Object[])new String[]{iPluginEntry.getVersionedIdentifier().toString(), this.getURL().toExternalForm()}), iOException);
            }
            ++n;
        }
        this.pluginEntries.remove(iPluginEntry);
        InstallRegistry.unregisterPlugin(iPluginEntry);
    }

    private void aboutToRemove(IFeature iFeature) throws CoreException {
        ErrorRecoveryLog.getLog();
    }
}

