/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteContentProvider;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.xml.sax.SAXException;

public class SiteFileFactory
extends BaseSiteFactory {
    private SiteFile site;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISite createSite(URL uRL) throws CoreException, InvalidSiteTypeException {
        Site site = null;
        InputStream inputStream = null;
        SiteFileFactory siteFileFactory = this;
        try {
            try {
                Object object;
                String string = uRL.getFile();
                File file = new File(string);
                if (file.isDirectory()) {
                    uRL = file.toURL();
                    object = new File(file, "site.xml");
                    if (((File)object).exists()) {
                        inputStream = new FileInputStream((File)object);
                        site = (Site)siteFileFactory.parseSite(inputStream);
                    } else {
                        site = this.parseSite(file);
                    }
                } else {
                    try {
                        object = URLEncoder.encode(uRL);
                        inputStream = this.openStream((URL)object);
                        site = (Site)siteFileFactory.parseSite(inputStream);
                    }
                    catch (IOException iOException) {
                        object = new File(uRL.getFile());
                        File file2 = ((File)object).getParentFile();
                        if (file2 != null && !file2.exists()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_DirectoryDoesNotExist, (Object[])new String[]{((File)object).getAbsolutePath()}), null);
                        }
                        if (file2 == null || !file2.isDirectory()) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToObtainParentDirectory, (Object[])new String[]{((File)object).getAbsolutePath()}), null);
                        }
                        site = this.parseSite(file2);
                    }
                }
                object = new SiteFileContentProvider(uRL);
                site.setSiteContentProvider((ISiteContentProvider)object);
                ((SiteContentProvider)object).setSite(site);
                site.resolve(uRL, uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURL, (Object[])new String[]{uRL == null ? "" : uRL.toExternalForm()}), malformedURLException);
            }
            catch (IOException iOException) {
                throw Utilities.newCoreException(Messages.SiteFileFactory_UnableToAccessSite, 42, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (IOException iOException) {
            return site;
        }
        if (inputStream == null) return site;
        inputStream.close();
        return site;
    }

    private Site parseSite(File file) throws CoreException {
        this.site = (SiteFile)this.createSiteMapModel();
        if (!file.exists()) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_FileDoesNotExist, (Object[])new String[]{file.getAbsolutePath()}), null);
        }
        File file2 = new File(file, "plugins/");
        this.parsePackagedFeature(file);
        this.parsePackagedPlugins(file2);
        this.parseInstalledFeature(file);
        this.parseInstalledPlugins(file2);
        return this.site;
    }

    private void parseInstalledFeature(File file) throws CoreException {
        File file2 = new File(file, "features/");
        if (file2.exists()) {
            String string = null;
            try {
                String[] stringArray = file2.list();
                int n = 0;
                while (n < stringArray.length) {
                    string = String.valueOf(stringArray[n]) + (stringArray[n].endsWith("/") ? "/" : "");
                    File file3 = new File(file2, string);
                    File file4 = new File(file3, "feature.xml");
                    if (!file4.exists()) {
                        AppPlugin.warn("Unable to find feature.xml in directory:" + file3);
                    } else {
                        URL uRL = file3.toURL();
                        SiteFeatureReferenceModel siteFeatureReferenceModel = this.createFeatureReferenceModel();
                        siteFeatureReferenceModel.setSiteModel(this.site);
                        siteFeatureReferenceModel.setURLString(uRL.toExternalForm());
                        siteFeatureReferenceModel.setType("org.eclipse.ercp.update.installed");
                        this.site.addFeatureReferenceModel(siteFeatureReferenceModel);
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{string}), malformedURLException);
            }
        }
    }

    private void parsePackagedFeature(File file) throws CoreException {
        File file2 = new File(file, "features/");
        if (file2.exists()) {
            Object var7_3 = null;
            try {
                String[] stringArray = file2.list(FeaturePackagedContentProvider.filter);
                int n = 0;
                while (n < stringArray.length) {
                    File file3 = new File(file2, stringArray[n]);
                    JarContentReference jarContentReference = new JarContentReference("", file3);
                    ContentReference contentReference = null;
                    try {
                        contentReference = jarContentReference.peek("feature.xml", null, null);
                    }
                    catch (IOException iOException) {
                        AppPlugin.warn("Exception retrieving feature.xml in file:" + file3, iOException);
                    }
                    if (contentReference == null) {
                        AppPlugin.warn("Unable to find feature.xml in file:" + file3);
                    } else {
                        URL uRL = file3.toURL();
                        SiteFeatureReferenceModel siteFeatureReferenceModel = this.createFeatureReferenceModel();
                        siteFeatureReferenceModel.setSiteModel(this.site);
                        siteFeatureReferenceModel.setURLString(uRL.toExternalForm());
                        siteFeatureReferenceModel.setType("org.eclipse.ercp.update.packaged");
                        this.site.addFeatureReferenceModel(siteFeatureReferenceModel);
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{var7_3}), malformedURLException);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseInstalledPlugins(File file) throws CoreException {
        if (!file.exists()) return;
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        DefaultPluginParser defaultPluginParser = new DefaultPluginParser();
        int n = 0;
        while (true) {
            block16: {
                Object var9_11;
                if (n >= fileArray.length) {
                    return;
                }
                File file2 = new File(fileArray[n], "META-INF/MANIFEST.MF");
                InputStream inputStream = null;
                try {
                    Object object;
                    try {
                        BundleManifest bundleManifest = new BundleManifest(file2);
                        if (bundleManifest.exists()) {
                            object = bundleManifest.getPluginEntry();
                            this.addParsedPlugin((PluginEntry)object, fileArray[n]);
                        } else {
                            file2 = new File(fileArray[n], "plugin.xml");
                            if (!file2.exists()) {
                                file2 = new File(fileArray[n], "fragment.xml");
                            }
                            if (file2 != null && file2.exists() && !file2.isDirectory()) {
                                inputStream = new FileInputStream(file2);
                                object = defaultPluginParser.parse(inputStream);
                                this.addParsedPlugin((PluginEntry)object, fileArray[n]);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        object = file2 == null ? null : file2.getAbsolutePath();
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{object}), iOException);
                    }
                    catch (SAXException sAXException) {
                        object = file2 == null ? null : file2.getAbsolutePath();
                        throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{object}), sAXException);
                    }
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var9_11 = null;
                    if (inputStream == null) break block16;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
            ++n;
        }
    }

    private void addParsedPlugin(PluginEntry pluginEntry, File file) throws CoreException {
        String string = null;
        try {
            if (pluginEntry != null) {
                ((Site)this.site).addPluginEntry(pluginEntry);
                ArchiveReferenceModel archiveReferenceModel = this.createArchiveReferenceModel();
                String string2 = pluginEntry.getVersionedIdentifier().toString();
                String string3 = "plugins/" + string2 + ".jar";
                archiveReferenceModel.setPath(string3);
                string = file.toURL().toExternalForm();
                archiveReferenceModel.setURLString(string);
                this.site.addArchiveReferenceModel(archiveReferenceModel);
                if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                    AppPlugin.debug("Added archive to site:" + string3 + " pointing to: " + string);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_UnableToCreateURLForFile, (Object[])new String[]{string}), malformedURLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePackagedPlugins(File file) throws CoreException {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list(FeaturePackagedContentProvider.filter);
        int n = 0;
        while (n < stringArray.length) {
            block28: {
                JarContentReference jarContentReference;
                block29: {
                    Object var10_12;
                    jarContentReference = null;
                    ContentReference contentReference = null;
                    String string = null;
                    InputStream inputStream = null;
                    try {
                        try {
                            Object object;
                            File file2 = new File(file, stringArray[n]);
                            jarContentReference = new JarContentReference(null, file2);
                            contentReference = jarContentReference.peek("META-INF/MANIFEST.MF", null, null);
                            if (contentReference != null && ((BundleManifest)(object = new BundleManifest(inputStream = contentReference.getInputStream()))).exists()) {
                                this.addParsedPlugin(((BundleManifest)object).getPluginEntry(), file2);
                                var10_12 = null;
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if ("unknown".equalsIgnoreCase(Platform.getOS()) && jarContentReference != null) {
                                    try {
                                        jarContentReference.closeArchive();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block28;
                            }
                            contentReference = jarContentReference.peek("plugin.xml", null, null);
                            if (contentReference == null) {
                                contentReference = jarContentReference.peek("fragment.xml", null, null);
                            }
                            if (contentReference != null) {
                                inputStream = contentReference.getInputStream();
                                object = new DefaultPluginParser().parse(inputStream);
                                this.addParsedPlugin((PluginEntry)object, file2);
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                string = contentReference == null ? null : contentReference.asURL().toExternalForm();
                                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{string}), iOException);
                            }
                            catch (IOException iOException2) {}
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorAccessing, (Object[])new String[]{string}), iOException);
                        }
                        catch (SAXException sAXException) {
                            try {
                                string = contentReference == null ? null : contentReference.asURL().toExternalForm();
                                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{string}), sAXException);
                            }
                            catch (IOException iOException) {}
                            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileFactory_ErrorParsingFile, (Object[])new String[]{string}), sAXException);
                        }
                        var10_12 = null;
                        if (inputStream == null) break block29;
                    }
                    catch (Throwable throwable) {
                        var10_12 = null;
                        if (inputStream != null) {
                            try {}
                            catch (IOException iOException) {}
                            inputStream.close();
                        }
                        if (!"unknown".equalsIgnoreCase(Platform.getOS())) throw throwable;
                        if (jarContentReference == null) throw throwable;
                        try {}
                        catch (IOException iOException) {}
                        jarContentReference.closeArchive();
                        throw throwable;
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
                if ("unknown".equalsIgnoreCase(Platform.getOS()) && jarContentReference != null) {
                    try {}
                    catch (IOException iOException) {}
                    jarContentReference.closeArchive();
                }
            }
            ++n;
        }
    }

    public SiteModel createSiteMapModel() {
        return new SiteFile();
    }

    public boolean canParseSiteType(String string) {
        return super.canParseSiteType(string) || "org.eclipse.ercp.update.file".equalsIgnoreCase(string);
    }
}

