/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class SiteLocalModel
extends ModelObject {
    public static final String CONFIG_FILE = "platform.xml";
    private long stamp;
    private String label;
    private URL location;
    private String locationURLString;
    private int history = AppPlugin.DEFAULT_HISTORY;
    private List configurations;
    private List preservedConfigurations;
    private InstallConfigurationModel currentConfiguration;

    public InstallConfigurationModel getCurrentConfigurationModel() {
        return this.currentConfiguration;
    }

    public InstallConfigurationModel[] getConfigurationHistoryModel() {
        if (this.configurations == null) {
            this.processHistory();
        }
        if (this.configurations == null || this.configurations.size() == 0) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.configurations.toArray(this.arrayTypeFor(this.configurations));
    }

    public void addConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        if (installConfigurationModel != null) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            if (!this.configurations.contains((Object)installConfigurationModel)) {
                this.configurations.add(installConfigurationModel);
            }
        }
    }

    public boolean removeConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        if (installConfigurationModel != null) {
            return this.configurations.remove((Object)installConfigurationModel);
        }
        return false;
    }

    public URL getLocationURL() {
        return this.location;
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public void setLocationURLString(String string) {
        this.assertIsWriteable();
        this.locationURLString = string;
        this.location = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.assertIsWriteable();
        this.label = string;
    }

    public int getMaximumHistoryCount() {
        return this.history;
    }

    public void setMaximumHistoryCount(int n) {
        this.assertIsWriteable();
        this.history = n;
    }

    public void addPreservedInstallConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        if (this.preservedConfigurations == null) {
            this.preservedConfigurations = new ArrayList();
        }
        this.preservedConfigurations.add(installConfigurationModel);
    }

    public boolean removePreservedConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        if (this.preservedConfigurations != null) {
            return this.preservedConfigurations.remove((Object)installConfigurationModel);
        }
        return false;
    }

    public InstallConfigurationModel[] getPreservedConfigurationsModel() {
        if (this.preservedConfigurations == null || this.preservedConfigurations.isEmpty()) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.preservedConfigurations.toArray(this.arrayTypeFor(this.preservedConfigurations));
    }

    public void setCurrentConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        this.assertIsWriteable();
        this.currentConfiguration = installConfigurationModel;
        ConfiguredSiteModel[] configuredSiteModelArray = installConfigurationModel.getConfigurationSitesModel();
        int n = 0;
        while (n < configuredSiteModelArray.length) {
            configuredSiteModelArray[n].getSiteModel().setConfiguredSiteModel(configuredSiteModelArray[n]);
            ++n;
        }
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.location = this.resolveURL(uRL, uRL2, this.getLocationURLString());
        this.resolveListReference(this.getConfigurationHistoryModel(), uRL, uRL2);
        this.resolveListReference(this.getPreservedConfigurationsModel(), uRL, uRL2);
        this.resolveReference(this.getCurrentConfigurationModel(), uRL, uRL2);
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setStamp(long l) {
        this.stamp = l;
    }

    protected String getPropertyName() {
        return "platform";
    }

    private void processHistory() {
        try {
            URL uRL = new URL(this.getLocationURL(), "history");
            uRL = Platform.asLocalURL((URL)uRL);
            File file = new File(uRL.getFile());
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                BaseSiteLocalFactory baseSiteLocalFactory = new BaseSiteLocalFactory();
                int n = 0;
                while (n < fileArray.length) {
                    String string = fileArray[n].getName();
                    if (string.endsWith(".xml")) {
                        string = string.substring(0, string.length() - 4);
                        Date date = new Date(Long.parseLong(string));
                        InstallConfigurationModel installConfigurationModel = baseSiteLocalFactory.createInstallConfigurationModel();
                        installConfigurationModel.setLocationURLString(fileArray[n].getAbsolutePath().replace('\\', '/'));
                        installConfigurationModel.setLabel(date.toString());
                        installConfigurationModel.setCreationDate(date);
                        installConfigurationModel.resolve(fileArray[n].toURL(), this.getResourceBundleURL());
                        this.addConfigurationModel(installConfigurationModel);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            AppPlugin.warn("Error processing history: ", exception);
        }
    }

    URL getResourceBundleURL() throws CoreException {
        URL uRL = null;
        try {
            uRL = UpdateManagerUtils.asDirectoryURL(this.getLocationURL());
        }
        catch (MissingResourceException missingResourceException) {
            AppPlugin.warn(String.valueOf(missingResourceException.getLocalizedMessage()) + ":" + uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            AppPlugin.warn(malformedURLException.getLocalizedMessage());
        }
        return uRL;
    }
}

