/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class SiteSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries = new IUpdateSearchQuery[]{new Query()};
    private static final String CATEGORY_ID = "org.eclipse.ercp.update.unified-search";

    public SiteSearchCategory() {
        super(CATEGORY_ID);
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    private static class Query
    implements IUpdateSearchQuery {
        private Query() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ISite iSite, String[] stringArray, IUpdateSearchFilter iUpdateSearchFilter, IUpdateSearchResultCollector iUpdateSearchResultCollector, IProgressMonitor iProgressMonitor) {
            ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
            HashSet<String> hashSet = new HashSet<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    hashSet.add(stringArray[n]);
                    ++n;
                }
            }
            ArrayList<ISiteFeatureReference> arrayList = new ArrayList<ISiteFeatureReference>(Arrays.asList(iSiteFeatureReferenceArray));
            iProgressMonitor.beginTask("", iSiteFeatureReferenceArray.length);
            ThreadGroup threadGroup = new ThreadGroup("FeatureDownloader");
            int n = iSiteFeatureReferenceArray.length > 5 ? 5 : iSiteFeatureReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Thread thread = new Thread(threadGroup, new FeatureDownloader(arrayList, iUpdateSearchResultCollector, iUpdateSearchFilter, hashSet, iProgressMonitor));
                thread.start();
                ++n2;
            }
            while (threadGroup.activeCount() != 0) {
                if (iProgressMonitor.isCanceled()) {
                    ArrayList<ISiteFeatureReference> arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.clear();
                    }
                }
                Thread[] threadArray = new Thread[threadGroup.activeCount()];
                threadGroup.enumerate(threadArray);
                if (threadArray[0] == null) continue;
                try {
                    threadArray[0].join(250L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }

    private static class FeatureDownloader
    implements Runnable {
        private List siteFeatureReferences;
        private IProgressMonitor monitor;
        private IUpdateSearchFilter filter;
        private IUpdateSearchResultCollector collector;
        private HashSet ignores;

        private FeatureDownloader() {
        }

        public FeatureDownloader(List list, IUpdateSearchResultCollector iUpdateSearchResultCollector, IUpdateSearchFilter iUpdateSearchFilter, HashSet hashSet, IProgressMonitor iProgressMonitor) {
            this.collector = iUpdateSearchResultCollector;
            this.filter = iUpdateSearchFilter;
            this.ignores = hashSet;
            this.monitor = iProgressMonitor;
            this.siteFeatureReferences = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ISiteFeatureReference iSiteFeatureReference = null;
            while (this.siteFeatureReferences.size() != 0) {
                ICategory iCategory;
                Object object;
                List list = this.siteFeatureReferences;
                synchronized (list) {
                    iSiteFeatureReference = this.siteFeatureReferences.size() != 0 ? (ISiteFeatureReference)this.siteFeatureReferences.remove(0) : null;
                }
                if (iSiteFeatureReference == null) continue;
                boolean bl = false;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (this.ignores.size() > 0) {
                    object = iSiteFeatureReference.getCategories();
                    int n = 0;
                    while (n < ((ICategory[])object).length) {
                        iCategory = object[n];
                        if (this.ignores.contains(iCategory.getName())) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                try {
                    block17: {
                        try {
                            if (bl || !this.filter.accept(iSiteFeatureReference)) break block17;
                            object = iSiteFeatureReference.getFeature(null);
                            List list2 = this.siteFeatureReferences;
                            synchronized (list2) {
                                if (this.filter.accept((IFeature)object)) {
                                    this.collector.accept((IFeature)object);
                                }
                                this.monitor.subTask(object.getLabel());
                            }
                        }
                        catch (CoreException coreException) {
                            System.out.println((Object)coreException);
                        }
                    }
                    iCategory = null;
                }
                catch (Throwable throwable) {
                    iCategory = null;
                    this.monitor.worked(1);
                    throw throwable;
                }
                this.monitor.worked(1);
            }
        }
    }
}

