/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class DateEditor
extends Control {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    public static final int DURATION = 4;
    public static final int OFFSET = 5;
    public static final int COMPACT = 16;
    public static final int FULL = 32;
    boolean isDispose = false;
    private static int fdateEditorStyleS;
    private int fdateEditorStyle;
    private TimeZone fTimeZone = null;
    Date fDate;
    Date fCachedDate;
    static Object fLock;
    static boolean isInit;
    int offset;
    int sign = 1;
    int fTime;
    int fCachedTime;
    int order = -1;
    String separator;
    Composite fparent;

    public DateEditor(Composite parent, int style) {
        this(parent, style, 1);
    }

    public DateEditor(Composite parent, int style, int dateEditorStyle) {
        super(parent, DateEditor.setAndPassStyle(style, dateEditorStyle));
        this.fparent = parent;
        if (parent == null) {
            SWT.error(4);
        }
        dateEditorStyle &= 0xFFFFFFDF;
        if ((dateEditorStyle &= 0xFFFFFFEF) != 1 && dateEditorStyle != 2 && dateEditorStyle != 3 && dateEditorStyle != 4 && dateEditorStyle != 5) {
            SWT.error(5);
        }
        this.fdateEditorStyle = dateEditorStyle & 0xF;
        this.setFormatStrings();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.fDate = this.getDate();
        if (this.fdateEditorStyle == 5 || this.fdateEditorStyle == 4) {
            this.setTime(0);
        }
        this.fTime = this.getTime();
        Object object = fLock;
        synchronized (object) {
            if (!isInit) {
                com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 30, "org/eclipse/ercp/swt/mobile/DateEditor", "dateEditorCallback");
                isInit = true;
            }
        }
    }

    Calendar getCalendar() {
        return this.fTimeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.fTimeZone);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Date getDate() {
        this.checkWidget();
        Calendar c = this.getCalendar();
        int[] date_time = new int[6];
        OS.DateTime_GetSystemTime(this.internal_handle, date_time);
        switch (this.fdateEditorStyle) {
            case 1: {
                c.set(1, date_time[0]);
                c.set(2, date_time[1] - 1);
                c.set(5, date_time[2]);
                break;
            }
            case 4: 
            case 5: {
                return null;
            }
            case 2: 
            case 3: {
                c.set(1, date_time[0]);
                c.set(2, date_time[1] - 1);
                c.set(5, date_time[2]);
                c.set(11, date_time[3]);
                c.set(12, date_time[4]);
                c.set(13, date_time[5]);
            }
        }
        System.out.println("c.getTime = " + c.getTime());
        return this.adjustDate(c.getTime());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int[] size = OS.DateEditor_ComputeSize(this.internal_handle, this.fdateEditorStyle);
        return new Point(size[0], size[1]);
    }

    public int getTime() {
        this.checkWidget();
        switch (this.fdateEditorStyle) {
            case 2: 
            case 4: 
            case 5: {
                Calendar c = this.getCalendar();
                int[] time = new int[6];
                OS.DateTime_GetSystemTime(this.internal_handle, time);
                this.offset = time[3] * 3600 + time[4] * 60 + time[5];
                return this.offset;
            }
        }
        return 0;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.removeListener(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setDate(Date date) {
        this.checkWidget();
        if (date == null) {
            SWT.error(4);
        }
        Calendar calendar = null;
        if (date != null) {
            calendar = this.getCalendar();
            calendar.setTime(date);
        }
        this.setDate(calendar);
        this.dateEditorCallback(0, 2);
    }

    void setDate(Calendar c) {
        if (c != null) {
            short[] systemTime = new short[]{(short)c.get(1), (short)(c.get(2) + 1), (short)(c.get(7) + -1), (short)c.get(5), (short)c.get(11), (short)c.get(12), (short)c.get(13), (short)c.get(14)};
            OS.SendMessageW(this.internal_handle, 4098, 0, systemTime);
        } else {
            this.fDate = null;
        }
        this.setFormatStrings();
    }

    public void setTime(int seconds) {
        this.checkWidget();
        if (this.fdateEditorStyle == 5 && (seconds > 86399 || seconds < -86399)) {
            SWT.error(5);
        }
        if (!(this.fdateEditorStyle != 2 && this.fdateEditorStyle != 4 || seconds <= 86399 && seconds >= 0)) {
            SWT.error(5);
        }
        this.checkWidget();
        if (this.fdateEditorStyle == 2 || this.fdateEditorStyle == 4 || this.fdateEditorStyle == 5) {
            this.offset = seconds;
            Calendar c = this.getCalendar();
            if (this.offset < 0) {
                this.sign = -1;
                this.offset *= this.sign;
            } else {
                this.sign = 1;
            }
            int hour = this.offset / 3600;
            int minute = this.offset % 3600 / 60;
            int second = this.offset % 3600 % 60;
            if (c != null) {
                c.set(11, hour);
                c.set(12, minute);
                c.set(13, second);
                this.setTime(c);
            }
        }
    }

    void setTime(Calendar c) {
        if (c != null) {
            short[] systemTime = new short[]{(short)c.get(1), (short)(c.get(2) + 1), (short)(c.get(7) + -1), (short)c.get(5), (short)c.get(11), (short)c.get(12), (short)c.get(13), (short)c.get(14)};
            OS.SendMessageW(this.internal_handle, 4098, 0, systemTime);
        } else {
            this.fDate = null;
        }
        this.setFormatStrings();
        this.dateEditorCallback(0, 2);
    }

    void setFormatStrings() {
        String Date2 = this.getDateFormat();
        String Time = this.getTimeFormat();
        switch (this.fdateEditorStyle) {
            case 1: {
                OS.SendMessageW(this.internal_handle, 4146, 0, Date2);
                break;
            }
            case 2: {
                OS.SendMessageW(this.internal_handle, 4146, 0, Time);
                break;
            }
            case 4: 
            case 5: {
                if (this.sign == 1) {
                    OS.SendMessageW(this.internal_handle, 4146, 0, "HH':'mm':'ss");
                    break;
                }
                OS.SendMessageW(this.internal_handle, 4146, 0, "-HH':'mm':'ss");
                break;
            }
            case 3: {
                OS.SendMessageW(this.internal_handle, 4146, 0, Date2 + " " + Time);
                break;
            }
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.checkWidget();
        this.fTimeZone = timeZone;
    }

    public void internal_createHandle(int index) {
        this.internal_handle = OS.DateEditor_New(this.internal_parent.internal_handle, super.internal_getNativeStyle(), this.getFlags());
        if (this.internal_handle == 0) {
            throw new OutOfMemoryError();
        }
    }

    public void dispose() {
        super.dispose();
        this.isDispose = true;
    }

    public boolean isDispose() {
        return this.isDispose;
    }

    private static int setAndPassStyle(int parentStyle, int childStyle) {
        fdateEditorStyleS = (childStyle & 0xF) > 3 ? 2 : childStyle & 0xF;
        return parentStyle;
    }

    int getFlags() {
        int bits = 0x50800000;
        switch (fdateEditorStyleS) {
            case 1: {
                bits |= 0;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                bits = bits | 9 | 1;
                break;
            }
            case 3: {
                bits = bits | 0 | 1;
            }
        }
        return bits;
    }

    Date adjustDate(Date returnValue) {
        if (returnValue != null) {
            Calendar currentTime = this.getCalendar();
            currentTime.setTime(returnValue);
            currentTime.set(14, 0);
            returnValue = currentTime.getTime();
        }
        return returnValue;
    }

    private String getTimeFormat() {
        return OS.DateTime_GetTimeFormat(this.internal_handle);
    }

    private String getDateFormat() {
        return OS.DateTime_GetDateFormat(this.internal_handle);
    }

    private String getTimeSeparator() {
        return OS.DateTime_GetTimeSeparator(this.internal_handle);
    }

    private String getDateSeparator() {
        return OS.DateTime_GetDateSeparator(this.internal_handle);
    }

    private void dateEditorCallback(int index, int type) {
        switch (type) {
            case 1: {
                this.internal_sendEvent(13);
                this.internal_sendEvent(14);
                break;
            }
            case 2: {
                if (this.fdateEditorStyle == 1 || this.fdateEditorStyle == 3) {
                    this.fCachedDate = this.getDate();
                    if (this.fCachedDate.equals(this.fDate)) break;
                    this.fDate = this.fCachedDate;
                    this.internal_sendEvent(24);
                    break;
                }
                this.fCachedTime = this.getTime();
                if (this.fCachedTime == this.fTime) break;
                this.fTime = this.fCachedTime;
                this.internal_sendEvent(24);
            }
        }
    }

    static {
        fLock = new Object();
        isInit = false;
    }
}

