/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import com.ibm.ugl.eswt.expanded.OS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Browser
extends Composite {
    private List locationListeners;
    private List progressListeners;
    private List statusListeners;
    private List titleListeners;
    private static Object fLock = new Object();
    private static boolean eventsRegistered;
    boolean In_or_Out = false;
    private FocusThread focusThread;
    private Listener threadFocusListener;
    private Listener focusListener;

    public Browser(Composite parent, int style) {
        super(parent, style);
        if (!eventsRegistered) {
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1748788638, "org/eclipse/swt/browser/Browser", "titleChanged");
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1617659889, "org/eclipse/swt/browser/Browser", "statusTextChanged");
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 2129896520, "org/eclipse/swt/browser/Browser", "progressCallback");
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 874900120, "org/eclipse/swt/browser/Browser", "locationChanging");
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(this.getDisplay().internal_handle, 1275148711, "org/eclipse/swt/browser/Browser", "locationChanged");
            eventsRegistered = true;
        }
        final Browser browserTemp = this;
        this.focusThread = new FocusThread(this.getDisplay());
        Thread th = new Thread(this.focusThread);
        th.start();
        this.threadFocusListener = new Listener(){

            public void handleEvent(Event event) {
                if (Browser.this.focusThread != null && ((Browser)Browser.this).focusThread.In_or_Out && event.widget != browserTemp) {
                    Browser.this.internal_sendEvent(16);
                }
            }
        };
        this.focusListener = new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                if (Browser.this.focusThread != null && ((Browser)Browser.this).focusThread.In_or_Out && event.widget != browserTemp) {
                    Browser.this.internal_sendEvent(16);
                }
                event.doit = true;
            }
        };
        this.getDisplay().addFilter(27, this.threadFocusListener);
        this.getDisplay().addFilter(15, this.focusListener);
        this.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent e) {
                Object object = fLock;
                synchronized (object) {
                    if (Browser.this.focusThread != null) {
                        Browser.this.focusThread.setActive(false);
                        Browser.this.focusThread = null;
                    }
                }
            }
        });
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.Browser_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
        if (this.internal_handle == 0) {
            SWT.error(2);
        }
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners == null) {
            this.locationListeners = new ArrayList();
        }
        this.locationListeners.add(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList();
        }
        this.progressListeners.add(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusListeners == null) {
            this.statusListeners = new ArrayList();
        }
        this.statusListeners.add(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners == null) {
            this.titleListeners = new ArrayList();
        }
        this.titleListeners.add(listener);
    }

    private boolean locationChanging(String location) {
        if (this.locationListeners == null) {
            return true;
        }
        LocationEvent event = new LocationEvent(this);
        event.doit = true;
        event.location = location;
        event.widget = this;
        event.display = this.getDisplay();
        event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
        int listenerCount = this.locationListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            LocationListener listener = (LocationListener)this.locationListeners.get(i);
            listener.changing(event);
        }
        return event.doit;
    }

    private void locationChanged(String location, boolean isTop) {
        if (this.locationListeners != null) {
            LocationEvent event = new LocationEvent(this);
            event.location = location;
            event.top = isTop;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.locationListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                LocationListener listener = (LocationListener)this.locationListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void titleChanged(String title) {
        if (this.titleListeners != null) {
            TitleEvent event = new TitleEvent(this);
            event.title = title;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.titleListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                TitleListener listener = (TitleListener)this.titleListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void statusTextChanged(String statusText) {
        if (this.statusListeners != null) {
            StatusTextEvent event = new StatusTextEvent(this);
            event.text = statusText;
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.statusListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                StatusTextListener listener = (StatusTextListener)this.statusListeners.get(i);
                listener.changed(event);
            }
        }
    }

    private void progressCallback(int value, int max) {
        if (this.progressListeners != null) {
            ProgressEvent event = new ProgressEvent(this);
            if (value != max) {
                event.current = value;
                event.total = max;
            }
            event.widget = this;
            event.display = this.getDisplay();
            event.time = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
            int listenerCount = this.progressListeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                ProgressListener listener = (ProgressListener)this.progressListeners.get(i);
                if (value != max) {
                    listener.changed(event);
                    continue;
                }
                listener.completed(event);
            }
        }
    }

    public boolean back() {
        this.checkWidget();
        return OS.Browser_Back(this.internal_handle);
    }

    public boolean forward() {
        this.checkWidget();
        return OS.Browser_Forward(this.internal_handle);
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return OS.Browser_IsBackEnabled(this.internal_handle);
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return OS.Browser_IsForwardEnabled(this.internal_handle);
    }

    public String getUrl() {
        this.checkWidget();
        String result = OS.Browser_GetURL(this.internal_handle);
        return result == null ? "" : result;
    }

    public void refresh() {
        this.checkWidget();
        OS.Browser_Refresh(this.internal_handle);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners != null) {
            this.locationListeners.remove(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusListeners != null) {
            this.statusListeners.remove(listener);
        }
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners != null) {
            this.titleListeners.remove(listener);
        }
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        return OS.Browser_SetText(this.internal_handle, html);
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        return OS.Browser_SetURL(this.internal_handle, url);
    }

    public void stop() {
        this.checkWidget();
        OS.Browser_Stop(this.internal_handle);
    }

    protected void removeInternalFilter() {
        this.getDisplay().removeFilter(27, this.threadFocusListener);
        this.getDisplay().removeFilter(15, this.focusListener);
    }

    private class FocusThread
    implements Runnable {
        Display display;
        long sleepTime = 100L;
        boolean active = true;
        public boolean In_or_Out = false;

        public FocusThread(Display display) {
            this.display = display;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    return;
                }
                try {
                    if (this.display == null || this.display.isDisposed()) continue;
                    this.display.asyncExec(new Runnable(this){
                        private final /* synthetic */ FocusThread this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = Browser.access$300();
                            synchronized (object) {
                                this.this$1.In_or_Out = OS.checkFocus(FocusThread.access$400((FocusThread)this.this$1).internal_handle);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    return;
                }
            }
        }

        static /* synthetic */ Browser access$400(FocusThread x0) {
            return x0.Browser.this;
        }
    }
}

