/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    private Image image;
    private String text = "";

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 2) != 0) {
            if ((this.internal_style & 0x200) != 0) {
                nativeStyle |= 8;
            } else if ((this.internal_style & 0x100) != 0) {
                nativeStyle |= 0x10;
            }
            if ((this.internal_style & 4) != 0) {
                nativeStyle |= 0x20;
            } else if ((this.internal_style & 8) != 0) {
                nativeStyle |= 0x40;
            } else if ((this.internal_style & 0x20) != 0) {
                nativeStyle |= 0x80;
            }
        } else {
            nativeStyle |= 1;
            if ((this.internal_style & 0x40) != 0) {
                nativeStyle |= 0x100;
            }
        }
        return nativeStyle;
    }

    protected void internal_createHandle(int index) {
        int nativeStyle = this.internal_getNativeStyle();
        if ((this.internal_style & 2) != 0) {
            this.internal_handle = OS.Separator_New(this.internal_parent.internal_handle, nativeStyle);
        } else {
            this.internal_handle = OS.Label_New(this.internal_parent.internal_handle, nativeStyle);
            this.setNativeAlignment();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && (this.internal_style & 0x40) == 64) {
            this.checkWidget();
            int[] pointArray = OS.Label_GetMinimumSize(this.internal_handle, wHint);
            return new Point(pointArray[0], pointArray[1]);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.internal_style & 2) != 0) {
            return 0;
        }
        return this.internal_style & 0x1024000;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getText() {
        this.checkWidget();
        if ((this.internal_style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.internal_style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.internal_style &= 0xFEFDBFFF;
        this.internal_style |= alignment & 0x1024000;
        this.setNativeAlignment();
    }

    private void setNativeAlignment() {
        int alignment = 1;
        if ((this.internal_style & 0x20000) == 131072) {
            alignment = 4;
        }
        if ((this.internal_style & 0x1000000) == 0x1000000) {
            alignment = 2;
        }
        OS.Label_SetAlignment(this.internal_handle, alignment);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        int imageHandle = image == null ? 0 : image.internal_handle;
        OS.Label_SetImage(this.internal_handle, imageHandle);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Label.error(4);
        }
        if ((this.internal_style & 2) != 0) {
            return;
        }
        this.text = string;
        OS.Label_SetText(this.internal_handle, string);
        OS.Label_SetImage(this.internal_handle, 0);
    }
}

