/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences.legacy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceForwarder
extends Preferences
implements IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final byte[] BYTE_ARRAY_DEFAULT_DEFAULT = new byte[0];
    PreferencesService a;
    private IEclipsePreferences pluginRoot = (IEclipsePreferences)PreferencesService.getDefault().getRootNode().node("instance");
    private DefaultPreferences defaultsRoot = (DefaultPreferences)PreferencesService.getDefault().getRootNode().node("default");
    private String pluginID;
    private Object plugin;
    private boolean notify = true;

    public PreferenceForwarder(String string) {
        this(null, string);
    }

    public PreferenceForwarder(Object object, String string) {
        this.plugin = object;
        this.pluginID = string;
    }

    public synchronized void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
        if (this.listeners.size() > 0 && this.pluginID.equals(nodeChangeEvent.getChild().name())) {
            try {
                EclipsePreferences eclipsePreferences = (EclipsePreferences)nodeChangeEvent.getChild();
                eclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + classCastException.getMessage());
            }
        }
    }

    public synchronized void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
        if (this.listeners.size() > 0 && this.pluginID.equals(nodeChangeEvent.getChild().name())) {
            try {
                EclipsePreferences eclipsePreferences = (EclipsePreferences)nodeChangeEvent.getChild();
                eclipsePreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + classCastException.getMessage());
            }
        }
    }

    public synchronized void addPropertyChangeListener(Preferences.IPropertyChangeListener iPropertyChangeListener) {
        if (this.listeners.size() == 0) {
            EclipsePreferences eclipsePreferences = this.getPluginPreferences(false);
            if (eclipsePreferences != null) {
                eclipsePreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
            this.pluginRoot.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
        }
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (!this.notify) {
            return;
        }
        Object object = preferenceChangeEvent.getOldValue();
        Object object2 = preferenceChangeEvent.getNewValue();
        String string = preferenceChangeEvent.getKey();
        if (object2 == null) {
            object2 = this.getDefault(string, object);
        } else if (object == null) {
            object = this.getDefault(string, object2);
        }
        this.firePropertyChangeEvent(string, object, object2);
    }

    private EclipsePreferences getPluginPreferences(boolean bl) {
        try {
            if (!bl && !this.pluginRoot.nodeExists(this.pluginID)) {
                return null;
            }
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
        try {
            return (EclipsePreferences)this.pluginRoot.node(this.pluginID);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + classCastException.getMessage());
        }
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultsRoot.node(this.pluginID, this.plugin);
    }

    public synchronized void removePropertyChangeListener(Preferences.IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
        if (this.listeners.size() == 0) {
            EclipsePreferences eclipsePreferences = this.getPluginPreferences(false);
            if (eclipsePreferences != null) {
                eclipsePreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
            this.pluginRoot.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
        }
    }

    private Object getDefault(String string, Object object) {
        IEclipsePreferences iEclipsePreferences = this.getDefaultPreferences();
        if (object instanceof String) {
            return iEclipsePreferences.get(string, "");
        }
        if (object instanceof Integer) {
            return new Integer(iEclipsePreferences.getInt(string, 0));
        }
        if (object instanceof Double) {
            return new Double(iEclipsePreferences.getDouble(string, 0.0));
        }
        if (object instanceof Float) {
            return new Float(iEclipsePreferences.getFloat(string, 0.0f));
        }
        if (object instanceof Long) {
            return new Long(iEclipsePreferences.getLong(string, 0L));
        }
        if (object instanceof byte[]) {
            return iEclipsePreferences.getByteArray(string, BYTE_ARRAY_DEFAULT_DEFAULT);
        }
        if (object instanceof Boolean) {
            return iEclipsePreferences.getBoolean(string, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        String string2 = this.getPluginPreferences(true).get(string, null);
        if (string2 != null) {
            return true;
        }
        return this.getDefaultPreferences().get(string, null) != null;
    }

    public boolean getBoolean(String string) {
        return this.getPluginPreferences(true).getBoolean(string, this.getDefaultPreferences().getBoolean(string, false));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, boolean bl) {
        Boolean bl2;
        Boolean bl3 = this.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (bl2 == bl3) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultBoolean(string) == bl) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).putBoolean(string, bl);
            }
            this.firePropertyChangeEvent(string, bl3, bl2);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.notify = true;
            return;
        }
    }

    public boolean getDefaultBoolean(String string) {
        return this.getDefaultPreferences().getBoolean(string, false);
    }

    public void setDefault(String string, boolean bl) {
        this.getDefaultPreferences().putBoolean(string, bl);
    }

    public double getDouble(String string) {
        return this.getPluginPreferences(true).getDouble(string, this.getDefaultPreferences().getDouble(string, 0.0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException();
        }
        double d2 = this.getDouble(string);
        if (d == d2) {
            return;
        }
        Double d3 = new Double(d2);
        Double d4 = new Double(d);
        try {
            this.notify = false;
            if (this.getDefaultDouble(string) == d) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).putDouble(string, d);
            }
            this.firePropertyChangeEvent(string, d3, d4);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var8_8 = null;
            this.notify = true;
            return;
        }
    }

    public double getDefaultDouble(String string) {
        return this.getDefaultPreferences().getDouble(string, 0.0);
    }

    public void setDefault(String string, double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putDouble(string, d);
    }

    public float getFloat(String string) {
        return this.getPluginPreferences(true).getFloat(string, this.getDefaultPreferences().getFloat(string, 0.0f));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException();
        }
        float f2 = this.getFloat(string);
        if (f == f2) {
            return;
        }
        Float f3 = new Float(f2);
        Float f4 = new Float(f);
        try {
            this.notify = false;
            if (this.getDefaultFloat(string) == f) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).putFloat(string, f);
            }
            this.firePropertyChangeEvent(string, f3, f4);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.notify = true;
            return;
        }
    }

    public float getDefaultFloat(String string) {
        return this.getDefaultPreferences().getFloat(string, 0.0f);
    }

    public void setDefault(String string, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putFloat(string, f);
    }

    public int getInt(String string) {
        return this.getPluginPreferences(true).getInt(string, this.getDefaultPreferences().getInt(string, 0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n == n2) {
            return;
        }
        Integer n3 = new Integer(n2);
        Integer n4 = new Integer(n);
        try {
            this.notify = false;
            if (this.getDefaultInt(string) == n) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).putInt(string, n);
            }
            this.firePropertyChangeEvent(string, n3, n4);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.notify = true;
            return;
        }
    }

    public int getDefaultInt(String string) {
        return this.getDefaultPreferences().getInt(string, 0);
    }

    public void setDefault(String string, int n) {
        this.getDefaultPreferences().putInt(string, n);
    }

    public long getLong(String string) {
        return this.getPluginPreferences(true).getLong(string, this.getDefaultPreferences().getLong(string, 0L));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l == l2) {
            return;
        }
        Long l3 = new Long(l2);
        Long l4 = new Long(l);
        try {
            this.notify = false;
            if (this.getDefaultLong(string) == l) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).putLong(string, l);
            }
            this.firePropertyChangeEvent(string, l3, l4);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var8_8 = null;
            this.notify = true;
            return;
        }
    }

    public long getDefaultLong(String string) {
        return this.getDefaultPreferences().getLong(string, 0L);
    }

    public void setDefault(String string, long l) {
        this.getDefaultPreferences().putLong(string, l);
    }

    public String getString(String string) {
        return this.getPluginPreferences(true).get(string, this.getDefaultPreferences().get(string, ""));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        String string3 = this.getString(string);
        if (string2.equals(string3)) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultString(string).equals(string2)) {
                this.getPluginPreferences(true).remove(string);
            } else {
                this.getPluginPreferences(true).put(string, string2);
            }
            this.firePropertyChangeEvent(string, string3, string2);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.notify = true;
            return;
        }
    }

    public String getDefaultString(String string) {
        return this.getDefaultPreferences().get(string, "");
    }

    public void setDefault(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().put(string, string2);
    }

    public boolean isDefault(String string) {
        if (string == null) {
            return false;
        }
        return this.getPluginPreferences(true).get(string, null) == null;
    }

    public void setToDefault(String string) {
        EclipsePreferences eclipsePreferences = this.getPluginPreferences(true);
        String string2 = eclipsePreferences.get(string, null);
        if (string2 != null) {
            eclipsePreferences.remove(string);
        }
    }

    public String[] propertyNames() {
        return this.getPluginPreferences(true).keys();
    }

    public String[] defaultPropertyNames() {
        try {
            return this.getDefaultPreferences().keys();
        }
        catch (BackingStoreException backingStoreException) {
            this.logError(backingStoreException.getMessage(), (Exception)((Object)backingStoreException));
            return new String[0];
        }
    }

    public boolean needsSaving() {
        return this.getPluginPreferences(true).isDirty();
    }

    public void flush() throws BackingStoreException {
        EclipsePreferences eclipsePreferences = this.getPluginPreferences(false);
        if (eclipsePreferences != null) {
            eclipsePreferences.flush();
        }
    }

    private void logError(String string, Exception exception) {
        Status status = new Status(4, "org.eclipse.equinox.preferences", 4, string, (Throwable)exception);
        RuntimeLog.log((IStatus)status);
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.convertFromProperties(properties);
        try {
            this.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException.getMessage());
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        Properties properties = this.convertToProperties();
        properties.store(outputStream, string);
        try {
            this.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException.getMessage());
        }
    }

    private void convertFromProperties(Properties properties) {
        EclipsePreferences eclipsePreferences = this.getPluginPreferences(true);
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            eclipsePreferences.put(string, string2);
        }
    }

    public String toString() {
        return "PreferenceForwarder(" + this.pluginID + ")";
    }

    private Properties convertToProperties() {
        Properties properties = new Properties();
        String[] stringArray = this.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.getString(string);
            if (!"".equals(string2)) {
                properties.put(string, string2);
            }
            ++n;
        }
        return properties;
    }
}

