/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.contexts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextEvent;
import org.eclipse.core.commands.contexts.IContextListener;
import org.eclipse.core.internal.commands.util.Util;

public final class Context
extends NamedHandleObject
implements Comparable {
    private Set listeners = null;
    private String parentId = null;

    Context(String string) {
        super(string);
    }

    public final void addContextListener(IContextListener iContextListener) {
        if (iContextListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(iContextListener);
    }

    public final int compareTo(Object object) {
        Context context = (Context)object;
        int n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)context.id));
        if (n == 0 && (n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)context.name))) == 0 && (n = Util.compare((Comparable)((Object)this.parentId), (Comparable)((Object)context.parentId))) == 0 && (n = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)context.description))) == 0) {
            n = Util.compare(this.defined, context.defined);
        }
        return n;
    }

    public final void define(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("The name of a scheme cannot be null");
        }
        boolean bl = !this.defined;
        this.defined = true;
        boolean bl2 = !Util.equals(this.name, string);
        this.name = string;
        boolean bl3 = !Util.equals(this.description, string2);
        this.description = string2;
        boolean bl4 = !Util.equals(this.parentId, string3);
        this.parentId = string3;
        this.fireContextChanged(new ContextEvent(this, bl, bl2, bl3, bl4));
    }

    private final void fireContextChanged(ContextEvent contextEvent) {
        if (contextEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IContextListener iContextListener = (IContextListener)iterator.next();
            iContextListener.contextChanged(contextEvent);
        }
    }

    public final String getParentId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the parent identifier from an undefined context. " + this.id);
        }
        return this.parentId;
    }

    public final void removeContextListener(IContextListener iContextListener) {
        if (iContextListener == null) {
            throw new NullPointerException("Cannot remove a null listener.");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iContextListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Context(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.parentId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean bl = this.defined;
        this.defined = false;
        boolean bl2 = this.name != null;
        this.name = null;
        boolean bl3 = this.description != null;
        this.description = null;
        boolean bl4 = this.parentId != null;
        this.parentId = null;
        this.fireContextChanged(new ContextEvent(this, bl, bl2, bl3, bl4));
    }
}

