/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    protected HashMap adapterLookup = null;
    protected HashMap classLookup;
    protected HashMap classSearchOrderLookup;
    protected final HashMap factories = new HashMap(5);
    private ArrayList lazyFactoryProviders = new ArrayList(1);
    private static final AdapterManager singleton = new AdapterManager();

    public static AdapterManager getDefault() {
        return singleton;
    }

    private AdapterManager() {
    }

    private void addFactoriesFor(String string, Map map) {
        List list = (List)this.getFactories().get(string);
        if (list == null) {
            return;
        }
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            int n3;
            Object[] objectArray;
            IAdapterFactory iAdapterFactory = (IAdapterFactory)list.get(n);
            if (iAdapterFactory instanceof IAdapterFactoryExt) {
                objectArray = ((IAdapterFactoryExt)((Object)iAdapterFactory)).getAdapterNames();
                n3 = 0;
                while (n3 < objectArray.length) {
                    if (map.get(objectArray[n3]) == null) {
                        map.put(objectArray[n3], iAdapterFactory);
                    }
                    ++n3;
                }
            } else {
                objectArray = iAdapterFactory.getAdapterList();
                n3 = 0;
                while (n3 < objectArray.length) {
                    String string2 = ((Class)objectArray[n3]).getName();
                    if (map.get(string2) == null) {
                        map.put(string2, iAdapterFactory);
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private void cacheClassLookup(IAdapterFactory iAdapterFactory, Class clazz) {
        HashMap<String, Class> hashMap;
        HashMap<IAdapterFactory, HashMap<String, Class>> hashMap2 = this.classLookup;
        if (hashMap2 == null) {
            this.classLookup = hashMap2 = new HashMap<IAdapterFactory, HashMap<String, Class>>(4);
        }
        if ((hashMap = (HashMap<String, Class>)hashMap2.get(iAdapterFactory)) == null) {
            hashMap = new HashMap<String, Class>(4);
            hashMap2.put(iAdapterFactory, hashMap);
        }
        hashMap.put(clazz.getName(), clazz);
    }

    private Class cachedClassForName(IAdapterFactory iAdapterFactory, String string) {
        HashMap hashMap;
        Class clazz = null;
        HashMap hashMap2 = this.classLookup;
        if (hashMap2 != null && (hashMap = (HashMap)hashMap2.get(iAdapterFactory)) != null) {
            clazz = (Class)hashMap.get(string);
        }
        return clazz;
    }

    private Class classForName(IAdapterFactory iAdapterFactory, String string) {
        Class<?> clazz = this.cachedClassForName(iAdapterFactory, string);
        if (clazz == null) {
            try {
                if (iAdapterFactory instanceof IAdapterFactoryExt) {
                    iAdapterFactory = ((IAdapterFactoryExt)((Object)iAdapterFactory)).loadFactory(false);
                }
                if (iAdapterFactory != null) {
                    clazz = iAdapterFactory.getClass().getClassLoader().loadClass(string);
                    this.cacheClassLookup(iAdapterFactory, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return clazz;
    }

    public String[] computeAdapterTypes(Class clazz) {
        Set set = this.getFactories(clazz).keySet();
        return set.toArray(new String[set.size()]);
    }

    private Map getFactories(Class clazz) {
        HashMap hashMap;
        HashMap hashMap2 = this.adapterLookup;
        if (hashMap2 == null) {
            this.adapterLookup = hashMap2 = new HashMap(30);
        }
        if ((hashMap = (HashMap)hashMap2.get(clazz.getName())) == null) {
            hashMap = new HashMap(4);
            Class[] classArray = this.computeClassOrder(clazz);
            int n = 0;
            while (n < classArray.length) {
                this.addFactoriesFor(classArray[n].getName(), hashMap);
                ++n;
            }
            hashMap2.put(clazz.getName(), hashMap);
        }
        return hashMap;
    }

    public Class[] computeClassOrder(Class clazz) {
        ArrayList arrayList = null;
        HashMap hashMap = this.classSearchOrderLookup;
        if (hashMap != null) {
            arrayList = (ArrayList)hashMap.get(clazz);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.computeClassOrder(clazz, arrayList);
            if (hashMap == null) {
                this.classSearchOrderLookup = hashMap = new HashMap();
            }
            hashMap.put(clazz, arrayList);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void computeClassOrder(Class clazz, Collection collection) {
        Class clazz2 = clazz;
        HashSet hashSet = new HashSet(4);
        while (clazz2 != null) {
            collection.add(clazz2);
            this.computeInterfaceOrder(clazz2.getInterfaces(), collection, hashSet);
            clazz2 = clazz2.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class[] classArray, Collection collection, Set set) {
        ArrayList<Class> arrayList = new ArrayList<Class>(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (set.add(clazz)) {
                collection.add(clazz);
                arrayList.add(clazz);
            }
            ++n;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.computeInterfaceOrder(((Class)iterator.next()).getInterfaces(), collection, set);
        }
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    public Object getAdapter(Object object, Class clazz) {
        IAdapterFactory iAdapterFactory = (IAdapterFactory)this.getFactories(object.getClass()).get(clazz.getName());
        Object object2 = null;
        if (iAdapterFactory != null) {
            object2 = iAdapterFactory.getAdapter(object, clazz);
        }
        if (object2 == null && clazz.isInstance(object)) {
            return object;
        }
        return object2;
    }

    public Object getAdapter(Object object, String string) {
        return this.getAdapter(object, string, false);
    }

    private Object getAdapter(Object object, String string, boolean bl) {
        Class clazz;
        IAdapterFactory iAdapterFactory = (IAdapterFactory)this.getFactories(object.getClass()).get(string);
        if (bl && iAdapterFactory instanceof IAdapterFactoryExt) {
            iAdapterFactory = ((IAdapterFactoryExt)((Object)iAdapterFactory)).loadFactory(true);
        }
        Object object2 = null;
        if (iAdapterFactory != null && (clazz = this.classForName(iAdapterFactory, string)) != null) {
            object2 = iAdapterFactory.getAdapter(object, clazz);
        }
        if (object2 == null && object.getClass().getName().equals(string)) {
            return object;
        }
        return object2;
    }

    public boolean hasAdapter(Object object, String string) {
        return this.getFactories(object.getClass()).get(string) != null;
    }

    public Object loadAdapter(Object object, String string) {
        return this.getAdapter(object, string, true);
    }

    public synchronized void registerAdapters(IAdapterFactory iAdapterFactory, Class clazz) {
        this.registerFactory(iAdapterFactory, clazz.getName());
        this.flushLookup();
    }

    public void registerFactory(IAdapterFactory iAdapterFactory, String string) {
        ArrayList<IAdapterFactory> arrayList = (ArrayList<IAdapterFactory>)this.factories.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<IAdapterFactory>(5);
            this.factories.put(string, arrayList);
        }
        arrayList.add(iAdapterFactory);
    }

    public synchronized void unregisterAdapters(IAdapterFactory iAdapterFactory) {
        Iterator iterator = this.factories.values().iterator();
        while (iterator.hasNext()) {
            ((List)iterator.next()).remove(iAdapterFactory);
        }
        this.flushLookup();
    }

    public synchronized void unregisterAdapters(IAdapterFactory iAdapterFactory, Class clazz) {
        List list = (List)this.factories.get(clazz.getName());
        if (list == null) {
            return;
        }
        list.remove(iAdapterFactory);
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLazyFactoryProvider(IAdapterManagerProvider iAdapterManagerProvider) {
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            this.lazyFactoryProviders.add(iAdapterManagerProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterLazyFactoryProvider(IAdapterManagerProvider iAdapterManagerProvider) {
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            return this.lazyFactoryProviders.remove(iAdapterManagerProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getFactories() {
        if (this.lazyFactoryProviders.size() == 0) {
            return this.factories;
        }
        ArrayList arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            while (this.lazyFactoryProviders.size() > 0) {
                IAdapterManagerProvider iAdapterManagerProvider = (IAdapterManagerProvider)this.lazyFactoryProviders.remove(0);
                if (!iAdapterManagerProvider.addFactories(this)) continue;
                this.flushLookup();
            }
        }
        return this.factories;
    }
}

