/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public class ResolveExpression
extends CompositeExpression {
    private String fVariable;
    private Object[] fArgs;
    private static final String ATT_VARIABLE = "variable";
    private static final String ATT_ARGS = "args";
    private static final int HASH_INITIAL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.ResolveExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public ResolveExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fVariable = iConfigurationElement.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable);
        this.fArgs = Expressions.getArguments(iConfigurationElement, ATT_ARGS);
    }

    public ResolveExpression(String string, Object[] objectArray) {
        Assert.isNotNull((Object)string);
        this.fVariable = string;
        this.fArgs = objectArray;
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Object object = iEvaluationContext.resolveVariable(this.fVariable, this.fArgs);
        if (object == null) {
            throw new CoreException((IStatus)new ExpressionStatus(301, Messages.format(ExpressionMessages.ResolveExpression_variable_not_defined, this.fVariable)));
        }
        return this.evaluateAnd(new EvaluationContext(iEvaluationContext, object));
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        ExpressionInfo expressionInfo2 = new ExpressionInfo();
        super.collectExpressionInfo(expressionInfo2);
        if (expressionInfo2.hasDefaultVariableAccess()) {
            expressionInfo.addVariableNameAccess(this.fVariable);
        }
        expressionInfo.mergeExceptDefaultVariable(expressionInfo2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResolveExpression)) {
            return false;
        }
        ResolveExpression resolveExpression = (ResolveExpression)object;
        return this.fVariable.equals(resolveExpression.fVariable) && ResolveExpression.equals(this.fArgs, resolveExpression.fArgs) && ResolveExpression.equals(this.fExpressions, resolveExpression.fExpressions);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + ResolveExpression.hashCode(this.fExpressions) * 89 + ResolveExpression.hashCode(this.fArgs) * 89 + this.fVariable.hashCode();
    }
}

