/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class ImplicitJobs {
    private ThreadJob jobCache = null;
    protected JobManager manager;
    private final Set suspendedRules = new HashSet(20);
    private final Map threadJobs = new HashMap(20);

    ImplicitJobs(JobManager jobManager) {
        this.manager = jobManager;
    }

    /*
     * Exception decompiling
     */
    void begin(ISchedulingRule var1_1, IProgressMonitor var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 293->297)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void end(ISchedulingRule iSchedulingRule, boolean bl) {
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("End rule: " + iSchedulingRule);
        }
        if ((threadJob = (ThreadJob)this.threadJobs.get(Thread.currentThread())) == null) {
            Assert.isLegal((iSchedulingRule == null ? 1 : 0) != 0, (String)("endRule without matching beginRule: " + iSchedulingRule));
        } else if (threadJob.pop(iSchedulingRule)) {
            this.endThreadJob(threadJob, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endJob(InternalJob internalJob) {
        Status status;
        Thread thread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
            if (threadJob == null) {
                return;
            }
            String string = "Worker thread ended job: " + internalJob + ", but still holds rule: " + threadJob;
            status = new Status(4, "org.eclipse.core.jobs", 1, string, null);
            this.endThreadJob(threadJob, false);
        }
        try {
            RuntimeLog.log((IStatus)status);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(status.getMessage());
        }
    }

    private void endThreadJob(ThreadJob threadJob, boolean bl) {
        Thread thread = Thread.currentThread();
        this.threadJobs.remove(thread);
        ISchedulingRule iSchedulingRule = threadJob.getRule();
        if (bl && iSchedulingRule != null) {
            this.suspendedRules.remove(iSchedulingRule);
        }
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread, iSchedulingRule);
        }
        if (threadJob.isRunning()) {
            this.manager.endJob(threadJob, Status.OK_STATUS, false);
        }
        this.recycle(threadJob);
    }

    private boolean isSuspended(ISchedulingRule iSchedulingRule) {
        if (this.suspendedRules.size() == 0) {
            return false;
        }
        Iterator iterator = this.suspendedRules.iterator();
        while (iterator.hasNext()) {
            if (!((ISchedulingRule)iterator.next()).contains(iSchedulingRule)) continue;
            return true;
        }
        return false;
    }

    private ThreadJob newThreadJob(ISchedulingRule iSchedulingRule) {
        if (this.jobCache != null) {
            ThreadJob threadJob = this.jobCache;
            threadJob.setRule(iSchedulingRule);
            threadJob.isRunning = false;
            threadJob.acquireRule = false;
            threadJob.realJob = null;
            this.jobCache = null;
            return threadJob;
        }
        return new ThreadJob(this.manager, iSchedulingRule);
    }

    private void recycle(ThreadJob threadJob) {
        if (this.jobCache == null && threadJob.recycle()) {
            this.jobCache = threadJob;
        }
    }

    void resume(ISchedulingRule iSchedulingRule) {
        this.end(iSchedulingRule, true);
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Resume rule: " + iSchedulingRule);
        }
    }

    void suspend(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) {
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Suspend rule: " + iSchedulingRule);
        }
        this.begin(iSchedulingRule, iProgressMonitor, true);
    }

    synchronized void transfer(ISchedulingRule iSchedulingRule, Thread thread) {
        if (iSchedulingRule == null) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        if (thread2 == thread) {
            return;
        }
        ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
        Assert.isLegal((threadJob == null ? 1 : 0) != 0);
        threadJob = (ThreadJob)this.threadJobs.get(thread2);
        Assert.isLegal((threadJob != null ? 1 : 0) != 0);
        Assert.isLegal((threadJob.getRule() == iSchedulingRule ? 1 : 0) != 0);
        threadJob.setThread(thread);
        this.threadJobs.remove(thread2);
        this.threadJobs.put(thread, threadJob);
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread2, iSchedulingRule);
            this.manager.getLockManager().addLockThread(thread, iSchedulingRule);
        }
    }
}

